/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.dataeditor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.dialogs.ExtStatusDialog;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.dataeditor.IFindListener;
import org.eclipse.statet.r.ui.dataeditor.RDataTableComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class FindDataDialog
extends ExtStatusDialog {
    private static final Map<IWorkbenchWindow, FindDataDialog> gDialogs = new HashMap<IWorkbenchWindow, FindDataDialog>();
    private static final int FIND_NEXT_ID = 101;
    private static final int FIND_PREVIOUS_ID = 102;
    private final IWorkbenchWindow fWindow;
    private IWorkbenchPart fPart;
    private final PartListener fPartListener = new PartListener();
    private RDataTableComposite fTable;
    private Combo fTextControl;
    private Button fRExpressionModeControl;
    private Button fIsNaModeControl;
    private Button fDirectionFirstInColumnControl;
    private Button fDirectionFirstInRowControl;
    private Button fSelectedOnlyControl;
    private final Map<String, String> fHistoryModeMap = new HashMap<String, String>();
    private final IFindListener fFindListener = new IFindListener(){

        @Override
        public void handleFindEvent(IFindListener.FindEvent event) {
            FindDataDialog.this.updateStatus(event.status);
        }
    };

    public static FindDataDialog get(IWorkbenchWindow window, boolean create) {
        FindDataDialog dialog = gDialogs.get(window);
        if (dialog == null && create) {
            dialog = new FindDataDialog(window);
            dialog.create();
            gDialogs.put(window, dialog);
        }
        return dialog;
    }

    protected FindDataDialog(IWorkbenchWindow window) {
        super(window.getShell());
        this.fWindow = window;
        this.fWindow.getWorkbench().addWindowListener((IWindowListener)this.fPartListener);
        this.fWindow.getActivePage().addPartListener((IPartListener)this.fPartListener);
        this.fPart = this.fWindow.getActivePage().getActivePart();
        this.setTitle("Find");
        this.setShellStyle(this.getShellStyle() & 0xFFFEFFFF);
        this.setBlockOnOpen(false);
        this.setStatusLineAboveButtons(false);
        this.setHelpAvailable(false);
    }

    protected IDialogSettings getDialogSettings() {
        return DialogUtils.getDialogSettings((AbstractUIPlugin)RUIPlugin.getInstance(), (String)"RDataTable.FindDialog");
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.getDialogSettings();
    }

    public void create() {
        super.create();
        this.loadSettings();
    }

    public boolean close() {
        this.fWindow.getWorkbench().removeWindowListener((IWindowListener)this.fPartListener);
        IWorkbenchPage page = this.fWindow.getActivePage();
        if (page != null) {
            page.removePartListener((IPartListener)this.fPartListener);
        }
        gDialogs.remove(this.fWindow);
        this.saveSettings();
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)LayoutUtils.newDialogGrid((int)2));
        Composite textInput = this.createTextInput(composite);
        textInput.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Composite additionalOptions = this.createAdditionalOptions(composite);
        additionalOptions.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Composite directionOptions = this.createDirectionOptions(composite);
        directionOptions.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        LayoutUtils.addSmallFiller((Composite)composite, (boolean)false);
        Composite navigateButtons = this.createNavigateButtons(composite);
        navigateButtons.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 2, 1));
        FindDataDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected Composite createTextInput(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label.setText("Find:");
        this.fTextControl = new Combo(composite, 2052);
        this.fTextControl.setLayoutData((Object)LayoutUtils.hintWidth((GridData)new GridData(4, 0x1000000, true, false), (Combo)this.fTextControl, (int)25));
        this.fTextControl.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                FindDataDialog.this.updateStatus(null);
                FindDataDialog.this.updateState();
            }
        });
        this.fTextControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIdx;
                if (!FindDataDialog.this.fTextControl.getListVisible() && (selectionIdx = FindDataDialog.this.fTextControl.getSelectionIndex()) >= 0) {
                    FindDataDialog.this.loadQuery(FindDataDialog.this.fTextControl.getItem(selectionIdx));
                }
            }
        });
        return composite;
    }

    protected Composite createDirectionOptions(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setText("Direction");
        composite.setLayout((Layout)LayoutUtils.newGroupGrid((int)2, (boolean)true));
        this.fDirectionFirstInColumnControl = new Button((Composite)composite, 16);
        this.fDirectionFirstInColumnControl.setText("&Column, Row");
        this.fDirectionFirstInColumnControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fDirectionFirstInColumnControl.setSelection(true);
        this.fDirectionFirstInRowControl = new Button((Composite)composite, 16);
        this.fDirectionFirstInRowControl.setText("&Row, Column");
        this.fDirectionFirstInRowControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fSelectedOnlyControl = new Button((Composite)composite, 32);
        this.fSelectedOnlyControl.setText("Only Selec&ted Cells");
        this.fSelectedOnlyControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        return composite;
    }

    protected Composite createScopeOptions(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setText("Scope");
        composite.setLayout((Layout)LayoutUtils.newGroupGrid((int)1));
        Button button = new Button((Composite)composite, 16);
        button.setText("A&ll");
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        button.setSelection(true);
        this.fSelectedOnlyControl = new Button((Composite)composite, 32);
        this.fSelectedOnlyControl.setText("Selec&ted Cells");
        this.fSelectedOnlyControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return composite;
    }

    protected Composite createAdditionalOptions(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setText("Options");
        composite.setLayout((Layout)LayoutUtils.newGroupGrid((int)2, (boolean)true));
        this.fRExpressionModeControl = new Button((Composite)composite, 32);
        this.fRExpressionModeControl.setText("R expression");
        this.fRExpressionModeControl.setToolTipText("Use x to reference the object itself, e.g. 'x >= 1'");
        this.fRExpressionModeControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fRExpressionModeControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FindDataDialog.this.fRExpressionModeControl.getSelection()) {
                    FindDataDialog.this.fIsNaModeControl.setSelection(false);
                }
            }
        });
        this.fIsNaModeControl = new Button((Composite)composite, 32);
        this.fIsNaModeControl.setText("Is NA");
        this.fIsNaModeControl.setToolTipText("The search expression is ignored");
        this.fIsNaModeControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fIsNaModeControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FindDataDialog.this.fIsNaModeControl.getSelection()) {
                    FindDataDialog.this.fRExpressionModeControl.setSelection(false);
                }
            }
        });
        return composite;
    }

    protected Composite createNavigateButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)0));
        this.createButton(composite, 102, "&Previous", false);
        this.createButton(composite, 101, "&Next", true);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 12: {
                this.close();
                return;
            }
            case 101: {
                this.doFind(true);
                return;
            }
            case 102: {
                this.doFind(false);
                return;
            }
        }
    }

    private void loadQuery(String text) {
        if (text == null || text.isEmpty()) {
            return;
        }
        String mode = this.fHistoryModeMap.get(text);
        if (mode != null) {
            if ("r_expression".equals(mode)) {
                this.fRExpressionModeControl.setSelection(true);
                this.fIsNaModeControl.setSelection(false);
            } else {
                this.fRExpressionModeControl.setSelection(false);
            }
        }
    }

    private void doFind(boolean forward) {
        String expression = this.getExpression();
        if (!expression.equals("is.na(x)")) {
            String text = this.fTextControl.getText();
            int idx = this.fTextControl.indexOf(text);
            if (idx != 0) {
                if (idx > 0) {
                    this.fTextControl.remove(idx);
                }
                this.fTextControl.add(text, 0);
                this.fTextControl.setText(text);
            }
            this.fHistoryModeMap.put(text, this.fRExpressionModeControl.getSelection() ? "r_expression" : "default");
        }
        this.fTable.find(expression, this.fSelectedOnlyControl.getSelection(), this.fDirectionFirstInRowControl.getSelection(), forward);
    }

    protected String getExpression() {
        if (this.fRExpressionModeControl.getSelection()) {
            return this.fTextControl.getText();
        }
        if (this.fIsNaModeControl.getSelection()) {
            return "is.na(x)";
        }
        return "x == " + this.fTextControl.getText();
    }

    protected void loadSettings() {
        IDialogSettings settings = this.getDialogSettings();
        String[] history = DialogUtils.noNull((String[])settings.getArray("SearchText.history"));
        this.fTextControl.setItems(history);
        String[] historyModes = DialogUtils.noNull((String[])settings.getArray("SearchMode.history"));
        if (history.length == historyModes.length) {
            int i = 0;
            while (i < history.length) {
                this.fHistoryModeMap.put(history[i], historyModes[i]);
                ++i;
            }
        }
        if (history.length > 0) {
            this.fTextControl.setText(history[0]);
            this.loadQuery(history[0]);
        }
        if (settings.getBoolean("Direction.firstInRow")) {
            this.fDirectionFirstInColumnControl.setSelection(false);
            this.fDirectionFirstInRowControl.setSelection(true);
        } else {
            this.fDirectionFirstInColumnControl.setSelection(true);
            this.fDirectionFirstInRowControl.setSelection(false);
        }
    }

    protected void saveSettings() {
        IDialogSettings settings = this.getDialogSettings();
        String[] history = DialogUtils.combineHistoryItems((String[])this.fTextControl.getItems(), null);
        settings.put("SearchText.history", history);
        String[] historyModes = new String[history.length];
        int i = 0;
        while (i < history.length) {
            String mode = this.fHistoryModeMap.get(history[i]);
            if (mode == null) {
                mode = "default";
            }
            historyModes[i] = mode;
            ++i;
        }
        settings.put("SearchMode.history", historyModes);
        settings.put("Direction.firstInRow", this.fDirectionFirstInRowControl.getSelection());
    }

    public void update(IWorkbenchPart part) {
        if (part != null && this.fPart == part) {
            RDataTableComposite table = (RDataTableComposite)((Object)part.getAdapter(RDataTableComposite.class));
            if (this.fTable != null && this.fTable != table) {
                this.fTable.removeFindListener(this.fFindListener);
                this.updateStatus(null);
            }
            this.fTable = table;
            if (this.fTable != null) {
                table.addFindListener(this.fFindListener);
            }
            this.updateState();
        }
    }

    private void updateState() {
        boolean enabled = this.fTable != null && this.fTextControl.getText().length() > 0;
        this.getButton(101).setEnabled(enabled);
        this.getButton(102).setEnabled(enabled);
    }

    private class PartListener
    implements IWindowListener,
    IPartListener {
        private PartListener() {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            if (FindDataDialog.this.fWindow == window) {
                FindDataDialog.this.close();
            }
        }

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (FindDataDialog.this.fPart == part) {
                FindDataDialog.this.fPart = null;
            }
        }

        public void partActivated(IWorkbenchPart part) {
            FindDataDialog.this.fPart = part;
            FindDataDialog.this.update(part);
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }
    }
}

