/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.style.editor;

import org.eclipse.statet.ecommons.waltable.Messages;
import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.style.editor.AbstractEditorPanel;
import org.eclipse.statet.ecommons.waltable.style.editor.ColorPicker;
import org.eclipse.statet.ecommons.waltable.style.editor.FontPicker;
import org.eclipse.statet.ecommons.waltable.style.editor.GridStyleParameterObject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class GridColorsEditorPanel
extends AbstractEditorPanel<GridStyleParameterObject> {
    private FontPicker fontPicker;
    private ColorPicker evenRowColorPicker;
    private ColorPicker oddRowColorPicker;
    private ColorPicker selectionColorPicker;
    private IConfigRegistry configRegistry;

    public GridColorsEditorPanel(Composite parent, GridStyleParameterObject currentStyle) {
        super(parent, 0);
    }

    @Override
    public String getEditorName() {
        return Messages.getString("GridColorsEditorPanel.editorName");
    }

    @Override
    public GridStyleParameterObject getNewValue() {
        GridStyleParameterObject newStyle = new GridStyleParameterObject(this.configRegistry);
        newStyle.tableFont = this.fontPicker.getSelectedFont();
        newStyle.evenRowColor = this.evenRowColorPicker.getSelectedColor();
        newStyle.oddRowColor = this.oddRowColorPicker.getSelectedColor();
        newStyle.selectionColor = this.selectionColorPicker.getSelectedColor();
        return newStyle;
    }

    @Override
    public void edit(GridStyleParameterObject currentStyle) throws Exception {
        this.configRegistry = currentStyle.getConfigRegistry();
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = 10;
        this.setLayout((Layout)layout);
        new Label((Composite)this, 0).setText(Messages.getString("GridColorsEditorPanel.font"));
        this.fontPicker = new FontPicker(this, currentStyle.tableFont);
        this.fontPicker.setLayoutData(new GridData(100, 22));
        new Label((Composite)this, 0).setText(Messages.getString("GridColorsEditorPanel.evenRowColor"));
        this.evenRowColorPicker = new ColorPicker(this, currentStyle.evenRowColor);
        new Label((Composite)this, 0).setText(Messages.getString("GridColorsEditorPanel.oddRowColor"));
        this.oddRowColorPicker = new ColorPicker(this, currentStyle.oddRowColor);
        new Label((Composite)this, 0).setText(Messages.getString("GridColorsEditorPanel.selectionColor"));
        this.selectionColorPicker = new ColorPicker(this, currentStyle.selectionColor);
    }
}

