/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.console.ui.tools;

import java.util.List;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.console.ui.Messages;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.SystemRunnable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.NicoUI;
import org.eclipse.statet.nico.ui.util.ToolMessageDialog;
import org.eclipse.statet.r.console.core.AbstractRController;
import org.eclipse.statet.r.console.core.AbstractRDataRunnable;
import org.eclipse.statet.r.console.core.IRDataAdapter;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.core.pkgmanager.IRPkgInfoAndData;
import org.eclipse.statet.r.core.pkgmanager.IRPkgManager;
import org.eclipse.statet.r.core.pkgmanager.IRPkgSet;
import org.eclipse.statet.r.nico.impl.RjsController;
import org.eclipse.statet.r.ui.pkgmanager.RPkgManagerUI;
import org.eclipse.statet.r.ui.pkgmanager.StartAction;
import org.eclipse.statet.rj.renv.core.REnvConfiguration;
import org.eclipse.statet.rj.renv.core.RPkgList;
import org.eclipse.statet.rj.services.RService;
import org.eclipse.statet.rj.services.RVersion;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class REnvAutoUpdater
extends AbstractRDataRunnable
implements SystemRunnable {
    private final IRPkgManager manager;
    private boolean initial = true;
    private boolean versionChecked;
    private int checkStamp;

    public static void connect(RjsController controller, IRPkgManager manager) {
        if (controller == null || manager == null) {
            return;
        }
        REnvAutoUpdater checker = new REnvAutoUpdater(manager);
        controller.getTool().getQueue().addOnIdle((SystemRunnable)checker, 1000);
    }

    private REnvAutoUpdater(IRPkgManager manager) {
        super("r/renv/check", Messages.REnvIndex_Check_task);
        this.manager = manager;
    }

    public boolean changed(int event, Tool tool) {
        return event != 289;
    }

    protected void run(IRDataAdapter r, ProgressMonitor m) throws StatusException {
        AbstractRController rjs = (AbstractRController)r;
        if (rjs.isBusy() || !r.isDefaultPrompt() || r.getChangeStamp() == this.checkStamp) {
            return;
        }
        int flags = 0;
        if (this.initial) {
            this.initial = false;
            flags |= 0x100000;
        }
        this.manager.check(flags, (RService)r, m);
        this.checkStamp = r.getChangeStamp();
        if (!this.versionChecked) {
            this.versionChecked = true;
            this.checkRVersion(r, m);
        }
    }

    private void checkRVersion(IRDataAdapter r, ProgressMonitor m) throws StatusException {
        RVersion rVersion = r.getPlatform().getRVersion();
        REnvConfiguration rEnvConfig = (REnvConfiguration)this.manager.getREnv().get(REnvConfiguration.class);
        if (rEnvConfig == null) {
            return;
        }
        Preference.StringPref2 pref = new Preference.StringPref2("org.eclipse.statet.r.core/r.environments/" + rEnvConfig.getREnv().getId(), "CheckedR.version");
        String s = (String)PreferenceUtils.getInstancePrefs().getPreferenceValue((Preference)pref);
        if (s != null) {
            RVersion checkedVersion = new RVersion(s);
            if (!checkedVersion.equals((Object)rVersion)) {
                IRPkgSet.Ext rPkgDataset;
                PreferenceUtils.setPrefValue((IScopeContext)InstanceScope.INSTANCE, (Preference)pref, (Object)rVersion.toString(), (int)1);
                if ((checkedVersion.getMajor() != rVersion.getMajor() || checkedVersion.getMinor() != rVersion.getMinor()) && this.hasNonBasePackages(rPkgDataset = (IRPkgSet.Ext)this.manager.getDataset(49, (RService)r, m))) {
                    this.handleNewVersion(rEnvConfig, r.getTool(), (IRPkgManager.Ext)this.manager, checkedVersion, rVersion);
                }
            }
        } else {
            PreferenceUtils.setPrefValue((IScopeContext)InstanceScope.INSTANCE, (Preference)pref, (Object)rVersion.toString(), (int)1);
        }
    }

    private static String mainVersionString(RVersion version) {
        StringBuilder sb = new StringBuilder(8);
        sb.append(version.getMajor());
        sb.append('.');
        sb.append(version.getMinor());
        return sb.toString();
    }

    private boolean hasNonBasePackages(IRPkgSet.Ext pkgSet) {
        List all = pkgSet.getInstalled().getAll();
        for (RPkgList pkgList : all) {
            for (IRPkgInfoAndData pkg : pkgList) {
                if (pkg.getLibLocation() != null && pkg.getLibLocation().getSource() == "eplugin" || "base".equals(pkg.getPriority())) continue;
                return true;
            }
        }
        return false;
    }

    private void handleNewVersion(final REnvConfiguration rEnvConfig, final RProcess tool, final IRPkgManager.Ext rPkgManager, final RVersion oldVersion, final RVersion newVersion) {
        IWorkbenchPage page = NicoUI.getToolRegistry().findWorkbenchPage((ToolProcess)tool);
        final Shell shell = page.getWorkbenchWindow().getShell();
        Display display = UIAccess.getDisplay((Shell)shell);
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ToolMessageDialog.openQuestion((ToolProcess)tool, (Shell)shell, (String)Messages.REnvIndex_NewVersion_title, (String)NLS.bind((String)Messages.REnvIndex_NewVersion_message, (Object[])new Object[]{rEnvConfig.getName(), REnvAutoUpdater.mainVersionString(oldVersion), REnvAutoUpdater.mainVersionString(newVersion)}))) {
                    RPkgManagerUI.openDialog((IRPkgManager.Ext)rPkgManager, (RProcess)tool, (Shell)shell, (StartAction)new StartAction(3));
                }
            }
        });
    }
}

