/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.console.ui.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.ts.ui.ToolRunnableDecorator;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.console.ui.Messages;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.jcommons.ts.core.ToolService;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.NicoUI;
import org.eclipse.statet.nico.ui.NicoUITools;
import org.eclipse.statet.nico.ui.ToolSessionUIData;
import org.eclipse.statet.nico.ui.console.NIConsole;
import org.eclipse.statet.nico.ui.console.NIConsolePage;
import org.eclipse.statet.r.console.core.IRBasicAdapter;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsoleViewer;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.PageBookView;

public class AdjustWidthHandler
extends AbstractHandler {
    public void setEnabled(Object evaluationContext) {
        this.setBaseEnabled(evaluationContext instanceof IEvaluationContext && this.isValid((ToolProcess)((IEvaluationContext)evaluationContext).getVariable("org.eclipse.statet.activeTool")));
    }

    private boolean isValid(ToolProcess process) {
        return process != null && process.getMainType() == "R" && !process.isTerminated();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        int width;
        ToolSessionUIData session = NicoUI.getToolRegistry().getActiveToolSession(UIAccess.getActiveWorkbenchPage((boolean)true));
        if (!this.isValid(session.getProcess())) {
            return null;
        }
        NIConsole console = session.getConsole();
        if (console == null) {
            return null;
        }
        IConsoleView consoleView = NicoUITools.getConsoleView((NIConsole)console, (IWorkbenchPage)session.getPage());
        if (consoleView == null || !(consoleView instanceof PageBookView)) {
            return null;
        }
        consoleView.display((IConsole)console);
        IPage page = ((PageBookView)consoleView).getCurrentPage();
        if (page instanceof NIConsolePage && ((NIConsolePage)page).getConsole() == console && (width = this.getWidth(((NIConsolePage)page).getOutputViewer())) >= 0) {
            if (width < 10) {
                width = 10;
            }
            console.getProcess().getQueue().add((ToolRunnable)new AdjustWidthRunnable(width));
        }
        return null;
    }

    private int getWidth(TextConsoleViewer viewer) {
        if (UIAccess.isOkToUse((Viewer)viewer)) {
            GC gc = new GC((Drawable)Display.getCurrent());
            try {
                gc.setFont(viewer.getTextWidget().getFont());
                FontMetrics fontMetrics = gc.getFontMetrics();
                int charWidth = fontMetrics.getAverageCharWidth();
                int clientWidth = viewer.getTextWidget().getClientArea().width;
                int n = clientWidth / charWidth;
                return n;
            }
            finally {
                gc.dispose();
            }
        }
        return -1;
    }

    private static class AdjustWidthRunnable
    implements ToolRunnable,
    ToolRunnableDecorator {
        private final int fWidth;

        public AdjustWidthRunnable(int width) {
            this.fWidth = width;
        }

        public String getTypeId() {
            return "r/console/width";
        }

        public Image getImage() {
            return ConsolePlugin.getImage((String)"IMG_VIEW_CONSOLE");
        }

        public String getLabel() {
            return Messages.AdjustWidth_task;
        }

        public boolean canRunIn(Tool tool) {
            return tool.isProvidingFeatureSet("org.eclipse.statet.r.basic");
        }

        public boolean changed(int event, Tool tool) {
            return event != 289;
        }

        public void run(ToolService service, ProgressMonitor m) throws StatusException {
            IRBasicAdapter r = (IRBasicAdapter)service;
            r.submitToConsole("options(width = " + this.fWidth + "L)", m);
        }
    }
}

