/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.core.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.statet.internal.rhelp.core.FIO;
import org.eclipse.statet.internal.rhelp.core.REnvHelpIndex;
import org.eclipse.statet.internal.rhelp.core.RHelpSearchMatchImpl;
import org.eclipse.statet.internal.rhelp.core.SerUtil;
import org.eclipse.statet.internal.rhelp.core.server.NotFoundException;
import org.eclipse.statet.internal.rhelp.core.server.ResponseException;
import org.eclipse.statet.internal.rhelp.core.server.ServerApi;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.Statuses;
import org.eclipse.statet.rhelp.core.REnvHelpConfiguration;
import org.eclipse.statet.rhelp.core.RHelpPage;
import org.eclipse.statet.rhelp.core.RHelpSearchMatch;
import org.eclipse.statet.rhelp.core.RHelpSearchQuery;
import org.eclipse.statet.rhelp.core.RHelpSearchRequestor;
import org.eclipse.statet.rhelp.core.RPkgHelp;

@NonNullByDefault
public abstract class ServerREnvHelpAccess
implements REnvHelpIndex {
    protected static final String[] NO_PARAMS = new String[0];
    private final URI url;
    private final String basePath;
    private final String rEnvId;
    private final String path;
    private final SerUtil serUtil = new SerUtil();

    public ServerREnvHelpAccess(URI uri) {
        this.url = uri;
        String uriPath = (String)ObjectUtils.nonNullAssert((Object)uri.getPath());
        int idStart = uriPath.lastIndexOf(47);
        this.basePath = uriPath.substring(0, idStart);
        this.rEnvId = uriPath.substring(idStart + 1);
        this.path = String.valueOf(this.basePath) + "/rhelp" + '/' + "api/v1" + '/' + this.rEnvId + '/';
    }

    @Override
    public void dispose() {
    }

    protected final String getBasePath() {
        return this.basePath;
    }

    protected final String createPath(String s1) {
        StringBuilder sb = new StringBuilder(this.path.length() + s1.length());
        sb.append(this.path);
        sb.append(s1);
        return sb.toString();
    }

    protected final String createPath(String s1, String s2) {
        StringBuilder sb = new StringBuilder(this.path.length() + s1.length() + s2.length() + 1);
        sb.append(this.path);
        sb.append(s1);
        sb.append('/');
        sb.append(s2);
        return sb.toString();
    }

    protected final String createPath(String s1, String s2, String s3) {
        StringBuilder sb = new StringBuilder(this.path.length() + s1.length() + s2.length() + s3.length() + 2);
        sb.append(this.path);
        sb.append(s1);
        sb.append('/');
        sb.append(s2);
        sb.append('/');
        sb.append(s3);
        return sb.toString();
    }

    protected final String createPath(String s1, String s2, String s3, String s4) {
        StringBuilder sb = new StringBuilder(this.path.length() + s1.length() + s2.length() + s3.length() + s4.length() + 3);
        sb.append(this.path);
        sb.append(s1);
        sb.append('/');
        sb.append(s2);
        sb.append('/');
        sb.append(s3);
        sb.append('/');
        sb.append(s4);
        return sb.toString();
    }

    protected URI createUrl(String path) {
        try {
            return new URI(this.url.getScheme(), null, this.url.getHost(), this.url.getPort(), path, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected StatusException onCancelled() {
        return new StatusException(Statuses.CANCEL_STATUS);
    }

    protected StatusException onTimeout(@Nullable Throwable e) {
        return new StatusException((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", 1001, "R help server access - Timeout.", e));
    }

    protected StatusException onConnectError(@Nullable Throwable e) {
        return new StatusException((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", 1002, "R help server access - Failed to connect to server.", e));
    }

    protected StatusException onFailed(@Nullable Throwable e) {
        ErrorStatus status = new ErrorStatus("org.eclipse.statet.rhelp.core", "R help server access - Failed to perform search.", e);
        CommonsRuntime.log((Status)status);
        return new StatusException((Status)status);
    }

    protected abstract @Nullable InputStream getDataStream(URI var1, @Nullable String var2) throws StatusException, ResponseException;

    protected abstract InputStream getDataStream(URI var1, String[] var2, byte[] var3) throws StatusException, ResponseException;

    protected abstract byte[] getDataStreamBytes(URI var1, String[] var2, int var3, @Nullable ProgressMonitor var4) throws StatusException, ResponseException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loadREnvHelpData(REnvHelpConfiguration rEnvConfig, long currentStamp, SerUtil.Controller saveCheck) throws Exception {
        Throwable throwable = null;
        Object var6_6 = null;
        try (InputStream in = this.getDataStream(this.createUrl(this.createPath("basic-data")), ServerApi.createETag(currentStamp));){
            if (in != null) return this.serUtil.save(rEnvConfig, in, saveCheck);
            return false;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    @Override
    public List<RHelpPage> getPagesForTopic(String topic, Map<String, RPkgHelp> packageMap, int timeout, @Nullable ProgressMonitor m) throws StatusException {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (FIO fio = FIO.get(new ByteArrayInputStream(this.getDataStreamBytes(this.createUrl(this.createPath("pages")), new String[]{"topic", topic}, timeout, m)));){
                int n = fio.readInt();
                ArrayList<RHelpPage> pages = new ArrayList<RHelpPage>(n);
                int i = 0;
                while (i < n) {
                    RHelpPage page;
                    String pkgName = (String)ObjectUtils.nonNullAssert((Object)fio.readString());
                    String pageName = (String)ObjectUtils.nonNullAssert((Object)fio.readString());
                    RPkgHelp pkgHelp = packageMap.get(pkgName);
                    if (pkgHelp != null && (page = pkgHelp.getPage(pageName)) != null) {
                        pages.add(page);
                    }
                    ++i;
                }
                return pages;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            return ImCollections.emptyList();
        }
    }

    @Override
    public @Nullable String getHtmlPage(RPkgHelp pkgHelp, String pageName, @Nullable String queryString, int timeout, @Nullable ProgressMonitor m) throws StatusException {
        try {
            Throwable throwable = null;
            Object var7_11 = null;
            try {
                String[] stringArray;
                URI uRI = this.createUrl(this.createPath("pkgs", pkgHelp.getName(), "pages", pageName));
                if (queryString != null) {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = "qs";
                    stringArray = stringArray2;
                    stringArray2[1] = queryString;
                } else {
                    stringArray = NO_PARAMS;
                }
                try (FIO fio = FIO.get(new ByteArrayInputStream(this.getDataStreamBytes(uRI, stringArray, timeout, m)));){
                    return fio.readString();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (NotFoundException e) {
            return null;
        }
        catch (StatusException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.onFailed(e);
        }
    }

    @Override
    public void search(RHelpSearchQuery searchQuery, List<RPkgHelp> packageList, Map<String, RPkgHelp> packageMap, RHelpSearchRequestor requestor) throws StatusException {
        FIO fio;
        Object var7_12;
        ByteArrayOutputStream requestData = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            var7_12 = null;
            try {
                fio = FIO.get(requestData);
                try {
                    fio.writeInt(searchQuery.getSearchType());
                    fio.writeString(searchQuery.getSearchString());
                    fio.writeStringList((List<String>)searchQuery.getEnabledFields());
                    fio.writeStringList((List<String>)searchQuery.getKeywords());
                    fio.writeStringList((List<String>)searchQuery.getPackages());
                }
                finally {
                    if (fio != null) {
                        fio.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw this.onFailed(e);
        }
        try {
            Throwable e = null;
            var7_12 = null;
            try {
                fio = FIO.get(this.getDataStream(this.createUrl(this.createPath("search")), new String[]{"maxFragments", Integer.toString(requestor.getMaxFragments())}, requestData.toByteArray()));
                try {
                    byte matchType;
                    block20: while (true) {
                        matchType = fio.readByte();
                        switch (matchType) {
                            case 0: {
                                return;
                            }
                            case 1: {
                                RHelpPage page;
                                RPkgHelp pkgHelp;
                                RHelpSearchMatch.MatchFragment[] fragments;
                                String pkgName = fio.readNonNullString();
                                String pageName = fio.readNonNullString();
                                float score = fio.readFloat();
                                int matchCount = fio.readInt();
                                if (matchCount >= 0) {
                                    int nFragments = fio.readInt();
                                    fragments = new RHelpSearchMatch.MatchFragment[nFragments];
                                    int i = 0;
                                    while (i < nFragments) {
                                        String field = fio.readNonNullString();
                                        String text = fio.readNonNullString();
                                        fragments[i] = new RHelpSearchMatchImpl.Fragment(field, text);
                                        ++i;
                                    }
                                } else {
                                    fragments = null;
                                }
                                if ((pkgHelp = packageMap.get(pkgName)) == null || (page = pkgHelp.getPage(pageName)) == null) continue block20;
                                RHelpSearchMatchImpl match = matchCount >= 0 ? new RHelpSearchMatchImpl(page, score, matchCount, fragments) : new RHelpSearchMatchImpl(page, score);
                                requestor.matchFound(match);
                                continue block20;
                            }
                        }
                        break;
                    }
                    throw new IOException("type= " + matchType);
                }
                finally {
                    if (fio != null) {
                        fio.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (StatusException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.onFailed(e);
        }
    }
}

