/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.io.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.statet.ecommons.io.FileUtil;
import org.eclipse.statet.ecommons.io.internal.Messages;

public class WorkspaceUtilImpl
extends FileUtil {
    private static final InputStream EMPTY_INPUT = new ByteArrayInputStream(new byte[0]);
    private static final String LABEL_2_WORKSPACE = "' (" + Messages.FileType_Workspace_name + ")";
    private final IFile fFile;

    public WorkspaceUtilImpl(IFile file) {
        this.fFile = file;
    }

    @Override
    public String getLabel() {
        return "'" + this.fFile.getFullPath().makeAbsolute().toString() + LABEL_2_WORKSPACE;
    }

    @Override
    public URI getURI() {
        return this.fFile.getLocationURI();
    }

    @Override
    public long getTimeStamp(IProgressMonitor monitor) throws CoreException {
        long stamp = this.fFile.getLocalTimeStamp();
        return stamp;
    }

    @Override
    public FileUtil.ReadTextFileOperation createReadTextFileOp(final FileUtil.ReaderAction action) {
        return new FileUtil.ReadTextFileOperation(this){

            @Override
            protected FileUtil.FileInput getInput(IProgressMonitor monitor) throws CoreException, IOException {
                try {
                    InputStream raw = WorkspaceUtilImpl.this.fFile.getContents(true);
                    FileUtil.FileInput fileInput = new FileUtil.FileInput(raw, WorkspaceUtilImpl.this.fFile.getCharset(true));
                    return fileInput;
                }
                finally {
                    monitor.done();
                }
            }

            @Override
            protected FileUtil.ReaderAction getAction() {
                return action;
            }

            @Override
            public void doOperation(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
                this.runAsWorkspaceRunnable(monitor, null);
            }
        };
    }

    @Override
    public FileUtil.WriteTextFileOperation createWriteTextFileOp(final String content) {
        return new FileUtil.WriteTextFileOperation(this){

            @Override
            public void doOperation(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
                ISchedulingRule rule = WorkspaceUtilImpl.this.fFile.exists() ? WorkspaceUtilImpl.this.fFile.getWorkspace().getRuleFactory().modifyRule((IResource)WorkspaceUtilImpl.this.fFile) : WorkspaceUtilImpl.this.fFile.getWorkspace().getRuleFactory().createRule((IResource)WorkspaceUtilImpl.this.fFile);
                this.runAsWorkspaceRunnable(monitor, rule);
            }

            @Override
            protected void writeImpl(IProgressMonitor monitor) throws CoreException, UnsupportedEncodingException {
                boolean exists = WorkspaceUtilImpl.this.fFile.exists();
                if (exists && (this.fMode & 1) != 0) {
                    if (this.fForceCharset) {
                        WorkspaceUtilImpl.this.fFile.setCharset(this.fCharset, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                    } else {
                        this.fCharset = WorkspaceUtilImpl.this.fFile.getCharset(true);
                        monitor.worked(20);
                    }
                    WorkspaceUtilImpl.this.fFile.appendContents((InputStream)new ByteArrayInputStream(content.getBytes(this.fCharset)), 3, (IProgressMonitor)new SubProgressMonitor(monitor, 80));
                } else {
                    if (exists && (this.fMode & 2) != 0) {
                        WorkspaceUtilImpl.this.fFile.setContents(EMPTY_INPUT, 3, (IProgressMonitor)new SubProgressMonitor(monitor, 15));
                    } else {
                        WorkspaceUtilImpl.this.fFile.create(EMPTY_INPUT, 1, (IProgressMonitor)new SubProgressMonitor(monitor, 15));
                    }
                    if (this.fForceCharset || !this.fCharset.equals(WorkspaceUtilImpl.this.fFile.getCharset(true))) {
                        WorkspaceUtilImpl.this.fFile.setCharset(this.fCharset, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
                    } else {
                        monitor.worked(5);
                    }
                    WorkspaceUtilImpl.this.fFile.setContents((InputStream)new ByteArrayInputStream(content.getBytes(this.fCharset)), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 80));
                }
            }
        };
    }
}

