/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.base.ui.processing.actions;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingManager;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingUI;
import org.eclipse.statet.docmlet.base.ui.sourceediting.IDocEditor;
import org.eclipse.statet.ecommons.debug.ui.config.LaunchConfigManager;
import org.eclipse.statet.ecommons.debug.ui.config.actions.ActionUtil;
import org.eclipse.statet.ecommons.debug.ui.config.actions.RunActiveConfigScopeHandler;
import org.eclipse.statet.ecommons.ui.actions.WorkbenchScopingHandler;
import org.eclipse.statet.internal.docmlet.base.ui.processing.DocActionUtil;
import org.eclipse.statet.jcommons.collections.CollectionUtils;
import org.eclipse.statet.jcommons.collections.ImIdentitySet;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.IElementUpdater;

public class RunActiveDocConfigWorkbenchHandler
extends WorkbenchScopingHandler
implements IElementUpdater,
IExecutableExtension {
    private ImIdentitySet<String> launchFlags;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        block4: {
            super.setInitializationData(config, propertyName, data);
            try {
                Map parameters = data instanceof Map ? (Map)data : Collections.emptyMap();
                String s = (String)parameters.get("launchFlags");
                if (s != null) {
                    this.launchFlags = CollectionUtils.toIdentifierSet((String[])s.split(";"));
                    break block4;
                }
                if (this.launchFlags != null) break block4;
                if (this.getCommandId() != null) {
                    this.launchFlags = this.getCommandLaunchFlags(this.getCommandId());
                    break block4;
                }
                throw new IllegalArgumentException("launchFlags= <missing>");
            }
            catch (IllegalArgumentException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", 0, NLS.bind((String)"Invalid declaration of contribution by ''{0}''.", (Object)config.getContributor().getName()), (Throwable)e));
            }
        }
    }

    protected ImIdentitySet<String> getLaunchFlags() {
        return this.launchFlags;
    }

    protected ImIdentitySet<String> getCommandLaunchFlags(String commandId) {
        switch (commandId) {
            case "org.eclipse.statet.docmlet.commands.ProcessAndPreviewDefault": {
                return DocProcessingUI.CommonFlags.PROCESS_AND_PREVIEW;
            }
            case "org.eclipse.statet.docmlet.commands.ProcessDocDefault": {
                return DocProcessingUI.CommonFlags.PROCESS;
            }
            case "org.eclipse.statet.docmlet.commands.PreviewDocDefault": {
                return DocProcessingUI.CommonFlags.OPEN_OUTPUT;
            }
        }
        throw new IllegalArgumentException("commandId= " + commandId);
    }

    protected ScopeHandler createScopeHandler(Object scope) {
        return new ScopeHandler(scope, this.getCommandId(), this.getLaunchFlags());
    }

    private static class ScopeHandler
    extends RunActiveConfigScopeHandler<IFile>
    implements LaunchConfigManager.Listener {
        private String lastTypeId;

        public ScopeHandler(Object scope, String commandId, ImIdentitySet<String> launchFlags) {
            super(scope, commandId, (ActionUtil)new DocActionUtil(1), launchFlags);
        }

        private IContentType getType() {
            IWorkbenchWindow window = this.getWindow();
            IEditorPart editor = window.getActivePage().getActiveEditor();
            if (editor instanceof IDocEditor) {
                return ((IDocEditor)editor).getContentType();
            }
            return null;
        }

        protected synchronized byte updateManager(IEvaluationContext context) {
            DocProcessingManager manager;
            IContentType type = this.getType();
            if (type != null) {
                if (type.getId() == this.lastTypeId) {
                    return 0;
                }
                this.lastTypeId = type.getId();
                manager = DocProcessingUI.getDocProcessingManager(type, true);
            } else {
                this.lastTypeId = null;
                manager = null;
            }
            return this.updateManager(manager);
        }
    }
}

