/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.base.ui.processing;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingConfig;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingConfigMainTab;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingConfigStepTab;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingOperationSettings;
import org.eclipse.statet.ecommons.databinding.core.observable.WritableEqualityValue;
import org.eclipse.statet.ecommons.databinding.core.validation.UpdateableErrorValidator;
import org.eclipse.statet.ecommons.resources.core.variables.ObservableResourcePathVariable;
import org.eclipse.statet.ecommons.resources.core.variables.ResourceVariableResolver;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.util.VariableFilterUtils;
import org.eclipse.statet.ecommons.ui.workbench.ResourceInputComposite;
import org.eclipse.statet.ecommons.variables.core.ObservableValueVariable;
import org.eclipse.statet.ecommons.variables.core.VariableText2;
import org.eclipse.statet.ecommons.variables.core.VariableUtils;
import org.eclipse.statet.internal.docmlet.base.ui.processing.Messages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public abstract class DocProcessingConfigIOStepTab
extends DocProcessingConfigStepTab {
    private static final String OUTPUT_PATH_DEFAULT_VALUE = "${file_name_base}.${out_file_ext}";
    private final String outputFormatAttrName;
    private final String outputFilePathAttrName;
    private final IObservableValue<DocProcessingConfig.Format> inputFormatValue;
    private final IObservableValue<DocProcessingConfig.Format> outputFormatValue;
    private final IObservableValue<String> outputFileExtValue;
    private final IObservableValue<String> outputFilePathValue;
    private ImList<DocProcessingConfig.Format> availableOutputFormats;
    private DocProcessingConfig.Format defaultOutputFormat;
    private final IObservableValue<IFile> resolvedInputFileValue;
    private final IObservableValue<String> resolvedOutputFileExtValue;
    private final IObservableValue<IFile> resolvedOutputFileValue;
    private final Matcher validExtMatcher = DocProcessingConfig.VALID_EXT_PATTERN.matcher("");
    private Label inputControl;
    private ComboViewer outputViewer;
    private Text outputExtControl;
    private ResourceInputComposite outputPathControl;
    private IObservableValue<IResource> outputPathResourceValue;

    public DocProcessingConfigIOStepTab(DocProcessingConfigMainTab mainTab, String stepEnabledAttrName) {
        super(mainTab, stepEnabledAttrName);
        this.outputFormatAttrName = String.valueOf(this.getAttrQualifier()) + '/' + "Output.Format.key";
        this.outputFilePathAttrName = String.valueOf(this.getAttrQualifier()) + '/' + "Output.File.path";
        Realm realm = this.getRealm();
        this.inputFormatValue = new WritableValue(realm, null, DocProcessingConfig.Format.class);
        this.inputFormatValue.addValueChangeListener((IValueChangeListener)this);
        this.outputFormatValue = new WritableValue(realm, null, DocProcessingConfig.Format.class);
        this.outputFormatValue.addValueChangeListener((IValueChangeListener)this);
        this.outputFileExtValue = new WritableValue(realm, null, String.class);
        this.outputFileExtValue.addValueChangeListener((IValueChangeListener)this);
        this.outputFilePathValue = new WritableValue(realm, null, String.class);
        this.resolvedInputFileValue = new WritableEqualityValue(realm, null, IFile.class);
        this.resolvedInputFileValue.addValueChangeListener((IValueChangeListener)this);
        this.resolvedOutputFileExtValue = new WritableEqualityValue(realm, null, String.class);
        this.resolvedOutputFileValue = new WritableEqualityValue(realm, null, IFile.class);
    }

    @Override
    protected void initVariables(Map<String, IStringVariable> variables) {
        variables.putAll(this.getMainTab().getSourceFileVariables());
        VariableUtils.add(variables, (IStringVariable)new ObservableResourcePathVariable((IStringVariable)DocProcessingConfig.IN_FILE_PATH_VAR, this.resolvedInputFileValue));
        VariableUtils.add(variables, (Collection)INPUT_RESOURCE_VAR_DEFS, (IDynamicVariableResolver)new ResourceVariableResolver(new ResourceVariableResolver.Context(){

            public IResource getResource() {
                return (IResource)DocProcessingConfigIOStepTab.this.resolvedInputFileValue.getValue();
            }
        }, 0));
        VariableUtils.add(variables, (IStringVariable)new ObservableValueVariable((IStringVariable)DocProcessingConfig.OUT_FILE_EXT_VAR, this.resolvedOutputFileExtValue));
        VariableUtils.add(variables, (IStringVariable)new ObservableResourcePathVariable((IStringVariable)DocProcessingConfig.OUT_FILE_PATH_VAR, this.resolvedOutputFileValue));
    }

    protected void setInput(DocProcessingConfig.Format format, IFile file) {
        if (format != null && format.equals(this.inputFormatValue.getValue())) {
            this.resolvedInputFileValue.setValue((Object)file);
        } else if (file == null || !file.equals(this.resolvedInputFileValue.getValue())) {
            this.resolvedInputFileValue.setValue(null);
            this.inputFormatValue.setValue((Object)format);
            this.resolvedInputFileValue.setValue((Object)file);
        } else {
            this.inputFormatValue.setValue((Object)format);
        }
    }

    protected void setAvailableOutputFormats(List<DocProcessingConfig.Format> formats, String defaultKey) {
        if (formats == null) {
            throw new NullPointerException("formats");
        }
        if (defaultKey == null) {
            throw new NullPointerException("defaultKey");
        }
        this.availableOutputFormats = ImCollections.toList(formats);
        this.defaultOutputFormat = DocProcessingConfig.getFormat(formats, null, defaultKey);
        if (this.defaultOutputFormat == null) {
            this.availableOutputFormats = null;
            throw new IllegalArgumentException("defaultKey: default format not found");
        }
        if (this.outputViewer != null) {
            this.outputViewer.setInput(formats);
        }
    }

    protected DocProcessingConfig.Format getOutputFormat(String key, boolean fallbackDefault) {
        return DocProcessingConfig.getFormat(this.availableOutputFormats, fallbackDefault ? this.defaultOutputFormat : null, key);
    }

    protected void setOutputFormat(DocProcessingConfig.Format format) {
        this.outputFormatValue.setValue((Object)format);
    }

    public DocProcessingConfig.Format getInputFormat() {
        return (DocProcessingConfig.Format)this.inputFormatValue.getValue();
    }

    public IFile getInputFile() {
        return (IFile)this.resolvedInputFileValue.getValue();
    }

    public IObservableValue<IFile> getInputFileValue() {
        return this.resolvedInputFileValue;
    }

    public DocProcessingConfig.Format getOutputFormat() {
        return (DocProcessingConfig.Format)this.outputFormatValue.getValue();
    }

    public IObservableValue<String> getOutputFileExtValue() {
        return this.resolvedOutputFileExtValue;
    }

    public IFile getOutputFile() {
        return (IFile)this.resolvedOutputFileValue.getValue();
    }

    public IObservableValue<IFile> getOutputFileValue() {
        return this.resolvedOutputFileValue;
    }

    @Override
    public String getInfo() {
        StringBuilder sb = this.getStringBuilder();
        DocProcessingConfig.Format inputFormat = this.getInputFormat();
        DocProcessingConfig.Format outputFormat = this.getOutputFormat();
        sb.append(inputFormat != null ? inputFormat.getInfoLabel() : "?");
        sb.append("\u2002\u2192\u2002");
        sb.append(outputFormat != null ? outputFormat.getInfoLabel() : "?");
        sb.append('\n');
        DocProcessingOperationSettings operation = this.getOperation();
        sb.append(operation != null ? operation.getInfo() : " ");
        return sb.toString();
    }

    @Override
    public void handleValueChange(ValueChangeEvent<?> event) {
        DocProcessingConfig.Format format;
        if (event.getObservable() == this.inputFormatValue) {
            this.updateInputText();
            this.resolveInputFile();
        }
        if (event.getObservable() == this.outputFormatValue) {
            format = (DocProcessingConfig.Format)event.diff.getNewValue();
            this.outputExtControl.setEditable(format instanceof DocProcessingConfig.CustomExtFormat);
            this.outputFileExtValue.setValue((Object)(format != null ? format.getExt() : ""));
            this.resolveOutputFileExt();
        }
        if (event.getObservable() == this.outputFileExtValue) {
            String ext;
            format = (DocProcessingConfig.Format)this.outputFormatValue.getValue();
            if (format instanceof DocProcessingConfig.CustomExtFormat && !(ext = (String)event.diff.getNewValue()).equals(format.getExt())) {
                format = new DocProcessingConfig.CustomExtFormat((DocProcessingConfig.CustomExtFormat)format, ext);
                this.outputFormatValue.setValue((Object)format);
            }
            return;
        }
        if (event.getObservable() == this.resolvedInputFileValue) {
            this.resolveOutputFileExt();
            return;
        }
        if (event.getObservable() == this.outputPathResourceValue) {
            IResource resource = (IResource)event.diff.getNewValue();
            this.resolvedOutputFileValue.setValue((Object)(resource instanceof IFile ? (IFile)resource : null));
            return;
        }
        super.handleValueChange(event);
    }

    protected void resolveInputFile() {
        IFile file = null;
        try {
            DocProcessingConfig.Format format = this.getInputFormat();
            if (format != null) {
                file = format.matches("source") ? this.getMainTab().getSourceFile() : this.getInputFile(format);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.resolvedInputFileValue.setValue(file);
    }

    protected IFile getInputFile(DocProcessingConfig.Format format) throws CoreException {
        return null;
    }

    protected void resolveOutputFileExt() {
        String ext = null;
        try {
            DocProcessingConfig.Format format = this.getOutputFormat();
            if (format != null) {
                IFile inputFile = this.getInputFile();
                ext = format.getExt(this.getValidExt(inputFile != null ? inputFile.getName() : null));
            }
            if (ext != null && !this.validExtMatcher.reset(ext).matches()) {
                ext = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.resolvedOutputFileExtValue.setValue(ext);
    }

    private String getValidExt(String name) {
        String ext;
        int idx;
        if (name != null && (idx = name.lastIndexOf(46)) >= 0 && this.validExtMatcher.reset(ext = name.substring(idx + 1)).matches()) {
            return ext;
        }
        return null;
    }

    @Override
    protected void addControls(Composite parent) {
        Composite group = this.createIOGroup(parent);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group = this.createOperationGroup(parent);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    protected Composite createIOGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)LayoutUtils.newGroupGrid((int)4));
        group.setText("IO");
        Label label = new Label((Composite)group, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label.setText(Messages.StepTab_In_label);
        label = new Label((Composite)group, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.inputControl = label;
        this.updateInputText();
        label = new Label((Composite)group, 0);
        label.setText(Messages.StepTab_Out_label);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label = new Label((Composite)group, 0);
        label.setText(String.valueOf(Messages.StepTab_Out_Format_label) + ':');
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Composite composite = new Composite((Composite)group, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)3));
        ComboViewer viewer = new ComboViewer(composite, 2060);
        Combo combo = viewer.getCombo();
        LabelProvider labelProvider = new LabelProvider();
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        viewer.setInput(this.availableOutputFormats);
        GridData gd = new GridData(4, 0x1000000, false, false);
        gd.widthHint = LayoutUtils.hintWidth((Combo)combo, this.availableOutputFormats, (ILabelProvider)labelProvider);
        combo.setLayoutData((Object)gd);
        this.outputViewer = viewer;
        Label label2 = new Label(composite, 0);
        label2.setText(String.valueOf(Messages.StepTab_Out_FileExt_label) + " (" + "out_file_ext" + "):");
        label2.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Text text = new Text(composite, 2048);
        text.setEditable(false);
        GridData gd2 = new GridData(16384, 0x1000000, true, false);
        gd2.widthHint = LayoutUtils.hintWidth((Text)text, (int)25);
        text.setLayoutData((Object)gd2);
        this.outputExtControl = text;
        LayoutUtils.addGDDummy((Composite)group);
        label = new Label((Composite)group, 0);
        label.setText(String.valueOf(Messages.StepTab_Out_FilePath_label) + ':');
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        ResourceInputComposite input = new ResourceInputComposite((Composite)group, 0, 17, Messages.StepTab_Out_FilePath_label);
        input.setShowInsertVariable(true, (List)VariableFilterUtils.DEFAULT_INTERACTIVE_RESOURCE_FILTERS, null);
        input.getValidator().setOnExisting(0);
        input.getValidator().setOnLateResolve(0);
        input.getValidator().setRelative(this.getMainTab().getWorkingDirectoryPathVariable(), -1);
        input.getValidator().setIgnoreRelative(true);
        HashMap<String, IStringVariable> variables = new HashMap<String, IStringVariable>();
        variables.putAll(this.getStepVariables());
        variables.remove("out_file_path");
        input.getValidator().setVariableResolver(new VariableText2(variables));
        input.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.outputPathControl = input;
        this.outputPathResourceValue = input.getValidator().getWorkspaceResourceObservable();
        this.outputPathResourceValue.addValueChangeListener((IValueChangeListener)this);
        label = new Label((Composite)group, 0);
        label.setText("(relative to working directory)");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        return group;
    }

    protected void updateInputText() {
        DocProcessingConfig.Format inputFormat = this.getInputFormat();
        if (!UIAccess.isOkToUse((Control)this.inputControl) || inputFormat == null) {
            return;
        }
        this.inputControl.setText(inputFormat.getInfoLabel());
    }

    @Override
    protected void addBindings(DataBindingContext dbc) {
        super.addBindings(dbc);
        IViewerObservableValue outputFormatObservable = ViewersObservables.observeSingleSelection((Viewer)this.outputViewer);
        dbc.bindValue((IObservableValue)outputFormatObservable, this.outputFormatValue, null, new UpdateValueStrategy().setConverter(new IConverter(){

            public Object getToType() {
                return DocProcessingConfig.Format.class;
            }

            public Object getFromType() {
                return DocProcessingConfig.Format.class;
            }

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    return DocProcessingConfig.getFormat((List<DocProcessingConfig.Format>)DocProcessingConfigIOStepTab.this.availableOutputFormats, ((DocProcessingConfig.Format)fromObject).getKey());
                }
                return null;
            }
        }));
        dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.outputExtControl), this.outputFileExtValue, new UpdateValueStrategy(), null);
        dbc.bindValue(this.outputPathControl.getObservable(), this.outputFilePathValue, new UpdateValueStrategy().setAfterGetValidator((IValidator)new UpdateableErrorValidator((IValidator)this.outputPathControl.getValidator())), null);
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.setAttribute(this.outputFormatAttrName, this.defaultOutputFormat.getKey());
        configuration.setAttribute(this.outputFilePathAttrName, OUTPUT_PATH_DEFAULT_VALUE);
    }

    @Override
    protected void doInitialize(ILaunchConfiguration configuration) {
        super.doInitialize(configuration);
        String key = this.defaultOutputFormat.getKey();
        try {
            key = configuration.getAttribute(this.outputFormatAttrName, key);
        }
        catch (CoreException e) {
            this.logReadingError(e);
        }
        DocProcessingConfig.Format format = this.getOutputFormat(key, true);
        this.outputFormatValue.setValue((Object)format);
        String path = OUTPUT_PATH_DEFAULT_VALUE;
        try {
            path = configuration.getAttribute(this.outputFilePathAttrName, path);
        }
        catch (CoreException e) {
            this.logReadingError(e);
        }
        this.outputFilePathValue.setValue((Object)path);
    }

    @Override
    protected void doSave(ILaunchConfigurationWorkingCopy configuration) {
        super.doSave(configuration);
        DocProcessingConfig.Format format = this.getOutputFormat();
        configuration.setAttribute(this.outputFormatAttrName, format.getKey());
        String path = (String)this.outputFilePathValue.getValue();
        configuration.setAttribute(this.outputFilePathAttrName, path);
    }
}

