/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.assist;

import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.statet.ecommons.text.core.sections.IDocContentSections;

public class MultiContentSectionQuickAssistProcessor
implements IQuickAssistProcessor {
    private static final Object NULL = new Object();
    private final IDocContentSections sections;
    private final Map<String, Object> processors = new IdentityHashMap<String, Object>(8);
    private String errorMessage;

    public MultiContentSectionQuickAssistProcessor(IDocContentSections sections) {
        if (sections == null) {
            throw new NullPointerException("sections");
        }
        this.sections = sections;
    }

    protected void registerProcessor(String sectionType, IQuickAssistProcessor processor) {
        if (sectionType == null) {
            throw new NullPointerException("sectionType");
        }
        this.processors.put(sectionType, processor != null ? processor : NULL);
    }

    protected final IQuickAssistProcessor getProcessor(String sectionType) {
        if (sectionType == "") {
            return null;
        }
        Object processor = this.processors.get(sectionType);
        if (processor == null) {
            processor = NULL;
            try {
                IQuickAssistProcessor newProcessor = this.createProcessor(sectionType);
                if (newProcessor != null) {
                    processor = newProcessor;
                }
            }
            finally {
                this.processors.put(sectionType, processor);
            }
        }
        return processor != NULL ? (IQuickAssistProcessor)processor : null;
    }

    protected IQuickAssistProcessor createProcessor(String sectionType) {
        return null;
    }

    public boolean canFix(Annotation annotation) {
        return false;
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        return false;
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        this.errorMessage = null;
        IQuickAssistProcessor processor = this.getProcessor(this.sections.getType(invocationContext.getSourceViewer().getDocument(), invocationContext.getOffset()));
        if (processor != null) {
            try {
                ICompletionProposal[] iCompletionProposalArray = processor.computeQuickAssistProposals(invocationContext);
                return iCompletionProposalArray;
            }
            finally {
                this.errorMessage = processor.getErrorMessage();
            }
        }
        return null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

