/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.actions;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.statet.ecommons.text.core.sections.IDocContentSections;
import org.eclipse.statet.ecommons.ui.actions.ListContributionItem;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class MultiContentSectionElementSearchContributionItem
extends ListContributionItem
implements IWorkbenchContribution,
IExecutableExtension {
    private static final Object NULL = new Object();
    private final IDocContentSections sections;
    private final Map<String, Object> items = new IdentityHashMap<String, Object>(8);
    private String commandId;
    private IServiceLocator serviceLocator;

    public MultiContentSectionElementSearchContributionItem(IDocContentSections sections) {
        if (sections == null) {
            throw new NullPointerException("sections");
        }
        this.sections = sections;
    }

    public MultiContentSectionElementSearchContributionItem(IDocContentSections sections, String sectionType1, ListContributionItem item1) {
        this(sections, sectionType1, item1, null, null);
    }

    public MultiContentSectionElementSearchContributionItem(IDocContentSections sections, String sectionType1, ListContributionItem item1, String sectionType2, ListContributionItem item2) {
        this(sections);
        if (sectionType1 != null) {
            this.registerItem(sectionType1, item1);
        }
        if (sectionType2 != null) {
            this.registerItem(sectionType2, item2);
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (this.commandId != null) {
            return;
        }
        String s = config.getAttribute("id");
        if (s != null) {
            this.commandId = s.intern();
        }
    }

    public String getCommandId() {
        return this.commandId;
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
        for (Object item : this.items.values()) {
            if (item == NULL || !(item instanceof IWorkbenchContribution)) continue;
            ((IWorkbenchContribution)item).initialize(serviceLocator);
        }
    }

    protected final IDocContentSections getSections() {
        return this.sections;
    }

    public void dispose() {
        super.dispose();
        for (Object item : this.items.values()) {
            if (item == NULL) continue;
            ((ListContributionItem)item).dispose();
        }
        this.items.clear();
    }

    protected void registerItem(String sectionType, ListContributionItem item) {
        if (sectionType == null) {
            throw new NullPointerException("sectionType");
        }
        this.items.put(sectionType, item != null ? item : NULL);
    }

    protected final ListContributionItem getItem(String sectionType) {
        if (sectionType == "") {
            return null;
        }
        Object item = this.items.get(sectionType);
        if (item == null) {
            item = NULL;
            try {
                ListContributionItem newItem = this.createItem(sectionType);
                if (newItem != null) {
                    if (newItem instanceof IWorkbenchContribution) {
                        ((IWorkbenchContribution)newItem).initialize(this.serviceLocator);
                    }
                    item = newItem;
                }
            }
            finally {
                this.items.put(sectionType, item);
            }
        }
        return item != NULL ? (ListContributionItem)item : null;
    }

    protected ListContributionItem createItem(String sectionType) {
        return null;
    }

    public void createContributionItems(List<IContributionItem> items) {
        ISourceEditor editor;
        SourceViewer viewer;
        ListContributionItem item;
        IWorkbenchPart part = UIAccess.getActiveWorkbenchPart((boolean)true);
        if (part instanceof ISourceEditor && (item = this.getItem(this.sections.getType((viewer = (editor = (ISourceEditor)part).getViewer()).getDocument(), viewer.getSelectedRange().x))) != null) {
            this.createContributionItems(items, item);
        }
    }
}

