/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.databinding.core.observable;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;

public class WritableEqualityValue<TValue>
extends AbstractObservableValue<TValue> {
    private final Object valueType;
    private TValue value = null;

    public WritableEqualityValue() {
        this(null, null);
    }

    public WritableEqualityValue(TValue initialValue, Object valueType) {
        this(Realm.getDefault(), initialValue, valueType);
    }

    public WritableEqualityValue(Realm realm) {
        this(realm, null, null);
    }

    public WritableEqualityValue(Realm realm, TValue initialValue, Object valueType) {
        super(realm);
        this.valueType = valueType;
        this.value = initialValue;
    }

    public Object getValueType() {
        return this.valueType;
    }

    public TValue doGetValue() {
        return this.value;
    }

    public void doSetValue(TValue value) {
        TValue oldValue = this.doGetValue();
        if (!(value == oldValue || value != null && value.equals(oldValue))) {
            this.value = value;
            this.fireValueChange(Diffs.createValueDiff(this.value, this.value));
        }
    }
}

