/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.sourcemodel;

import java.util.List;
import org.eclipse.statet.internal.r.core.sourcemodel.BuildSourceFrame;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceStructElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnitModelInfo;
import org.eclipse.statet.r.core.model.IRElement;
import org.eclipse.statet.r.core.model.IRFrame;
import org.eclipse.statet.r.core.model.IRLangSourceElement;
import org.eclipse.statet.r.core.model.IRSourceUnit;
import org.eclipse.statet.r.core.model.RElementName;

abstract class RSourceFileElement
implements IRLangSourceElement {
    private final IRSourceUnit sourceUnit;
    protected final BuildSourceFrame envir;

    public RSourceFileElement(IRSourceUnit su, BuildSourceFrame envir) {
        this.sourceUnit = su;
        this.envir = envir;
    }

    public final String getModelTypeId() {
        return "R";
    }

    public int getElementType() {
        return 528;
    }

    @Override
    public RElementName getElementName() {
        ElementName elementName = this.sourceUnit.getElementName();
        if (elementName instanceof RElementName) {
            return (RElementName)elementName;
        }
        return RElementName.create(15, elementName.getSegmentName());
    }

    public String getId() {
        return this.sourceUnit.getId();
    }

    public boolean exists() {
        ISourceUnitModelInfo modelInfo = this.getSourceUnit().getModelInfo("R", 0, null);
        return modelInfo != null && modelInfo.getSourceElement() == this;
    }

    public boolean isReadOnly() {
        return this.sourceUnit.isReadOnly();
    }

    @Override
    public IRElement getModelParent() {
        return null;
    }

    @Override
    public boolean hasModelChildren(IModelElement.Filter filter) {
        return false;
    }

    @Override
    public List<? extends IRLangSourceElement> getModelChildren(IModelElement.Filter filter) {
        return null;
    }

    public ISourceStructElement getSourceParent() {
        return null;
    }

    @Override
    public IRSourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    public TextRegion getNameSourceRange() {
        return null;
    }

    public TextRegion getDocumentationRange() {
        return null;
    }

    public <T> T getAdapter(Class<T> adapterType) {
        if (adapterType == IRFrame.class) {
            return (T)this.envir;
        }
        return null;
    }

    public int hashCode() {
        return this.sourceUnit.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ISourceStructElement)) {
            return false;
        }
        ISourceStructElement other = (ISourceStructElement)obj;
        return (other.getElementType() & 0xFF0) == 528 && this.sourceUnit.equals(other.getSourceUnit());
    }
}

