/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.workbench.search.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.statet.ecommons.workbench.search.ui.ElementMatchComparator;
import org.eclipse.statet.ecommons.workbench.search.ui.ExtTextSearchResult;
import org.eclipse.statet.ecommons.workbench.search.ui.TextSearchResultContentProvider;
import org.eclipse.statet.ecommons.workbench.search.ui.TextSearchResultTableContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class ExtTextSearchResultPage<E, M extends Match>
extends AbstractTextSearchViewPage {
    protected final ElementMatchComparator<E, M> comparator;
    private TextSearchResultContentProvider<E, M, ?> contentProvider;

    public ExtTextSearchResultPage(ElementMatchComparator<E, M> comparator) {
        this.comparator = comparator;
    }

    public ExtTextSearchResult<E, M> getInput() {
        return (ExtTextSearchResult)super.getInput();
    }

    protected void configureTableViewer(TableViewer viewer) {
        viewer.setUseHashlookup(true);
        this.contentProvider = this.createTableContentProvider(viewer);
        viewer.setContentProvider(this.contentProvider);
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        viewer.setUseHashlookup(true);
        this.contentProvider = this.createTreeContentProvider(viewer);
        viewer.setContentProvider(this.contentProvider);
    }

    protected TableViewer createTableViewer(Composite parent) {
        return new TableViewer(parent, 66306);
    }

    protected TextSearchResultContentProvider<E, M, TableViewer> createTableContentProvider(TableViewer viewer) {
        return new TextSearchResultTableContentProvider(this, viewer);
    }

    protected abstract TextSearchResultContentProvider<E, M, TreeViewer> createTreeContentProvider(TreeViewer var1);

    protected String getSearchLabel() {
        return this.getInput().getQuery().getLabel();
    }

    public int getDisplayedMatchCount(Object element) {
        AbstractTextSearchResult result = this.getInput();
        if (result == null) {
            return 0;
        }
        if (element instanceof Match) {
            return 1;
        }
        return result.getPickedMatchCount(element);
    }

    public M[] getDisplayedMatches(Object element) {
        AbstractTextSearchResult result = this.getInput();
        if (result == null) {
            return new Match[0];
        }
        if (element instanceof Match) {
            return new Match[]{(Match)element};
        }
        return result.getPickedMatches(element);
    }

    protected void elementsChanged(Object[] elements) {
        try {
            if (this.contentProvider != null) {
                this.contentProvider.elementsChanged(elements);
            }
        }
        catch (Exception e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.base.ui", -1, NLS.bind((String)"An error occurred when updating the result table of search: {0}.", (Object)this.getSearchLabel()), (Throwable)e), 3);
        }
    }

    protected void clear() {
        try {
            if (this.contentProvider != null) {
                this.contentProvider.clear();
            }
        }
        catch (Exception e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.base.ui", -1, NLS.bind((String)"An error occurred when updating the result table of search: {0}.", (Object)this.getSearchLabel()), (Throwable)e), 3);
        }
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        AbstractTextSearchResult input = this.getInput();
        if (input == null) {
            return;
        }
        IFileMatchAdapter fileAdapter = input.getFileMatchAdapter();
        if (fileAdapter == null) {
            return;
        }
        IFile file = fileAdapter.getFile(match.getElement());
        if (file == null) {
            return;
        }
        IWorkbenchPage page = this.getSite().getPage();
        if (currentOffset >= 0 && currentLength != 0) {
            this.openAndSelect(page, file, currentOffset, currentLength, activate);
        } else {
            this.open(page, file, activate);
        }
    }
}

