/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.scoping;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.scoping.IResourceScope;
import org.eclipse.sphinx.emf.scoping.IResourceScopeProvider;
import org.eclipse.sphinx.emf.scoping.ResourceScopeProviderRegistry;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;

public abstract class AbstractResourceScopeProvider
implements IResourceScopeProvider {
    @Override
    public boolean isApplicableTo(IFile file) {
        IResourceScope scope = this.createScope((IResource)file);
        if (scope == null || !scope.exists()) {
            return false;
        }
        return this.hasApplicableFileExtension(file);
    }

    @Override
    public boolean hasApplicableFileExtension(IFile file) {
        Assert.isNotNull((Object)file);
        String extension = file.getFullPath().getFileExtension();
        if (extension == null) {
            return false;
        }
        extension = extension.toLowerCase();
        for (IMetaModelDescriptor mmDescriptor : ResourceScopeProviderRegistry.INSTANCE.getMetaModelDescriptorsFor(this)) {
            for (String contentTypeId : mmDescriptor.getContentTypeIds()) {
                if (!this.isContentTypeContainsFileExtension(contentTypeId, extension)) continue;
                return true;
            }
            for (String compatibleContentTypeId : mmDescriptor.getCompatibleContentTypeIds()) {
                if (!this.isContentTypeContainsFileExtension(compatibleContentTypeId, extension)) continue;
                return true;
            }
        }
        return MetaModelDescriptorRegistry.INSTANCE.isContentTypeOfTargetDescriptorsApplicable(file);
    }

    @Override
    public IResourceScope getScope(IResource resource) {
        IResourceScope scope = this.createScope(resource);
        if (scope == null || !scope.exists()) {
            return null;
        }
        if (resource instanceof IFile && !scope.belongsTo((IFile)resource, false)) {
            return null;
        }
        return scope;
    }

    protected abstract IResourceScope createScope(IResource var1);

    @Override
    public IResourceScope getScope(Resource resource) {
        IFile file = EcorePlatformUtil.getFile(resource);
        if (file != null) {
            return this.getScope((IResource)file);
        }
        return null;
    }

    @Override
    public Diagnostic validate(IFile file) {
        return Diagnostic.OK_INSTANCE;
    }

    private boolean isContentTypeContainsFileExtension(String contentTypeID, String fileExtension) {
        for (String contentTypeFileExtension : ExtendedPlatform.getContentTypeFileExtensions((String)contentTypeID)) {
            if (contentTypeFileExtension == null || !fileExtension.equals(contentTypeFileExtension.toLowerCase())) continue;
            return true;
        }
        return false;
    }
}

