/**
 * <copyright>
 * 
 * Copyright (c) 2014 itemis and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     itemis - Initial API and implementation
 * 
 * </copyright>
 */
package org.eclipse.sphinx.emf.serialization.generators.persistencemapping;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.sphinx.emf.serialization.XMLPersistenceMappingExtendedMetaData;
import org.eclipse.sphinx.emf.serialization.generators.persistencemapping.CreateDefaultXSDExtendedMetaData;

@SuppressWarnings("all")
public class XMLPersistenceMappingGenerator {
  public EPackage rootModel;
  
  public Set<EPackage> referencedEcores = new HashSet<EPackage>();
  
  public Set<EPackage> referencedEPackagesWithMetaData = new HashSet<EPackage>();
  
  /**
   * The extended meta data used to determine the schema structure.
   */
  protected XMLPersistenceMappingExtendedMetaData xsdExtendedMetaData = XMLPersistenceMappingExtendedMetaData.INSTANCE;
  
  public XMLPersistenceMappingGenerator(final EPackage rootModel) {
    this.rootModel = rootModel;
  }
  
  public EObject execute(final IProgressMonitor monitor) {
    EPackage _xblockexpression = null;
    {
      monitor.beginTask("XML persistence mapping generatering ...", 100);
      monitor.subTask("XML persistence mapping generatering ...");
      final SubMonitor progress = SubMonitor.convert(monitor, 100);
      boolean _isCanceled = progress.isCanceled();
      if (_isCanceled) {
        throw new OperationCanceledException();
      }
      final CreateDefaultXSDExtendedMetaData createDefaultXSDExtendedMetaData = this.createDefaultXSDExtendedMetaData();
      _xblockexpression = this.rootModel = createDefaultXSDExtendedMetaData.execute(progress.newChild(100));
    }
    return _xblockexpression;
  }
  
  protected CreateDefaultXSDExtendedMetaData createDefaultXSDExtendedMetaData() {
    return new CreateDefaultXSDExtendedMetaData(this.rootModel, "NO GLOBAL ECLASS");
  }
}
