/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.xtendxpand.jobs;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.resource.ModelResourceDescriptor;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.sphinx.xtendxpand.internal.Activator;
import org.eclipse.sphinx.xtendxpand.jobs.AbstractResultObjectHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveAsNewFileHandler
extends AbstractResultObjectHandler {
    @Override
    protected void handleResultObjects(Map<Object, Collection<?>> resultObjects) {
        HashSet<ModelResourceDescriptor> allModelResourceDescriptors = new HashSet<ModelResourceDescriptor>();
        HashSet<IPath> allocatedResultPaths = new HashSet<IPath>();
        for (Object inputObject : resultObjects.keySet()) {
            for (Object resultObject : resultObjects.get(inputObject)) {
                IPath resultPath;
                if (!(resultObject instanceof EObject) || !this.shouldSave((EObject)resultObject) || (resultPath = this.getUniqueResultPath(inputObject, (EObject)resultObject, allocatedResultPaths)) == null) continue;
                allocatedResultPaths.add(resultPath);
                String resultContentTypeId = this.getContentTypeIdFor((EObject)resultObject);
                allModelResourceDescriptors.add(new ModelResourceDescriptor((EObject)resultObject, resultPath, resultContentTypeId));
            }
        }
        HashMap<TransactionalEditingDomain, HashSet<ModelResourceDescriptor>> modelResourceDescriptors = new HashMap<TransactionalEditingDomain, HashSet<ModelResourceDescriptor>>();
        for (ModelResourceDescriptor modelResourceDescriptor : allModelResourceDescriptors) {
            IMetaModelDescriptor mmDescriptor = MetaModelDescriptorRegistry.INSTANCE.getDescriptor(modelResourceDescriptor.getModelRoot());
            IFile modelFile = ResourcesPlugin.getWorkspace().getRoot().getFile(modelResourceDescriptor.getPath());
            TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((IContainer)modelFile.getParent(), (IMetaModelDescriptor)mmDescriptor);
            HashSet<ModelResourceDescriptor> modelResourceDescriptorsForEditingDomain = (HashSet<ModelResourceDescriptor>)modelResourceDescriptors.get(editingDomain);
            if (modelResourceDescriptorsForEditingDomain == null) {
                modelResourceDescriptorsForEditingDomain = new HashSet<ModelResourceDescriptor>();
                modelResourceDescriptors.put(editingDomain, modelResourceDescriptorsForEditingDomain);
            }
            modelResourceDescriptorsForEditingDomain.add(modelResourceDescriptor);
        }
        for (TransactionalEditingDomain editingDomain : modelResourceDescriptors.keySet()) {
            try {
                EcorePlatformUtil.saveNewModelResources((TransactionalEditingDomain)editingDomain, (Collection)((Collection)modelResourceDescriptors.get(editingDomain)), (boolean)true, null);
            }
            catch (Exception ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
            }
        }
    }

    protected boolean shouldSave(EObject object) {
        Assert.isNotNull((Object)object);
        return object.eResource() == null;
    }

    protected IPath getUniqueResultPath(Object inputObject, EObject resultObject, Set<IPath> allocatedResultPaths) {
        IPath candidateResultPath = this.getResultPath(inputObject, resultObject);
        if (candidateResultPath != null) {
            return ExtendedPlatform.createUniquePath((IPath)candidateResultPath, allocatedResultPaths);
        }
        return null;
    }

    protected IPath getResultPath(Object inputObject, EObject resultObject) {
        IFile inputFile = EcorePlatformUtil.getFile((Object)inputObject);
        IPath projectRelativeResultPath = this.getProjectRelativeResultPath(inputFile, resultObject);
        if (projectRelativeResultPath != null) {
            return inputFile.getProject().getFullPath().append(projectRelativeResultPath);
        }
        return null;
    }

    protected IPath getProjectRelativeResultPath(IFile inputFile, EObject resultObject) {
        if (inputFile != null) {
            String resultFileExtension = this.getFileExtensionFor(resultObject);
            return inputFile.getProjectRelativePath().removeFileExtension().addFileExtension(resultFileExtension);
        }
        return null;
    }

    protected String getFileExtensionFor(EObject object) {
        Collection possibleExtensions;
        String contentTypeId = this.getContentTypeIdFor(object);
        if (contentTypeId != null && !(possibleExtensions = ExtendedPlatform.getContentTypeFileExtensions((String)contentTypeId)).isEmpty()) {
            return (String)possibleExtensions.iterator().next();
        }
        return object.eClass().getEPackage().getName();
    }

    protected String getContentTypeIdFor(EObject object) {
        IMetaModelDescriptor mmDescriptor = MetaModelDescriptorRegistry.INSTANCE.getDescriptor(object.eClass());
        if (mmDescriptor != null) {
            return mmDescriptor.getDefaultContentTypeId();
        }
        return null;
    }
}

