/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.migration;

import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.migration.AbstractRepresentationsFileMigrationParticipant;
import org.eclipse.sirius.business.api.query.DViewQuery;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.ui.business.api.query.DDiagramGraphicalQuery;
import org.eclipse.sirius.diagram.ui.tools.internal.util.GMFNotationUtilities;
import org.eclipse.sirius.ecore.extender.business.internal.accessor.ecore.EMFUtil;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.FontFormat;
import org.osgi.framework.Version;

public class NodeStyleMigrationParticipant
extends AbstractRepresentationsFileMigrationParticipant {
    public static final Version MIGRATION_VERSION = new Version("15.2.0.202303281325");

    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }

    private void updateStyle(FontStyle target, BasicLabelStyle source) {
        boolean isBold = source.getLabelFormat().contains((Object)FontFormat.BOLD_LITERAL);
        boolean isItalic = source.getLabelFormat().contains((Object)FontFormat.ITALIC_LITERAL);
        boolean isUnderline = source.getLabelFormat().contains((Object)FontFormat.UNDERLINE_LITERAL);
        boolean isStricke = source.getLabelFormat().contains((Object)FontFormat.STRIKE_THROUGH_LITERAL);
        int labelSize = source.getLabelSize();
        int labelColor = source.getLabelColor().toInteger();
        target.setBold(isBold);
        target.setFontColor(labelColor);
        target.setFontHeight(labelSize);
        target.setItalic(isItalic);
        target.setUnderline(isUnderline);
        target.setStrikeThrough(isStricke);
    }

    private void updateNode(View node) {
        EList children = node.getChildren();
        Optional<View> labelOpt = children.stream().filter(GMFNotationUtilities::viewIsLabel).findAny();
        labelOpt.ifPresent(label -> label.getStyles().clear());
        Optional<Object> nodeStyleOpt = node.getStyles().stream().filter(style -> style instanceof FontStyle).findAny();
        nodeStyleOpt.ifPresent(fontStyle -> {
            BasicLabelStyle basicLabelStyle;
            void dNode;
            EObject eObject = node.getElement();
            if (eObject instanceof DNode var3_4 && ( instanceOfPatternExpressionValue = dNode.getStyle()) instanceof BasicLabelStyle && (basicLabelStyle = (BasicLabelStyle) instanceOfPatternExpressionValue) == (BasicLabelStyle) instanceOfPatternExpressionValue) {
                void dLabelStyle;
                this.updateStyle((FontStyle)fontStyle, (BasicLabelStyle)dLabelStyle);
            }
        });
    }

    private void migrateDiagram(Diagram diagram) {
        EMFUtil.getTreeStream((EObject)diagram, view -> view.getChildren()).filter(GMFNotationUtilities::viewIsNode).forEach(this::updateNode);
    }

    private Optional<Diagram> getGMFDiagram(DDiagram dDiagram) {
        DDiagramGraphicalQuery query = new DDiagramGraphicalQuery(dDiagram);
        return Optional.ofNullable((Diagram)query.getAssociatedGMFDiagram().get());
    }

    private Stream<DRepresentationDescriptor> getRepresentationsDescriptors(DView dView) {
        return new DViewQuery(dView).getLoadedRepresentationsDescriptors().stream();
    }

    protected void postLoad(DAnalysis dAnalysis, Version loadedVersion) {
        if (loadedVersion.compareTo(MIGRATION_VERSION) < 0) {
            dAnalysis.getOwnedViews().stream().flatMap(this::getRepresentationsDescriptors).map(descriptor -> descriptor.getRepresentation()).filter(representation -> representation instanceof DDiagram).map(representation -> (DDiagram)representation).map(this::getGMFDiagram).flatMap(Optional::stream).forEach(this::migrateDiagram);
        }
    }
}

