/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.helper.refresh;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.query.IEdgeMappingQuery;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.tools.api.Messages;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class EdgeFilter {
    private EObject source;
    private EObject target;
    private EObject semTarget;
    private EdgeTarget edgeSource;
    private EdgeTarget edgeTarget;
    private EdgeMapping mapping;

    public EdgeFilter(EObject source, EObject target, EObject semTarget, EdgeTarget edgeSource, EdgeTarget edgeTarget, EdgeMapping edgeMapping) {
        if (source == null || target == null || edgeSource == null || edgeTarget == null) {
            throw new IllegalArgumentException(Messages.EdgeFilter_errorMsg);
        }
        this.source = source;
        this.target = target;
        this.semTarget = semTarget;
        this.edgeSource = edgeSource;
        this.edgeTarget = edgeTarget;
        this.mapping = edgeMapping;
    }

    public EdgeFilter(DEdge edge) {
        this.source = ((DSemanticDecorator)edge.getSourceNode()).getTarget();
        this.target = ((DSemanticDecorator)edge.getTargetNode()).getTarget();
        this.semTarget = edge.getTarget();
        this.edgeSource = edge.getSourceNode();
        this.edgeTarget = edge.getTargetNode();
        this.mapping = (EdgeMapping)new IEdgeMappingQuery(edge.getActualMapping()).getEdgeMapping().get();
    }

    public EObject getSource() {
        return this.source;
    }

    public EObject getTarget() {
        return this.target;
    }

    public EObject getSemTarget() {
        return this.semTarget;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj == this) {
            result = true;
        }
        if (!result && obj instanceof EdgeFilter) {
            EdgeFilter edgeFilter = (EdgeFilter)obj;
            if (this.semTarget == null && edgeFilter.semTarget != null || this.semTarget != null && edgeFilter.semTarget == null) {
                SiriusPlugin.getDefault().error(Messages.EdgeFilter_semanticIsNullErrorMsg, null);
            }
            result = this.getHashString(this).equals(this.getHashString(edgeFilter));
        }
        return result;
    }

    private String getHashString(EdgeFilter obj) {
        String hashString = EcoreUtil.getURI((EObject)obj.semTarget).toString();
        hashString = String.valueOf(hashString) + EcoreUtil.getURI((EObject)obj.target).toString();
        hashString = String.valueOf(hashString) + EcoreUtil.getURI((EObject)obj.source).toString();
        hashString = String.valueOf(hashString) + EcoreUtil.getURI((EObject)obj.edgeSource).toString();
        hashString = String.valueOf(hashString) + EcoreUtil.getURI((EObject)obj.edgeTarget).toString();
        hashString = String.valueOf(hashString) + EcoreUtil.getURI((EObject)obj.mapping).toString();
        return hashString;
    }

    public String toString() {
        return Integer.valueOf(this.hashCode()).toString();
    }

    public int hashCode() {
        return this.getHashString(this).hashCode();
    }
}

