/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.migration;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.sirius.business.api.migration.AbstractRepresentationsFileMigrationParticipant;
import org.eclipse.sirius.business.api.query.DViewQuery;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.CollapseFilter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.description.style.WorkspaceImageDescription;
import org.eclipse.sirius.diagram.tools.api.DiagramPlugin;
import org.eclipse.sirius.diagram.ui.business.api.query.DDiagramGraphicalQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.NodeQuery;
import org.eclipse.sirius.diagram.ui.business.internal.query.WorkspaceImageQuery;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.description.style.StyleDescription;
import org.osgi.framework.Version;

public class WorkspaceImageGMFBoundsMigrationParticipant
extends AbstractRepresentationsFileMigrationParticipant {
    public static final Version MIGRATION_VERSION = new Version("15.0.0.202209061200");
    public static final Version PREVIOUS_MIGRATION_VERSION = new Version("15.0.0.202201261500");

    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }

    protected void postLoad(DAnalysis dAnalysis, Version loadedVersion) {
        if (loadedVersion.compareTo(MIGRATION_VERSION) < 0) {
            boolean previousMigrationApplied = loadedVersion.compareTo(PREVIOUS_MIGRATION_VERSION) >= 0;
            StringBuilder sb = new StringBuilder(Messages.WorkspaceImageGMFBoundsMigrationParticipant_title);
            EList ownedViews = dAnalysis.getOwnedViews();
            boolean migrationOccurred = false;
            for (DView view : ownedViews) {
                List loadedRepresentationsDescriptors = new DViewQuery(view).getLoadedRepresentationsDescriptors();
                for (DRepresentationDescriptor descriptor : loadedRepresentationsDescriptors) {
                    DDiagram dDiagram;
                    DDiagramGraphicalQuery query;
                    Option<Diagram> gmfDiagram;
                    if (!(descriptor.getRepresentation() instanceof DDiagram) || !(gmfDiagram = (query = new DDiagramGraphicalQuery(dDiagram = (DDiagram)descriptor.getRepresentation())).getAssociatedGMFDiagram()).some()) continue;
                    boolean migrationOccurredInCurrentDiag = false;
                    String representationName = "";
                    for (Object child : ((Diagram)gmfDiagram.get()).getChildren()) {
                        if (!this.resizeWorkspaceImageGMFBounds(child, previousMigrationApplied)) continue;
                        migrationOccurred = true;
                        migrationOccurredInCurrentDiag = true;
                        representationName = dDiagram.getName();
                    }
                    if (!migrationOccurredInCurrentDiag) continue;
                    sb.append(MessageFormat.format(Messages.WorkspaceImageGMFBoundsMigrationParticipant_GMFBoundsResized, representationName));
                }
            }
            if (migrationOccurred) {
                DiagramPlugin.getDefault().logInfo(sb.toString());
                migrationOccurred = false;
            }
        }
    }

    private boolean resizeWorkspaceImageGMFBounds(Object child, boolean previousMigrationApplied) {
        boolean resized = false;
        if (child instanceof Node && ((Node)child).getLayoutConstraint() instanceof Size) {
            DDiagramElementContainer dDiagramElementContainer;
            Node node = (Node)child;
            if (node.getElement() instanceof DNode) {
                DNode dnode = (DNode)node.getElement();
                if (dnode.getStyle() != null) {
                    StyleDescription description = dnode.getStyle().getDescription();
                    resized = this.resizeGMFNode(previousMigrationApplied, node, description, dnode.getWidth(), dnode.getHeight());
                }
            } else if (node.getElement() instanceof DDiagramElementContainer && (dDiagramElementContainer = (DDiagramElementContainer)node.getElement()).getStyle() != null) {
                StyleDescription description = dDiagramElementContainer.getStyle().getDescription();
                resized = this.resizeGMFNode(previousMigrationApplied, node, description, dDiagramElementContainer.getWidth(), dDiagramElementContainer.getHeight());
                for (Object o : node.getChildren()) {
                    resized = this.resizeWorkspaceImageGMFBounds(o, previousMigrationApplied);
                }
            }
        }
        return resized;
    }

    private boolean resizeGMFNode(boolean previousMigrationApplied, Node node, StyleDescription description, Integer diagramElementWidth, Integer diagramElementHeight) {
        boolean resized = false;
        LayoutConstraint layoutConstraint = node.getLayoutConstraint();
        if (description instanceof WorkspaceImageDescription && layoutConstraint instanceof Size) {
            Size nodeSize = (Size)layoutConstraint;
            WorkspaceImageDescription workspaceImageDescription = (WorkspaceImageDescription)description;
            WorkspaceImageQuery workspaceImageQuery = new WorkspaceImageQuery(workspaceImageDescription);
            Dimension fixedDimension = null;
            String sizeComputationExpression = workspaceImageDescription.getSizeComputationExpression();
            fixedDimension = workspaceImageDescription.getResizeKind().getValue() == 0 ? this.handleUnauthorizedResize(diagramElementWidth, diagramElementHeight, workspaceImageQuery, sizeComputationExpression) : this.handleAuthorizedResize(nodeSize, diagramElementWidth, diagramElementHeight, workspaceImageQuery, sizeComputationExpression);
            if (fixedDimension != null) {
                NodeQuery nodeQuery = new NodeQuery(node);
                boolean isCollasped = nodeQuery.isCollapsed();
                if (isCollasped) {
                    resized = this.handleCollapsedResize(previousMigrationApplied, node, nodeSize, fixedDimension, nodeQuery);
                } else if (!(previousMigrationApplied || nodeSize.getHeight() == fixedDimension.height && nodeSize.getWidth() == fixedDimension.width)) {
                    nodeSize.setWidth(fixedDimension.width);
                    nodeSize.setHeight(fixedDimension.height);
                    resized = true;
                }
            }
        }
        return resized;
    }

    private Dimension handleUnauthorizedResize(Integer diagramElementWidth, Integer diagramElementHeight, WorkspaceImageQuery workspaceImageQuery, String sizeComputationExpression) {
        Dimension fixedDimension = null;
        if (!StringUtil.isEmpty((String)sizeComputationExpression) && "-1".equals(sizeComputationExpression.trim()) && workspaceImageQuery.doesImageExist()) {
            Dimension imageSize = workspaceImageQuery.getDefaultDimension();
            fixedDimension = new Dimension(imageSize);
        } else if (diagramElementWidth != null && diagramElementHeight != null) {
            int width = diagramElementWidth * 10;
            int height = (int)((double)diagramElementWidth.intValue() / workspaceImageQuery.getRatio() * 10.0);
            fixedDimension = new Dimension(width, height);
        }
        return fixedDimension;
    }

    private Dimension handleAuthorizedResize(Size nodeSize, Integer diagramElementWidth, Integer diagramElementHeight, WorkspaceImageQuery workspaceImageQuery, String sizeComputationExpression) {
        Dimension fixedDimension = null;
        if (!(StringUtil.isEmpty((String)sizeComputationExpression) || "-1".equals(sizeComputationExpression.trim()) && workspaceImageQuery.doesImageExist())) {
            Dimension imageSize = workspaceImageQuery.getDefaultDimension();
            if (nodeSize.getWidth() == imageSize.width && nodeSize.getHeight() == imageSize.height && diagramElementWidth != null && diagramElementHeight != null) {
                int width = diagramElementWidth * 10;
                int height = (int)((double)diagramElementWidth.intValue() / workspaceImageQuery.getRatio() * 10.0);
                fixedDimension = new Dimension(width, height);
            }
        }
        return fixedDimension;
    }

    private boolean handleCollapsedResize(boolean previousMigrationApplied, Node node, Size nodeSize, Dimension fixedDimension, NodeQuery nodeQuery) {
        boolean resized = false;
        Optional<CollapseFilter> optionalCollapseFilter = this.getCollapseFilter(node);
        if (optionalCollapseFilter.isPresent()) {
            CollapseFilter collapseFilter = optionalCollapseFilter.get();
            if (previousMigrationApplied) {
                Dimension collapsedSize = nodeQuery.getCollapsedSize();
                if (nodeSize.getHeight() != collapsedSize.height || nodeSize.getWidth() != collapsedSize.width) {
                    nodeSize.setWidth(collapsedSize.width);
                    nodeSize.setHeight(collapsedSize.height);
                    resized = true;
                }
            }
            if (collapseFilter.getHeight() != fixedDimension.height || collapseFilter.getWidth() != fixedDimension.width) {
                collapseFilter.setWidth(fixedDimension.width);
                collapseFilter.setHeight(fixedDimension.height);
                resized = true;
            }
        }
        return resized;
    }

    private Optional<CollapseFilter> getCollapseFilter(Node node) {
        return Optional.ofNullable(node.getElement()).stream().filter(DDiagramElement.class::isInstance).map(DDiagramElement.class::cast).map(DDiagramElement::getGraphicalFilters).flatMap(Collection::stream).filter(CollapseFilter.class::isInstance).map(CollapseFilter.class::cast).findFirst();
    }
}

