/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ecore.extender.business.internal.permission;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionProvider;
import org.eclipse.sirius.ecore.extender.business.internal.permission.PermissionProviderDescriptor;
import org.eclipse.sirius.ecore.extender.business.internal.permission.ReadOnlyPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.internal.permission.ReadOnlyWrapperPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.internal.permission.descriptors.EclipsePermissionProviderDescriptor;

public final class PermissionService {
    private static SortedSet<PermissionProviderDescriptor> extenderProviders = new TreeSet<PermissionProviderDescriptor>();
    private static final String EXTENDER_PROVIDER_EXTENSION_POINT = "org.eclipse.sirius.ecore.extender.PermissionProvider";
    private static final String TAG_ENGINE = "permissionprovider";

    static {
        PermissionService.parseExtensionMetadata();
    }

    private PermissionService() {
    }

    public static IPermissionAuthority createDefaultPermissionAuthority() {
        return new ReadOnlyPermissionAuthority();
    }

    public static IPermissionAuthority wrapPermissionAuthority(IPermissionAuthority authority) {
        return new ReadOnlyWrapperPermissionAuthority(authority);
    }

    public static IPermissionAuthority createPermissionAuthority(ResourceSet resourceSet) {
        IPermissionAuthority result = PermissionService.createDefaultPermissionAuthority();
        boolean foundSpecific = false;
        Iterator it = extenderProviders.iterator();
        while (it.hasNext() && !foundSpecific) {
            PermissionProviderDescriptor permissionProviderDescriptor = (PermissionProviderDescriptor)it.next();
            IPermissionProvider permissionProvider = permissionProviderDescriptor.getPermissionProvider();
            if (permissionProvider == null || !permissionProvider.provides(resourceSet)) continue;
            result = PermissionService.wrapPermissionAuthority(permissionProvider.getAuthority(resourceSet));
            foundSpecific = true;
        }
        return result;
    }

    public static void addExtension(PermissionProviderDescriptor permissionProviderDescriptor) {
        extenderProviders.add(permissionProviderDescriptor);
    }

    public static void removeExtension(PermissionProviderDescriptor permissionProviderDescriptor) {
        extenderProviders.remove(permissionProviderDescriptor);
    }

    private static void parseExtensionMetadata() {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = Platform.getExtensionRegistry().getExtensionPoint(EXTENDER_PROVIDER_EXTENSION_POINT).getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    PermissionProviderDescriptor permissionProviderDescriptor = PermissionService.parseEngine(configElement);
                    if (permissionProviderDescriptor != null) {
                        extenderProviders.add(permissionProviderDescriptor);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private static PermissionProviderDescriptor parseEngine(IConfigurationElement configElement) {
        if (!configElement.getName().equals(TAG_ENGINE)) {
            return null;
        }
        String id = configElement.getDeclaringExtension().getUniqueIdentifier();
        int priority = PermissionService.getPriorityValue(configElement.getAttribute("priority"));
        EclipsePermissionProviderDescriptor permissionProviderDescriptor = new EclipsePermissionProviderDescriptor(id, priority, configElement);
        return permissionProviderDescriptor;
    }

    public static int getPriorityValue(String priorityString) {
        int priorityValue = 5;
        if ("lowest".equals(priorityString)) {
            priorityValue = 20;
        } else if ("low".equals(priorityString)) {
            priorityValue = 10;
        } else if ("high".equals(priorityString)) {
            priorityValue = 1;
        } else if ("highest".equals(priorityString)) {
            priorityValue = 0;
        }
        return priorityValue;
    }
}

