/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.properties.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.LockStatusChangeEvent;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;

public class EditingContextAdapterWrapper
implements EditingContextAdapter {
    private final EditingContextAdapter delegate;
    private final List<Consumer<IStatus>> performedModelChangeConsumers = new ArrayList<Consumer<IStatus>>();

    public EditingContextAdapterWrapper(EditingContextAdapter delegate) {
        this.delegate = delegate;
    }

    public IStatus performModelChange(Runnable operation) {
        IStatus status = this.delegate.performModelChange(operation);
        this.performedModelChangeConsumers.forEach(consumer -> consumer.accept(status));
        return status;
    }

    public void addPerformedModelChangeConsumer(Consumer<IStatus> consumer) {
        this.performedModelChangeConsumers.add(consumer);
    }

    public void removePerformedModelChangeConsumer(Consumer<IStatus> consumer) {
        this.performedModelChangeConsumers.remove(consumer);
    }

    public void registerModelChangeListener(Consumer<List<Notification>> listener) {
        this.delegate.registerModelChangeListener(listener);
    }

    public void unregisterModelChangeListener() {
        this.delegate.unregisterModelChangeListener();
    }

    public EditingDomain getEditingDomain() {
        return this.delegate.getEditingDomain();
    }

    public void addLockStatusChangedListener(Consumer<Collection<LockStatusChangeEvent>> listener) {
        this.delegate.addLockStatusChangedListener(listener);
    }

    public void removeLockStatusChangedListener(Consumer<Collection<LockStatusChangeEvent>> listener) {
        this.delegate.removeLockStatusChangedListener(listener);
    }

    public LockStatusChangeEvent.LockStatus getLockStatus(EObject obj) {
        return this.delegate.getLockStatus(obj);
    }
}

