/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.model.business.internal.spec;

import com.google.common.collect.Ordering;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.TablePackage;
import org.eclipse.sirius.table.metamodel.table.description.TableMapping;
import org.eclipse.sirius.table.metamodel.table.impl.DLineImpl;
import org.eclipse.sirius.table.model.internal.Messages;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;

public class DLineSpec
extends DLineImpl {
    @Override
    public EList<DCell> getOrderedCells() {
        Ordering ordering = Ordering.from((Comparator)new Comparator<DCell>(){
            Map<DColumn, Integer> columnIndices;

            @Override
            public int compare(DCell a, DCell b) {
                int result = 0;
                DColumn columnA = a.getColumn();
                DColumn columnB = b.getColumn();
                if (columnA == null || columnA.eContainer() == null) {
                    result = -1;
                } else if (columnB == null || columnB.eContainer() == null) {
                    result = 1;
                } else {
                    if (this.columnIndices == null) {
                        this.columnIndices = new HashMap<DColumn, Integer>();
                        int i = 0;
                        for (DColumn col : columnA.getTable().getColumns()) {
                            this.columnIndices.put(col, i++);
                        }
                    }
                    Integer aIndex = this.columnIndices.get(columnA);
                    Integer bIndex = this.columnIndices.get(columnB);
                    if (aIndex == null || bIndex == null) {
                        throw new RuntimeException(Messages.Table_UnexpectedExceptionMessage);
                    }
                    return aIndex - bIndex;
                }
                return result;
            }
        });
        Object[] data = new DCell[this.getCells().size()];
        this.getCells().toArray(data);
        Arrays.sort(data, ordering);
        return new EcoreEList.UnmodifiableEList(this.eInternalContainer(), (EStructuralFeature)TablePackage.eINSTANCE.getDLine_OrderedCells(), data.length, data);
    }

    @Override
    public RepresentationElementMapping getMapping() {
        return this.getOriginMapping();
    }

    @Override
    public TableMapping basicGetTableElementMapping() {
        return (TableMapping)this.getMapping();
    }

    @Override
    public TableMapping getTableElementMapping() {
        TableMapping tableElementMapping = this.basicGetTableElementMapping();
        return tableElementMapping != null && tableElementMapping.eIsProxy() ? (TableMapping)this.eResolveProxy((InternalEObject)tableElementMapping) : tableElementMapping;
    }
}

