/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.api.tools;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.sirius.tests.support.api.TestsUtil;
import org.eclipse.sirius.tests.unit.common.TreeCommonTest;
import org.eclipse.sirius.tests.unit.common.TreeEcoreModeler;
import org.eclipse.sirius.tests.unit.diagram.modeler.ecore.EcoreModeler;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.tree.DTreeElement;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.description.TreeDescription;
import org.eclipse.sirius.tree.ui.tools.internal.editor.DTreeEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.tools.internal.editor.AbstractDTreeEditor;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.tool.RepresentationCreationDescription;
import org.eclipse.ui.IEditorPart;
import org.junit.Assert;

public class NavigationDescriptionTest
extends TreeCommonTest
implements EcoreModeler,
TreeEcoreModeler {
    private DTree treeRepresentation;
    private AbstractDTreeEditor treeEditor;
    private TreeDescription desc;
    private EPackage semanticModel;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.initViewpoint("Design");
        this.initTree();
        TestsUtil.synchronizationWithUIThread();
    }

    private void initTree() {
        this.treeRepresentation = (DTree)this.getRepresentations("Tree").toArray()[0];
        Assert.assertNotNull((String)"The tree representation is null", (Object)this.treeRepresentation);
        this.desc = this.treeRepresentation.getDescription();
        Assert.assertNotNull((String)"The tree description is null", (Object)this.desc);
        IEditorPart openedEditor = DialectUIManager.INSTANCE.openEditor(this.session, (DRepresentation)this.treeRepresentation, (IProgressMonitor)new NullProgressMonitor());
        TestsUtil.synchronizationWithUIThread();
        Assert.assertNotNull((String)"The tree editor is not opened", (Object)openedEditor);
        Assert.assertTrue((String)"The tree editor is not opened", (boolean)(openedEditor instanceof DTreeEditor));
        this.treeEditor = (AbstractDTreeEditor)openedEditor;
        Assert.assertNotNull((String)"The tree editor is not opened", (Object)openedEditor);
        this.semanticModel = (EPackage)this.treeRepresentation.getTarget();
    }

    public void testCreationDescription() {
        Assert.assertFalse((boolean)this.desc.getOwnedRepresentationCreationDescriptions().isEmpty());
        RepresentationCreationDescription representationCreationDescription = (RepresentationCreationDescription)this.desc.getOwnedRepresentationCreationDescriptions().get(0);
        EClass class1 = (EClass)this.semanticModel.getEClassifier("EClass1");
        DTreeItem treeitem1 = (DTreeItem)this.getFirstRepresentationElement((DRepresentation)this.treeRepresentation, (EObject)class1);
        Collection representations = this.getRepresentations("Tree on Class");
        Assert.assertTrue((representations.size() == 1 ? 1 : 0) != 0);
        this.applyCreationDescriptionTool(representationCreationDescription, (DTreeElement)treeitem1, "new Creation Description For Tree");
        representations = this.getRepresentations("Tree on Class");
        Assert.assertTrue((representations.size() == 2 ? 1 : 0) != 0);
    }

    @Override
    protected void tearDown() throws Exception {
        DialectUIManager.INSTANCE.closeEditor((IEditorPart)this.treeEditor, false);
        TestsUtil.synchronizationWithUIThread();
        super.tearDown();
    }
}

