/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.services.table;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.constants.TableType;
import org.eclipse.set.basis.part.PartDescription;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.ppmodel.extensions.utils.TableNameInfo;
import org.eclipse.set.utils.BasePart;
import org.eclipse.set.utils.table.TableError;
import org.eclipse.set.utils.table.TableInfo;

public interface TableService {
    public String extractShortcut(PartDescription var1);

    public String extractShortcut(String var1);

    public TableNameInfo getTableNameInfo(String var1);

    public Collection<TableInfo> getAvailableTables();

    public Map<String, Collection<TableError>> getTableErrors(IModelSession var1, Set<String> var2, TableInfo.Pt1TableCategory var3);

    public String transformToCsv(String var1, TableType var2, IModelSession var3, Set<String> var4);

    public Table transformToTable(String var1, TableType var2, IModelSession var3, Set<String> var4);

    public Map<TableInfo, Table> transformTables(IProgressMonitor var1, IModelSession var2, Set<TableInfo> var3, TableType var4, Set<String> var5);

    public void updateTable(BasePart var1, List<TableInfo.Pt1TableCategory> var2, Runnable var3, Runnable var4);

    public Set<Integer> getFixedColumns(String var1);

    public static boolean isTransformComplete(String shortcut, Predicate<String> supplementCondition) {
        return Thread.getAllStackTraces().keySet().stream().map(t -> t.getName().toLowerCase()).filter(t -> supplementCondition == null || supplementCondition.test((String)t)).noneMatch(name -> name.startsWith(shortcut.toLowerCase()));
    }

    public Table createCompareProjectTable(String var1, TableType var2, Set<String> var3);
}

