/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.nattable.utils;

import java.util.List;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.extension.nebula.richtext.RichTextCellPainter;
import org.eclipse.nebula.widgets.nattable.extension.nebula.richtext.RichTextConfigAttributes;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;

public class PlanProRichTextCellPainter
extends RichTextCellPainter {
    private static final String WORD_SPLIT_REGEX = "[\\t\\n\\x0B\\f\\r\\u200b]";

    public PlanProRichTextCellPainter(boolean wrapText, boolean calculateByTextLength, boolean calculateByTextHeight) {
        super(wrapText, calculateByTextLength, calculateByTextHeight);
        this.richTextPainter.setWordSplitRegex(WORD_SPLIT_REGEX);
    }

    protected String getHtmlText(ILayerCell cell, IConfigRegistry configRegistry) {
        Object canonicalValue = cell.getDataValue();
        IDisplayConverter markupDisplayConverter = (IDisplayConverter)configRegistry.getConfigAttribute(RichTextConfigAttributes.MARKUP_DISPLAY_CONVERTER, cell.getDisplayMode(), (List)cell.getConfigLabels());
        Object displayValue = markupDisplayConverter != null ? markupDisplayConverter.canonicalToDisplayValue(cell, configRegistry, canonicalValue) : canonicalValue;
        return displayValue == null ? "" : String.valueOf(displayValue);
    }
}

