/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfcloud.jackson.annotations;

import com.fasterxml.jackson.databind.DatabindContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emfcloud.jackson.databind.EMFContext;
import org.eclipse.emfcloud.jackson.resource.JsonResource;
import org.eclipse.emfcloud.jackson.utils.ValueReader;
import org.eclipse.emfcloud.jackson.utils.ValueWriter;

public class EcoreIdentityInfo {
    public static final String PROPERTY = "@id";
    private static final ValueReader<Object, String> DEFAULT_VALUE_READER = (value, context) -> value.toString();
    private static final ValueWriter<EObject, Object> DEFAULT_VALUE_WRITER = (object, context) -> {
        Resource resource = EMFContext.getResource((DatabindContext)context, object);
        String id = resource instanceof JsonResource ? ((JsonResource)resource).getID((EObject)object) : EMFContext.getURI((DatabindContext)context, object).fragment();
        return id;
    };
    private final String property;
    private final ValueReader<Object, String> valueReader;
    private final ValueWriter<EObject, Object> valueWriter;

    public EcoreIdentityInfo() {
        this(null, null, null);
    }

    public EcoreIdentityInfo(String property) {
        this(property, null, null);
    }

    public EcoreIdentityInfo(String property, ValueReader<Object, String> valueReader) {
        this(property, valueReader, null);
    }

    public EcoreIdentityInfo(String property, ValueWriter<EObject, Object> valueWriter) {
        this(property, null, valueWriter);
    }

    public EcoreIdentityInfo(String property, ValueReader<Object, String> valueReader, ValueWriter<EObject, Object> valueWriter) {
        this.property = property == null ? PROPERTY : property;
        this.valueReader = valueReader == null ? DEFAULT_VALUE_READER : valueReader;
        this.valueWriter = valueWriter == null ? DEFAULT_VALUE_WRITER : valueWriter;
    }

    public String getProperty() {
        return this.property;
    }

    public ValueReader<Object, String> getValueReader() {
        return this.valueReader;
    }

    public ValueWriter<EObject, Object> getValueWriter() {
        return this.valueWriter;
    }
}

