/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.export.xsl;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.eclipse.set.utils.export.xsl.XMLDocumentExtensions;
import org.eclipse.set.utils.export.xsl.XSLConstant;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TransformStyle {
    private TransformStyle() {
    }

    public static void transformCellStyle(Element xslCell, Optional<Cell> excelCell) {
        if (excelCell.isEmpty()) {
            return;
        }
        CellStyle excelStyle = excelCell.get().getCellStyle();
        Map<XSLConstant.TableAttribute.BorderDirection, String> transformBorderStyle = TransformStyle.transformBorderStyle(excelStyle);
        TransformStyle.setBorderStyle(xslCell, transformBorderStyle);
        TransformStyle.setTextAlgin(xslCell, excelStyle.getAlignment());
        TransformStyle.setTextFont(xslCell, excelCell.get());
    }

    private static void setBorderStyle(Element cell, Map<XSLConstant.TableAttribute.BorderDirection, String> borderStyles) {
        borderStyles.forEach((borderDirection, style) -> {
            if (style.isBlank() || style.isEmpty()) {
                return;
            }
            cell.setAttribute(borderDirection.getDirectionString(), String.format("{$%s}", style));
        });
    }

    public static void setBorderStyle(Optional<Cell> cell, Element xslCell, XSLConstant.TableAttribute.BorderDirection direction) {
        if (cell.isEmpty()) {
            return;
        }
        String style = TransformStyle.transformBorderStyle(cell.get().getCellStyle()).get((Object)direction);
        TransformStyle.setBorderStyle(xslCell, direction, style);
    }

    public static void setBorderStyle(Element xslCell, XSLConstant.TableAttribute.BorderDirection direction, String borderStyle) {
        if (borderStyle.isEmpty() || borderStyle.isBlank()) {
            xslCell.removeAttribute(direction.getDirectionString());
        } else {
            xslCell.setAttribute(direction.getDirectionString(), String.format("{$%s}", borderStyle));
        }
    }

    public static Map<XSLConstant.TableAttribute.BorderDirection, String> transformBorderStyle(CellStyle style) {
        return Map.of(XSLConstant.TableAttribute.BorderDirection.TOP, TransformStyle.transformBorderStyle(style.getBorderTop()), XSLConstant.TableAttribute.BorderDirection.BOTTOM, TransformStyle.transformBorderStyle(style.getBorderBottom()), XSLConstant.TableAttribute.BorderDirection.LEFT, TransformStyle.transformBorderStyle(style.getBorderLeft()), XSLConstant.TableAttribute.BorderDirection.RIGHT, TransformStyle.transformBorderStyle(style.getBorderRight()));
    }

    private static String transformBorderStyle(BorderStyle borderStyle) {
        return switch (borderStyle) {
            case BorderStyle.THIN -> "small-border-style";
            case BorderStyle.MEDIUM -> "wide-border-style";
            default -> "";
        };
    }

    private static void setTextAlgin(Element xslCell, HorizontalAlignment horizonAlign) {
        String horizon = switch (horizonAlign) {
            case HorizontalAlignment.LEFT -> HorizontalAlignment.LEFT.name();
            case HorizontalAlignment.RIGHT -> HorizontalAlignment.RIGHT.name();
            default -> HorizontalAlignment.CENTER.name();
        };
        xslCell.setAttribute(XSLConstant.TableAttribute.TEXT_ALIGN, horizon.toLowerCase());
    }

    private static void setTextFont(Element xslCell, Cell excelCell) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Workbook workBook = excelCell.getRow().getSheet().getWorkbook();){
                int fontIndex = excelCell.getCellStyle().getFontIndex();
                Font textFont = workBook.getFontAt(fontIndex);
                if (textFont.getBold()) {
                    xslCell.setAttribute(XSLConstant.TableAttribute.FONT_WEIGHT, "blod");
                }
                if (textFont.getItalic()) {
                    xslCell.setAttribute(XSLConstant.TableAttribute.FONT_STYLE, "italic");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setCellContent(Element xslBlock, Cell excelCell) {
        Document doc = xslBlock.getOwnerDocument();
        RichTextString richStringCellValue = excelCell.getRichStringCellValue();
        if (richStringCellValue.numFormattingRuns() == 0) {
            xslBlock.setTextContent(richStringCellValue.getString());
            return;
        }
        BiFunction<String, String, Element> addSupSubElement = (textValue, attributeValue) -> {
            Element inline = XMLDocumentExtensions.createXMLElementWithAttr(doc, "fo:inline", new XMLDocumentExtensions.XMLAttribute("baseline-shift", (String)attributeValue), new XMLDocumentExtensions.XMLAttribute("font-size", "4pt"));
            inline.setTextContent((String)textValue);
            return inline;
        };
        if (richStringCellValue instanceof XSSFRichTextString) {
            XSSFRichTextString richtext = (XSSFRichTextString)richStringCellValue;
            int i = 0;
            while (i < richtext.numFormattingRuns()) {
                int startIndex = richtext.getIndexOfFormattingRun(i);
                int endIndex = i + 1 < richtext.numFormattingRuns() ? richtext.getIndexOfFormattingRun(i + 1) : richtext.length();
                String text = richtext.getString().substring(startIndex, endIndex);
                XSSFFont fontOfFormattingRun = richtext.getFontOfFormattingRun(i);
                if (fontOfFormattingRun == null) {
                    xslBlock.appendChild(doc.createTextNode(text));
                } else {
                    Element formatElement;
                    switch (fontOfFormattingRun.getTypeOffset()) {
                        case 1: {
                            Element element = addSupSubElement.apply(text, "super");
                            break;
                        }
                        case 2: {
                            Element element = addSupSubElement.apply(text, "sub");
                            break;
                        }
                        default: {
                            Element element = formatElement = null;
                        }
                    }
                    if (formatElement != null) {
                        xslBlock.appendChild(formatElement);
                    }
                }
                ++i;
            }
        }
    }

    public static void setExcelCellBorderStyle(Optional<Cell> cell, Map<XSLConstant.TableAttribute.BorderDirection, BorderStyle> borderStyles) {
        borderStyles.forEach((direction, style) -> TransformStyle.setExcelCellBorderStyle(cell, direction, style));
    }

    public static void setExcelCellBorderStyle(Optional<Cell> cell, XSLConstant.TableAttribute.BorderDirection direction, BorderStyle style) {
        if (cell.isEmpty()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Workbook workbook = cell.get().getSheet().getWorkbook();){
                CellStyle newStyle = workbook.createCellStyle();
                newStyle.cloneStyleFrom(cell.get().getCellStyle());
                switch (direction) {
                    case LEFT: {
                        newStyle.setBorderLeft(style);
                        break;
                    }
                    case RIGHT: {
                        newStyle.setBorderRight(style);
                        break;
                    }
                    case TOP: {
                        newStyle.setBorderTop(style);
                        break;
                    }
                    case BOTTOM: {
                        newStyle.setBorderBottom(style);
                        break;
                    }
                }
                cell.get().setCellStyle(newStyle);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

