/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.toolboxmodel.transform.internal;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.set.toolboxmodel.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.toolboxmodel.PlanPro.WzkInvalidIDReference;
import org.eclipse.set.toolboxmodel.transform.internal.GuidCache;

public class ToolboxIDResolver {
    private final GuidCache guidCache = new GuidCache();

    private ToolboxIDResolver(PlanPro_Schnittstelle model) {
        this.guidCache.prepare(model);
    }

    public static void resolveIDReferences(PlanPro_Schnittstelle model) {
        ToolboxIDResolver resolver = new ToolboxIDResolver(model);
        EList refs = model.getWzkInvalidIDReferences();
        List<WzkInvalidIDReference> resolved = refs.stream().filter(reference -> resolver.resolveIDReference((WzkInvalidIDReference)reference)).toList();
        refs.removeAll(resolved);
    }

    private boolean resolveIDReference(WzkInvalidIDReference reference) {
        if (reference.getGuid() == null) {
            if (reference.getTargetRef().isUnsettable()) {
                return ToolboxIDResolver.setIDReference(reference, null);
            }
            return false;
        }
        EObject value = this.guidCache.get(reference.getGuid(), reference.getTarget());
        if (value != null) {
            return ToolboxIDResolver.setIDReference(reference, value);
        }
        return false;
    }

    private static boolean setIDReference(WzkInvalidIDReference reference, EObject value) {
        EClass referenceType = reference.getTargetRef().getEReferenceType();
        if (value != null) {
            Class<?> valueClass = value.getClass();
            Class referenceClass = referenceType.getInstanceClass();
            if (!referenceClass.isAssignableFrom(valueClass)) {
                return false;
            }
        }
        if (reference.getTargetRef().isMany()) {
            EList list = (EList)reference.getTarget().eGet((EStructuralFeature)reference.getTargetRef());
            list.add((Object)value);
        } else {
            reference.getTarget().eSet((EStructuralFeature)reference.getTargetRef(), (Object)value);
        }
        return true;
    }
}

