/**
 * Copyright (c) 2023 DB Netz AG and others.
 *  
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 */
package org.eclipse.set.toolboxmodel.Ortung;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>ENUM Zugeinwirkung Art</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.set.toolboxmodel.Ortung.OrtungPackage#getENUMZugeinwirkungArt()
 * @model extendedMetaData="name='ENUMZugeinwirkung_Art'"
 * @generated
 */
public enum ENUMZugeinwirkungArt implements Enumerator {
	/**
	 * The '<em><b>ENUM Zugeinwirkung Art Doppel Schleife</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_ZUGEINWIRKUNG_ART_DOPPEL_SCHLEIFE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_ZUGEINWIRKUNG_ART_DOPPEL_SCHLEIFE(0, "ENUMZugeinwirkung_Art_Doppel_Schleife", "Doppel_Schleife"),

	/**
	 * The '<em><b>ENUM Zugeinwirkung Art Doppel Sensor</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_ZUGEINWIRKUNG_ART_DOPPEL_SENSOR_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_ZUGEINWIRKUNG_ART_DOPPEL_SENSOR(1, "ENUMZugeinwirkung_Art_Doppel_Sensor", "Doppel_Sensor"),

	/**
	 * The '<em><b>ENUM Zugeinwirkung Art Dreifach Schleife</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_ZUGEINWIRKUNG_ART_DREIFACH_SCHLEIFE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_ZUGEINWIRKUNG_ART_DREIFACH_SCHLEIFE(2, "ENUMZugeinwirkung_Art_Dreifach_Schleife", "Dreifach_Schleife"),

	/**
	 * The '<em><b>ENUM Zugeinwirkung Art Einfach Schleife</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_ZUGEINWIRKUNG_ART_EINFACH_SCHLEIFE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_ZUGEINWIRKUNG_ART_EINFACH_SCHLEIFE(3, "ENUMZugeinwirkung_Art_Einfach_Schleife", "Einfach_Schleife"),

	/**
	 * The '<em><b>ENUM Zugeinwirkung Art Einfach Sensor</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_ZUGEINWIRKUNG_ART_EINFACH_SENSOR_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_ZUGEINWIRKUNG_ART_EINFACH_SENSOR(4, "ENUMZugeinwirkung_Art_Einfach_Sensor", "Einfach_Sensor"),

	/**
	 * The '<em><b>ENUM Zugeinwirkung Art Einfach Sensor richtungsabhaengig</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_ZUGEINWIRKUNG_ART_EINFACH_SENSOR_RICHTUNGSABHAENGIG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_ZUGEINWIRKUNG_ART_EINFACH_SENSOR_RICHTUNGSABHAENGIG(5, "ENUMZugeinwirkung_Art_Einfach_Sensor_richtungsabhaengig", "Einfach_Sensor_richtungsabhaengig"),

	/**
	 * The '<em><b>ENUM Zugeinwirkung Art Isolierte Schiene alleinstehend</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_ZUGEINWIRKUNG_ART_ISOLIERTE_SCHIENE_ALLEINSTEHEND_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_ZUGEINWIRKUNG_ART_ISOLIERTE_SCHIENE_ALLEINSTEHEND(6, "ENUMZugeinwirkung_Art_Isolierte_Schiene_alleinstehend", "Isolierte_Schiene_alleinstehend"),

	/**
	 * The '<em><b>ENUM Zugeinwirkung Art Isolierte Schiene FMA Anlage mitbenutzt</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_ZUGEINWIRKUNG_ART_ISOLIERTE_SCHIENE_FMA_ANLAGE_MITBENUTZT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_ZUGEINWIRKUNG_ART_ISOLIERTE_SCHIENE_FMA_ANLAGE_MITBENUTZT(7, "ENUMZugeinwirkung_Art_Isolierte_Schiene_FMA_Anlage_mitbenutzt", "Isolierte_Schiene_FMA_Anlage_mitbenutzt"),

	/**
	 * The '<em><b>ENUM Zugeinwirkung Art Schienenkontakt</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_ZUGEINWIRKUNG_ART_SCHIENENKONTAKT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_ZUGEINWIRKUNG_ART_SCHIENENKONTAKT(8, "ENUMZugeinwirkung_Art_Schienenkontakt", "Schienenkontakt"),

	/**
	 * The '<em><b>ENUM Zugeinwirkung Art sonstige</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_ZUGEINWIRKUNG_ART_SONSTIGE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_ZUGEINWIRKUNG_ART_SONSTIGE(9, "ENUMZugeinwirkung_Art_sonstige", "sonstige");

	/**
	 * The '<em><b>ENUM Zugeinwirkung Art Doppel Schleife</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_ZUGEINWIRKUNG_ART_DOPPEL_SCHLEIFE
	 * @model name="ENUMZugeinwirkung_Art_Doppel_Schleife" literal="Doppel_Schleife"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_ZUGEINWIRKUNG_ART_DOPPEL_SCHLEIFE_VALUE = 0;

	/**
	 * The '<em><b>ENUM Zugeinwirkung Art Doppel Sensor</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_ZUGEINWIRKUNG_ART_DOPPEL_SENSOR
	 * @model name="ENUMZugeinwirkung_Art_Doppel_Sensor" literal="Doppel_Sensor"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_ZUGEINWIRKUNG_ART_DOPPEL_SENSOR_VALUE = 1;

	/**
	 * The '<em><b>ENUM Zugeinwirkung Art Dreifach Schleife</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_ZUGEINWIRKUNG_ART_DREIFACH_SCHLEIFE
	 * @model name="ENUMZugeinwirkung_Art_Dreifach_Schleife" literal="Dreifach_Schleife"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_ZUGEINWIRKUNG_ART_DREIFACH_SCHLEIFE_VALUE = 2;

	/**
	 * The '<em><b>ENUM Zugeinwirkung Art Einfach Schleife</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_ZUGEINWIRKUNG_ART_EINFACH_SCHLEIFE
	 * @model name="ENUMZugeinwirkung_Art_Einfach_Schleife" literal="Einfach_Schleife"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_ZUGEINWIRKUNG_ART_EINFACH_SCHLEIFE_VALUE = 3;

	/**
	 * The '<em><b>ENUM Zugeinwirkung Art Einfach Sensor</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_ZUGEINWIRKUNG_ART_EINFACH_SENSOR
	 * @model name="ENUMZugeinwirkung_Art_Einfach_Sensor" literal="Einfach_Sensor"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_ZUGEINWIRKUNG_ART_EINFACH_SENSOR_VALUE = 4;

	/**
	 * The '<em><b>ENUM Zugeinwirkung Art Einfach Sensor richtungsabhaengig</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_ZUGEINWIRKUNG_ART_EINFACH_SENSOR_RICHTUNGSABHAENGIG
	 * @model name="ENUMZugeinwirkung_Art_Einfach_Sensor_richtungsabhaengig" literal="Einfach_Sensor_richtungsabhaengig"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_ZUGEINWIRKUNG_ART_EINFACH_SENSOR_RICHTUNGSABHAENGIG_VALUE = 5;

	/**
	 * The '<em><b>ENUM Zugeinwirkung Art Isolierte Schiene alleinstehend</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_ZUGEINWIRKUNG_ART_ISOLIERTE_SCHIENE_ALLEINSTEHEND
	 * @model name="ENUMZugeinwirkung_Art_Isolierte_Schiene_alleinstehend" literal="Isolierte_Schiene_alleinstehend"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_ZUGEINWIRKUNG_ART_ISOLIERTE_SCHIENE_ALLEINSTEHEND_VALUE = 6;

	/**
	 * The '<em><b>ENUM Zugeinwirkung Art Isolierte Schiene FMA Anlage mitbenutzt</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_ZUGEINWIRKUNG_ART_ISOLIERTE_SCHIENE_FMA_ANLAGE_MITBENUTZT
	 * @model name="ENUMZugeinwirkung_Art_Isolierte_Schiene_FMA_Anlage_mitbenutzt" literal="Isolierte_Schiene_FMA_Anlage_mitbenutzt"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_ZUGEINWIRKUNG_ART_ISOLIERTE_SCHIENE_FMA_ANLAGE_MITBENUTZT_VALUE = 7;

	/**
	 * The '<em><b>ENUM Zugeinwirkung Art Schienenkontakt</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_ZUGEINWIRKUNG_ART_SCHIENENKONTAKT
	 * @model name="ENUMZugeinwirkung_Art_Schienenkontakt" literal="Schienenkontakt"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_ZUGEINWIRKUNG_ART_SCHIENENKONTAKT_VALUE = 8;

	/**
	 * The '<em><b>ENUM Zugeinwirkung Art sonstige</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_ZUGEINWIRKUNG_ART_SONSTIGE
	 * @model name="ENUMZugeinwirkung_Art_sonstige" literal="sonstige"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_ZUGEINWIRKUNG_ART_SONSTIGE_VALUE = 9;

	/**
	 * An array of all the '<em><b>ENUM Zugeinwirkung Art</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final ENUMZugeinwirkungArt[] VALUES_ARRAY =
		new ENUMZugeinwirkungArt[] {
			ENUM_ZUGEINWIRKUNG_ART_DOPPEL_SCHLEIFE,
			ENUM_ZUGEINWIRKUNG_ART_DOPPEL_SENSOR,
			ENUM_ZUGEINWIRKUNG_ART_DREIFACH_SCHLEIFE,
			ENUM_ZUGEINWIRKUNG_ART_EINFACH_SCHLEIFE,
			ENUM_ZUGEINWIRKUNG_ART_EINFACH_SENSOR,
			ENUM_ZUGEINWIRKUNG_ART_EINFACH_SENSOR_RICHTUNGSABHAENGIG,
			ENUM_ZUGEINWIRKUNG_ART_ISOLIERTE_SCHIENE_ALLEINSTEHEND,
			ENUM_ZUGEINWIRKUNG_ART_ISOLIERTE_SCHIENE_FMA_ANLAGE_MITBENUTZT,
			ENUM_ZUGEINWIRKUNG_ART_SCHIENENKONTAKT,
			ENUM_ZUGEINWIRKUNG_ART_SONSTIGE,
		};

	/**
	 * A public read-only list of all the '<em><b>ENUM Zugeinwirkung Art</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<ENUMZugeinwirkungArt> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>ENUM Zugeinwirkung Art</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMZugeinwirkungArt get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMZugeinwirkungArt result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUM Zugeinwirkung Art</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMZugeinwirkungArt getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMZugeinwirkungArt result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUM Zugeinwirkung Art</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMZugeinwirkungArt get(int value) {
		switch (value) {
			case ENUM_ZUGEINWIRKUNG_ART_DOPPEL_SCHLEIFE_VALUE: return ENUM_ZUGEINWIRKUNG_ART_DOPPEL_SCHLEIFE;
			case ENUM_ZUGEINWIRKUNG_ART_DOPPEL_SENSOR_VALUE: return ENUM_ZUGEINWIRKUNG_ART_DOPPEL_SENSOR;
			case ENUM_ZUGEINWIRKUNG_ART_DREIFACH_SCHLEIFE_VALUE: return ENUM_ZUGEINWIRKUNG_ART_DREIFACH_SCHLEIFE;
			case ENUM_ZUGEINWIRKUNG_ART_EINFACH_SCHLEIFE_VALUE: return ENUM_ZUGEINWIRKUNG_ART_EINFACH_SCHLEIFE;
			case ENUM_ZUGEINWIRKUNG_ART_EINFACH_SENSOR_VALUE: return ENUM_ZUGEINWIRKUNG_ART_EINFACH_SENSOR;
			case ENUM_ZUGEINWIRKUNG_ART_EINFACH_SENSOR_RICHTUNGSABHAENGIG_VALUE: return ENUM_ZUGEINWIRKUNG_ART_EINFACH_SENSOR_RICHTUNGSABHAENGIG;
			case ENUM_ZUGEINWIRKUNG_ART_ISOLIERTE_SCHIENE_ALLEINSTEHEND_VALUE: return ENUM_ZUGEINWIRKUNG_ART_ISOLIERTE_SCHIENE_ALLEINSTEHEND;
			case ENUM_ZUGEINWIRKUNG_ART_ISOLIERTE_SCHIENE_FMA_ANLAGE_MITBENUTZT_VALUE: return ENUM_ZUGEINWIRKUNG_ART_ISOLIERTE_SCHIENE_FMA_ANLAGE_MITBENUTZT;
			case ENUM_ZUGEINWIRKUNG_ART_SCHIENENKONTAKT_VALUE: return ENUM_ZUGEINWIRKUNG_ART_SCHIENENKONTAKT;
			case ENUM_ZUGEINWIRKUNG_ART_SONSTIGE_VALUE: return ENUM_ZUGEINWIRKUNG_ART_SONSTIGE;
			default: return null;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private ENUMZugeinwirkungArt(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //ENUMZugeinwirkungArt
