/**
 * Copyright (c) 2023 DB Netz AG and others.
 *  
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 */
package org.eclipse.set.toolboxmodel.Bahnuebergang;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>ENUM Klassifizierung</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.set.toolboxmodel.Bahnuebergang.BahnuebergangPackage#getENUMKlassifizierung()
 * @model extendedMetaData="name='ENUMKlassifizierung'"
 * @generated
 */
public enum ENUMKlassifizierung implements Enumerator {
	/**
	 * The '<em><b>ENUM Klassifizierung Bundestrasse ausserorts</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_KLASSIFIZIERUNG_BUNDESTRASSE_AUSSERORTS_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_KLASSIFIZIERUNG_BUNDESTRASSE_AUSSERORTS(0, "ENUMKlassifizierung_Bundestrasse_ausserorts", "Bundestrasse_ausserorts"),

	/**
	 * The '<em><b>ENUM Klassifizierung Bundestrasse innerorts</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_KLASSIFIZIERUNG_BUNDESTRASSE_INNERORTS_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_KLASSIFIZIERUNG_BUNDESTRASSE_INNERORTS(1, "ENUMKlassifizierung_Bundestrasse_innerorts", "Bundestrasse_innerorts"),

	/**
	 * The '<em><b>ENUM Klassifizierung Fussweg</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_KLASSIFIZIERUNG_FUSSWEG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_KLASSIFIZIERUNG_FUSSWEG(2, "ENUMKlassifizierung_Fussweg", "Fussweg"),

	/**
	 * The '<em><b>ENUM Klassifizierung Fussweg Radweg</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_KLASSIFIZIERUNG_FUSSWEG_RADWEG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_KLASSIFIZIERUNG_FUSSWEG_RADWEG(3, "ENUMKlassifizierung_Fussweg_Radweg", "Fussweg_Radweg"),

	/**
	 * The '<em><b>ENUM Klassifizierung Gemeindestrasse ausserorts</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_KLASSIFIZIERUNG_GEMEINDESTRASSE_AUSSERORTS_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_KLASSIFIZIERUNG_GEMEINDESTRASSE_AUSSERORTS(4, "ENUMKlassifizierung_Gemeindestrasse_ausserorts", "Gemeindestrasse_ausserorts"),

	/**
	 * The '<em><b>ENUM Klassifizierung Gemeindestrasse innerorts</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_KLASSIFIZIERUNG_GEMEINDESTRASSE_INNERORTS_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_KLASSIFIZIERUNG_GEMEINDESTRASSE_INNERORTS(5, "ENUMKlassifizierung_Gemeindestrasse_innerorts", "Gemeindestrasse_innerorts"),

	/**
	 * The '<em><b>ENUM Klassifizierung Kreisstrasse ausserorts</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_KLASSIFIZIERUNG_KREISSTRASSE_AUSSERORTS_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_KLASSIFIZIERUNG_KREISSTRASSE_AUSSERORTS(6, "ENUMKlassifizierung_Kreisstrasse_ausserorts", "Kreisstrasse_ausserorts"),

	/**
	 * The '<em><b>ENUM Klassifizierung Kreisstrasse innerorts</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_KLASSIFIZIERUNG_KREISSTRASSE_INNERORTS_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_KLASSIFIZIERUNG_KREISSTRASSE_INNERORTS(7, "ENUMKlassifizierung_Kreisstrasse_innerorts", "Kreisstrasse_innerorts"),

	/**
	 * The '<em><b>ENUM Klassifizierung Landstrasse ausserorts</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_KLASSIFIZIERUNG_LANDSTRASSE_AUSSERORTS_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_KLASSIFIZIERUNG_LANDSTRASSE_AUSSERORTS(8, "ENUMKlassifizierung_Landstrasse_ausserorts", "Landstrasse_ausserorts"),

	/**
	 * The '<em><b>ENUM Klassifizierung Landstrasse innerorts</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_KLASSIFIZIERUNG_LANDSTRASSE_INNERORTS_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_KLASSIFIZIERUNG_LANDSTRASSE_INNERORTS(9, "ENUMKlassifizierung_Landstrasse_innerorts", "Landstrasse_innerorts"),

	/**
	 * The '<em><b>ENUM Klassifizierung Privatstrasse</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_KLASSIFIZIERUNG_PRIVATSTRASSE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_KLASSIFIZIERUNG_PRIVATSTRASSE(10, "ENUMKlassifizierung_Privatstrasse", "Privatstrasse"),

	/**
	 * The '<em><b>ENUM Klassifizierung Privatweg</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_KLASSIFIZIERUNG_PRIVATWEG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_KLASSIFIZIERUNG_PRIVATWEG(11, "ENUMKlassifizierung_Privatweg", "Privatweg"),

	/**
	 * The '<em><b>ENUM Klassifizierung sonstige</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_KLASSIFIZIERUNG_SONSTIGE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_KLASSIFIZIERUNG_SONSTIGE(12, "ENUMKlassifizierung_sonstige", "sonstige"),

	/**
	 * The '<em><b>ENUM Klassifizierung Weg Forst Land</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_KLASSIFIZIERUNG_WEG_FORST_LAND_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_KLASSIFIZIERUNG_WEG_FORST_LAND(13, "ENUMKlassifizierung_Weg_Forst_Land", "Weg_Forst_Land");

	/**
	 * The '<em><b>ENUM Klassifizierung Bundestrasse ausserorts</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_KLASSIFIZIERUNG_BUNDESTRASSE_AUSSERORTS
	 * @model name="ENUMKlassifizierung_Bundestrasse_ausserorts" literal="Bundestrasse_ausserorts"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_KLASSIFIZIERUNG_BUNDESTRASSE_AUSSERORTS_VALUE = 0;

	/**
	 * The '<em><b>ENUM Klassifizierung Bundestrasse innerorts</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_KLASSIFIZIERUNG_BUNDESTRASSE_INNERORTS
	 * @model name="ENUMKlassifizierung_Bundestrasse_innerorts" literal="Bundestrasse_innerorts"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_KLASSIFIZIERUNG_BUNDESTRASSE_INNERORTS_VALUE = 1;

	/**
	 * The '<em><b>ENUM Klassifizierung Fussweg</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_KLASSIFIZIERUNG_FUSSWEG
	 * @model name="ENUMKlassifizierung_Fussweg" literal="Fussweg"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_KLASSIFIZIERUNG_FUSSWEG_VALUE = 2;

	/**
	 * The '<em><b>ENUM Klassifizierung Fussweg Radweg</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_KLASSIFIZIERUNG_FUSSWEG_RADWEG
	 * @model name="ENUMKlassifizierung_Fussweg_Radweg" literal="Fussweg_Radweg"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_KLASSIFIZIERUNG_FUSSWEG_RADWEG_VALUE = 3;

	/**
	 * The '<em><b>ENUM Klassifizierung Gemeindestrasse ausserorts</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_KLASSIFIZIERUNG_GEMEINDESTRASSE_AUSSERORTS
	 * @model name="ENUMKlassifizierung_Gemeindestrasse_ausserorts" literal="Gemeindestrasse_ausserorts"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_KLASSIFIZIERUNG_GEMEINDESTRASSE_AUSSERORTS_VALUE = 4;

	/**
	 * The '<em><b>ENUM Klassifizierung Gemeindestrasse innerorts</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_KLASSIFIZIERUNG_GEMEINDESTRASSE_INNERORTS
	 * @model name="ENUMKlassifizierung_Gemeindestrasse_innerorts" literal="Gemeindestrasse_innerorts"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_KLASSIFIZIERUNG_GEMEINDESTRASSE_INNERORTS_VALUE = 5;

	/**
	 * The '<em><b>ENUM Klassifizierung Kreisstrasse ausserorts</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_KLASSIFIZIERUNG_KREISSTRASSE_AUSSERORTS
	 * @model name="ENUMKlassifizierung_Kreisstrasse_ausserorts" literal="Kreisstrasse_ausserorts"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_KLASSIFIZIERUNG_KREISSTRASSE_AUSSERORTS_VALUE = 6;

	/**
	 * The '<em><b>ENUM Klassifizierung Kreisstrasse innerorts</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_KLASSIFIZIERUNG_KREISSTRASSE_INNERORTS
	 * @model name="ENUMKlassifizierung_Kreisstrasse_innerorts" literal="Kreisstrasse_innerorts"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_KLASSIFIZIERUNG_KREISSTRASSE_INNERORTS_VALUE = 7;

	/**
	 * The '<em><b>ENUM Klassifizierung Landstrasse ausserorts</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_KLASSIFIZIERUNG_LANDSTRASSE_AUSSERORTS
	 * @model name="ENUMKlassifizierung_Landstrasse_ausserorts" literal="Landstrasse_ausserorts"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_KLASSIFIZIERUNG_LANDSTRASSE_AUSSERORTS_VALUE = 8;

	/**
	 * The '<em><b>ENUM Klassifizierung Landstrasse innerorts</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_KLASSIFIZIERUNG_LANDSTRASSE_INNERORTS
	 * @model name="ENUMKlassifizierung_Landstrasse_innerorts" literal="Landstrasse_innerorts"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_KLASSIFIZIERUNG_LANDSTRASSE_INNERORTS_VALUE = 9;

	/**
	 * The '<em><b>ENUM Klassifizierung Privatstrasse</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_KLASSIFIZIERUNG_PRIVATSTRASSE
	 * @model name="ENUMKlassifizierung_Privatstrasse" literal="Privatstrasse"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_KLASSIFIZIERUNG_PRIVATSTRASSE_VALUE = 10;

	/**
	 * The '<em><b>ENUM Klassifizierung Privatweg</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_KLASSIFIZIERUNG_PRIVATWEG
	 * @model name="ENUMKlassifizierung_Privatweg" literal="Privatweg"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_KLASSIFIZIERUNG_PRIVATWEG_VALUE = 11;

	/**
	 * The '<em><b>ENUM Klassifizierung sonstige</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_KLASSIFIZIERUNG_SONSTIGE
	 * @model name="ENUMKlassifizierung_sonstige" literal="sonstige"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_KLASSIFIZIERUNG_SONSTIGE_VALUE = 12;

	/**
	 * The '<em><b>ENUM Klassifizierung Weg Forst Land</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_KLASSIFIZIERUNG_WEG_FORST_LAND
	 * @model name="ENUMKlassifizierung_Weg_Forst_Land" literal="Weg_Forst_Land"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_KLASSIFIZIERUNG_WEG_FORST_LAND_VALUE = 13;

	/**
	 * An array of all the '<em><b>ENUM Klassifizierung</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final ENUMKlassifizierung[] VALUES_ARRAY =
		new ENUMKlassifizierung[] {
			ENUM_KLASSIFIZIERUNG_BUNDESTRASSE_AUSSERORTS,
			ENUM_KLASSIFIZIERUNG_BUNDESTRASSE_INNERORTS,
			ENUM_KLASSIFIZIERUNG_FUSSWEG,
			ENUM_KLASSIFIZIERUNG_FUSSWEG_RADWEG,
			ENUM_KLASSIFIZIERUNG_GEMEINDESTRASSE_AUSSERORTS,
			ENUM_KLASSIFIZIERUNG_GEMEINDESTRASSE_INNERORTS,
			ENUM_KLASSIFIZIERUNG_KREISSTRASSE_AUSSERORTS,
			ENUM_KLASSIFIZIERUNG_KREISSTRASSE_INNERORTS,
			ENUM_KLASSIFIZIERUNG_LANDSTRASSE_AUSSERORTS,
			ENUM_KLASSIFIZIERUNG_LANDSTRASSE_INNERORTS,
			ENUM_KLASSIFIZIERUNG_PRIVATSTRASSE,
			ENUM_KLASSIFIZIERUNG_PRIVATWEG,
			ENUM_KLASSIFIZIERUNG_SONSTIGE,
			ENUM_KLASSIFIZIERUNG_WEG_FORST_LAND,
		};

	/**
	 * A public read-only list of all the '<em><b>ENUM Klassifizierung</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<ENUMKlassifizierung> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>ENUM Klassifizierung</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMKlassifizierung get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMKlassifizierung result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUM Klassifizierung</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMKlassifizierung getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMKlassifizierung result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUM Klassifizierung</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMKlassifizierung get(int value) {
		switch (value) {
			case ENUM_KLASSIFIZIERUNG_BUNDESTRASSE_AUSSERORTS_VALUE: return ENUM_KLASSIFIZIERUNG_BUNDESTRASSE_AUSSERORTS;
			case ENUM_KLASSIFIZIERUNG_BUNDESTRASSE_INNERORTS_VALUE: return ENUM_KLASSIFIZIERUNG_BUNDESTRASSE_INNERORTS;
			case ENUM_KLASSIFIZIERUNG_FUSSWEG_VALUE: return ENUM_KLASSIFIZIERUNG_FUSSWEG;
			case ENUM_KLASSIFIZIERUNG_FUSSWEG_RADWEG_VALUE: return ENUM_KLASSIFIZIERUNG_FUSSWEG_RADWEG;
			case ENUM_KLASSIFIZIERUNG_GEMEINDESTRASSE_AUSSERORTS_VALUE: return ENUM_KLASSIFIZIERUNG_GEMEINDESTRASSE_AUSSERORTS;
			case ENUM_KLASSIFIZIERUNG_GEMEINDESTRASSE_INNERORTS_VALUE: return ENUM_KLASSIFIZIERUNG_GEMEINDESTRASSE_INNERORTS;
			case ENUM_KLASSIFIZIERUNG_KREISSTRASSE_AUSSERORTS_VALUE: return ENUM_KLASSIFIZIERUNG_KREISSTRASSE_AUSSERORTS;
			case ENUM_KLASSIFIZIERUNG_KREISSTRASSE_INNERORTS_VALUE: return ENUM_KLASSIFIZIERUNG_KREISSTRASSE_INNERORTS;
			case ENUM_KLASSIFIZIERUNG_LANDSTRASSE_AUSSERORTS_VALUE: return ENUM_KLASSIFIZIERUNG_LANDSTRASSE_AUSSERORTS;
			case ENUM_KLASSIFIZIERUNG_LANDSTRASSE_INNERORTS_VALUE: return ENUM_KLASSIFIZIERUNG_LANDSTRASSE_INNERORTS;
			case ENUM_KLASSIFIZIERUNG_PRIVATSTRASSE_VALUE: return ENUM_KLASSIFIZIERUNG_PRIVATSTRASSE;
			case ENUM_KLASSIFIZIERUNG_PRIVATWEG_VALUE: return ENUM_KLASSIFIZIERUNG_PRIVATWEG;
			case ENUM_KLASSIFIZIERUNG_SONSTIGE_VALUE: return ENUM_KLASSIFIZIERUNG_SONSTIGE;
			case ENUM_KLASSIFIZIERUNG_WEG_FORST_LAND_VALUE: return ENUM_KLASSIFIZIERUNG_WEG_FORST_LAND;
			default: return null;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private ENUMKlassifizierung(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //ENUMKlassifizierung
