/**
 * Copyright (c) 2022 DB Netz AG and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 */
package org.eclipse.set.toolboxmodel.Flankenschutz.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.set.toolboxmodel.Flankenschutz.util.FlankenschutzAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class FlankenschutzItemProviderAdapterFactory extends FlankenschutzAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FlankenschutzItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Flankenschutz.Fahrt_Ueber_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fahrt_Ueber_TypeClassItemProvider fahrt_Ueber_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Flankenschutz.Fahrt_Ueber_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFahrt_Ueber_TypeClassAdapter() {
		if (fahrt_Ueber_TypeClassItemProvider == null) {
			fahrt_Ueber_TypeClassItemProvider = new Fahrt_Ueber_TypeClassItemProvider(this);
		}

		return fahrt_Ueber_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Flankenschutz.Fla_Freimelde_Zuordnung} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fla_Freimelde_ZuordnungItemProvider fla_Freimelde_ZuordnungItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Flankenschutz.Fla_Freimelde_Zuordnung}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFla_Freimelde_ZuordnungAdapter() {
		if (fla_Freimelde_ZuordnungItemProvider == null) {
			fla_Freimelde_ZuordnungItemProvider = new Fla_Freimelde_ZuordnungItemProvider(this);
		}

		return fla_Freimelde_ZuordnungItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Flankenschutz.Fla_Raum_Freimeldung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fla_Raum_Freimeldung_TypeClassItemProvider fla_Raum_Freimeldung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Flankenschutz.Fla_Raum_Freimeldung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFla_Raum_Freimeldung_TypeClassAdapter() {
		if (fla_Raum_Freimeldung_TypeClassItemProvider == null) {
			fla_Raum_Freimeldung_TypeClassItemProvider = new Fla_Raum_Freimeldung_TypeClassItemProvider(this);
		}

		return fla_Raum_Freimeldung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Flankenschutz.Fla_Schutz} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fla_SchutzItemProvider fla_SchutzItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Flankenschutz.Fla_Schutz}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFla_SchutzAdapter() {
		if (fla_SchutzItemProvider == null) {
			fla_SchutzItemProvider = new Fla_SchutzItemProvider(this);
		}

		return fla_SchutzItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Flankenschutz.Fla_Schutz_Anforderer_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fla_Schutz_Anforderer_AttributeGroupItemProvider fla_Schutz_Anforderer_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Flankenschutz.Fla_Schutz_Anforderer_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFla_Schutz_Anforderer_AttributeGroupAdapter() {
		if (fla_Schutz_Anforderer_AttributeGroupItemProvider == null) {
			fla_Schutz_Anforderer_AttributeGroupItemProvider = new Fla_Schutz_Anforderer_AttributeGroupItemProvider(this);
		}

		return fla_Schutz_Anforderer_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Flankenschutz.Fla_Schutz_Signal_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fla_Schutz_Signal_AttributeGroupItemProvider fla_Schutz_Signal_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Flankenschutz.Fla_Schutz_Signal_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFla_Schutz_Signal_AttributeGroupAdapter() {
		if (fla_Schutz_Signal_AttributeGroupItemProvider == null) {
			fla_Schutz_Signal_AttributeGroupItemProvider = new Fla_Schutz_Signal_AttributeGroupItemProvider(this);
		}

		return fla_Schutz_Signal_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Flankenschutz.Fla_Schutz_W_Gsp_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fla_Schutz_W_Gsp_AttributeGroupItemProvider fla_Schutz_W_Gsp_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Flankenschutz.Fla_Schutz_W_Gsp_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFla_Schutz_W_Gsp_AttributeGroupAdapter() {
		if (fla_Schutz_W_Gsp_AttributeGroupItemProvider == null) {
			fla_Schutz_W_Gsp_AttributeGroupItemProvider = new Fla_Schutz_W_Gsp_AttributeGroupItemProvider(this);
		}

		return fla_Schutz_W_Gsp_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Flankenschutz.Fla_Schutz_Weitergabe_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fla_Schutz_Weitergabe_AttributeGroupItemProvider fla_Schutz_Weitergabe_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Flankenschutz.Fla_Schutz_Weitergabe_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFla_Schutz_Weitergabe_AttributeGroupAdapter() {
		if (fla_Schutz_Weitergabe_AttributeGroupItemProvider == null) {
			fla_Schutz_Weitergabe_AttributeGroupItemProvider = new Fla_Schutz_Weitergabe_AttributeGroupItemProvider(this);
		}

		return fla_Schutz_Weitergabe_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Flankenschutz.Fla_Signal_Zielsperrung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fla_Signal_Zielsperrung_TypeClassItemProvider fla_Signal_Zielsperrung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Flankenschutz.Fla_Signal_Zielsperrung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFla_Signal_Zielsperrung_TypeClassAdapter() {
		if (fla_Signal_Zielsperrung_TypeClassItemProvider == null) {
			fla_Signal_Zielsperrung_TypeClassItemProvider = new Fla_Signal_Zielsperrung_TypeClassItemProvider(this);
		}

		return fla_Signal_Zielsperrung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Flankenschutz.Fla_Verzicht_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fla_Verzicht_TypeClassItemProvider fla_Verzicht_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Flankenschutz.Fla_Verzicht_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFla_Verzicht_TypeClassAdapter() {
		if (fla_Verzicht_TypeClassItemProvider == null) {
			fla_Verzicht_TypeClassItemProvider = new Fla_Verzicht_TypeClassItemProvider(this);
		}

		return fla_Verzicht_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Flankenschutz.Fla_W_Lage_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fla_W_Lage_TypeClassItemProvider fla_W_Lage_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Flankenschutz.Fla_W_Lage_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFla_W_Lage_TypeClassAdapter() {
		if (fla_W_Lage_TypeClassItemProvider == null) {
			fla_W_Lage_TypeClassItemProvider = new Fla_W_Lage_TypeClassItemProvider(this);
		}

		return fla_W_Lage_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Flankenschutz.Fla_Zwieschutz} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fla_ZwieschutzItemProvider fla_ZwieschutzItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Flankenschutz.Fla_Zwieschutz}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFla_ZwieschutzAdapter() {
		if (fla_ZwieschutzItemProvider == null) {
			fla_ZwieschutzItemProvider = new Fla_ZwieschutzItemProvider(this);
		}

		return fla_ZwieschutzItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Flankenschutz.Fla_Zwieschutz_Element_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fla_Zwieschutz_Element_AttributeGroupItemProvider fla_Zwieschutz_Element_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Flankenschutz.Fla_Zwieschutz_Element_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFla_Zwieschutz_Element_AttributeGroupAdapter() {
		if (fla_Zwieschutz_Element_AttributeGroupItemProvider == null) {
			fla_Zwieschutz_Element_AttributeGroupItemProvider = new Fla_Zwieschutz_Element_AttributeGroupItemProvider(this);
		}

		return fla_Zwieschutz_Element_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Flankenschutz.Massnahme_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Massnahme_TypeClassItemProvider massnahme_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Flankenschutz.Massnahme_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMassnahme_TypeClassAdapter() {
		if (massnahme_TypeClassItemProvider == null) {
			massnahme_TypeClassItemProvider = new Massnahme_TypeClassItemProvider(this);
		}

		return massnahme_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Flankenschutz.Nachlaufverhinderung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Nachlaufverhinderung_TypeClassItemProvider nachlaufverhinderung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Flankenschutz.Nachlaufverhinderung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNachlaufverhinderung_TypeClassAdapter() {
		if (nachlaufverhinderung_TypeClassItemProvider == null) {
			nachlaufverhinderung_TypeClassItemProvider = new Nachlaufverhinderung_TypeClassItemProvider(this);
		}

		return nachlaufverhinderung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Flankenschutz.Zwieschutz_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Zwieschutz_Art_TypeClassItemProvider zwieschutz_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Flankenschutz.Zwieschutz_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZwieschutz_Art_TypeClassAdapter() {
		if (zwieschutz_Art_TypeClassItemProvider == null) {
			zwieschutz_Art_TypeClassItemProvider = new Zwieschutz_Art_TypeClassItemProvider(this);
		}

		return zwieschutz_Art_TypeClassItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (fahrt_Ueber_TypeClassItemProvider != null) fahrt_Ueber_TypeClassItemProvider.dispose();
		if (fla_Freimelde_ZuordnungItemProvider != null) fla_Freimelde_ZuordnungItemProvider.dispose();
		if (fla_Raum_Freimeldung_TypeClassItemProvider != null) fla_Raum_Freimeldung_TypeClassItemProvider.dispose();
		if (fla_SchutzItemProvider != null) fla_SchutzItemProvider.dispose();
		if (fla_Schutz_Anforderer_AttributeGroupItemProvider != null) fla_Schutz_Anforderer_AttributeGroupItemProvider.dispose();
		if (fla_Schutz_Signal_AttributeGroupItemProvider != null) fla_Schutz_Signal_AttributeGroupItemProvider.dispose();
		if (fla_Schutz_W_Gsp_AttributeGroupItemProvider != null) fla_Schutz_W_Gsp_AttributeGroupItemProvider.dispose();
		if (fla_Schutz_Weitergabe_AttributeGroupItemProvider != null) fla_Schutz_Weitergabe_AttributeGroupItemProvider.dispose();
		if (fla_Signal_Zielsperrung_TypeClassItemProvider != null) fla_Signal_Zielsperrung_TypeClassItemProvider.dispose();
		if (fla_Verzicht_TypeClassItemProvider != null) fla_Verzicht_TypeClassItemProvider.dispose();
		if (fla_W_Lage_TypeClassItemProvider != null) fla_W_Lage_TypeClassItemProvider.dispose();
		if (fla_ZwieschutzItemProvider != null) fla_ZwieschutzItemProvider.dispose();
		if (fla_Zwieschutz_Element_AttributeGroupItemProvider != null) fla_Zwieschutz_Element_AttributeGroupItemProvider.dispose();
		if (massnahme_TypeClassItemProvider != null) massnahme_TypeClassItemProvider.dispose();
		if (nachlaufverhinderung_TypeClassItemProvider != null) nachlaufverhinderung_TypeClassItemProvider.dispose();
		if (zwieschutz_Art_TypeClassItemProvider != null) zwieschutz_Art_TypeClassItemProvider.dispose();
	}

}
