/**
 * Copyright (c) 2022 DB Netz AG and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 */
package org.eclipse.set.toolboxmodel.Bedienung.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.set.toolboxmodel.Bedienung.util.BedienungAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class BedienungItemProviderAdapterFactory extends BedienungAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BedienungItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.A_Wert_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected A_Wert_TypeClassItemProvider a_Wert_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.A_Wert_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createA_Wert_TypeClassAdapter() {
		if (a_Wert_TypeClassItemProvider == null) {
			a_Wert_TypeClassItemProvider = new A_Wert_TypeClassItemProvider(this);
		}

		return a_Wert_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Anbindung_IB2_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Anbindung_IB2_TypeClassItemProvider anbindung_IB2_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Anbindung_IB2_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAnbindung_IB2_TypeClassAdapter() {
		if (anbindung_IB2_TypeClassItemProvider == null) {
			anbindung_IB2_TypeClassItemProvider = new Anbindung_IB2_TypeClassItemProvider(this);
		}

		return anbindung_IB2_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Anbindung_IB3_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Anbindung_IB3_TypeClassItemProvider anbindung_IB3_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Anbindung_IB3_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAnbindung_IB3_TypeClassAdapter() {
		if (anbindung_IB3_TypeClassItemProvider == null) {
			anbindung_IB3_TypeClassItemProvider = new Anbindung_IB3_TypeClassItemProvider(this);
		}

		return anbindung_IB3_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.B_Wert_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected B_Wert_TypeClassItemProvider b_Wert_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.B_Wert_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createB_Wert_TypeClassAdapter() {
		if (b_Wert_TypeClassItemProvider == null) {
			b_Wert_TypeClassItemProvider = new B_Wert_TypeClassItemProvider(this);
		}

		return b_Wert_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Anrueckabschnitt} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedien_AnrueckabschnittItemProvider bedien_AnrueckabschnittItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Anrueckabschnitt}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedien_AnrueckabschnittAdapter() {
		if (bedien_AnrueckabschnittItemProvider == null) {
			bedien_AnrueckabschnittItemProvider = new Bedien_AnrueckabschnittItemProvider(this);
		}

		return bedien_AnrueckabschnittItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Anrueckabschnitt_Bezeichnung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedien_Anrueckabschnitt_Bezeichnung_AttributeGroupItemProvider bedien_Anrueckabschnitt_Bezeichnung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Anrueckabschnitt_Bezeichnung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedien_Anrueckabschnitt_Bezeichnung_AttributeGroupAdapter() {
		if (bedien_Anrueckabschnitt_Bezeichnung_AttributeGroupItemProvider == null) {
			bedien_Anrueckabschnitt_Bezeichnung_AttributeGroupItemProvider = new Bedien_Anrueckabschnitt_Bezeichnung_AttributeGroupItemProvider(this);
		}

		return bedien_Anrueckabschnitt_Bezeichnung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Anzeige_Element} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedien_Anzeige_ElementItemProvider bedien_Anzeige_ElementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Anzeige_Element}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedien_Anzeige_ElementAdapter() {
		if (bedien_Anzeige_ElementItemProvider == null) {
			bedien_Anzeige_ElementItemProvider = new Bedien_Anzeige_ElementItemProvider(this);
		}

		return bedien_Anzeige_ElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Anzeige_Element_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedien_Anzeige_Element_Allg_AttributeGroupItemProvider bedien_Anzeige_Element_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Anzeige_Element_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedien_Anzeige_Element_Allg_AttributeGroupAdapter() {
		if (bedien_Anzeige_Element_Allg_AttributeGroupItemProvider == null) {
			bedien_Anzeige_Element_Allg_AttributeGroupItemProvider = new Bedien_Anzeige_Element_Allg_AttributeGroupItemProvider(this);
		}

		return bedien_Anzeige_Element_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Anzeige_Element_Bezeichnung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedien_Anzeige_Element_Bezeichnung_AttributeGroupItemProvider bedien_Anzeige_Element_Bezeichnung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Anzeige_Element_Bezeichnung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedien_Anzeige_Element_Bezeichnung_AttributeGroupAdapter() {
		if (bedien_Anzeige_Element_Bezeichnung_AttributeGroupItemProvider == null) {
			bedien_Anzeige_Element_Bezeichnung_AttributeGroupItemProvider = new Bedien_Anzeige_Element_Bezeichnung_AttributeGroupItemProvider(this);
		}

		return bedien_Anzeige_Element_Bezeichnung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Bezirk} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedien_BezirkItemProvider bedien_BezirkItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Bezirk}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedien_BezirkAdapter() {
		if (bedien_BezirkItemProvider == null) {
			bedien_BezirkItemProvider = new Bedien_BezirkItemProvider(this);
		}

		return bedien_BezirkItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Bezirk_Adressformel_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedien_Bezirk_Adressformel_AttributeGroupItemProvider bedien_Bezirk_Adressformel_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Bezirk_Adressformel_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedien_Bezirk_Adressformel_AttributeGroupAdapter() {
		if (bedien_Bezirk_Adressformel_AttributeGroupItemProvider == null) {
			bedien_Bezirk_Adressformel_AttributeGroupItemProvider = new Bedien_Bezirk_Adressformel_AttributeGroupItemProvider(this);
		}

		return bedien_Bezirk_Adressformel_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Bezirk_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedien_Bezirk_Allg_AttributeGroupItemProvider bedien_Bezirk_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Bezirk_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedien_Bezirk_Allg_AttributeGroupAdapter() {
		if (bedien_Bezirk_Allg_AttributeGroupItemProvider == null) {
			bedien_Bezirk_Allg_AttributeGroupItemProvider = new Bedien_Bezirk_Allg_AttributeGroupItemProvider(this);
		}

		return bedien_Bezirk_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Bezirk_Anhaenge_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedien_Bezirk_Anhaenge_AttributeGroupItemProvider bedien_Bezirk_Anhaenge_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Bezirk_Anhaenge_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedien_Bezirk_Anhaenge_AttributeGroupAdapter() {
		if (bedien_Bezirk_Anhaenge_AttributeGroupItemProvider == null) {
			bedien_Bezirk_Anhaenge_AttributeGroupItemProvider = new Bedien_Bezirk_Anhaenge_AttributeGroupItemProvider(this);
		}

		return bedien_Bezirk_Anhaenge_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Einricht_Bauart_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedien_Einricht_Bauart_TypeClassItemProvider bedien_Einricht_Bauart_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Einricht_Bauart_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedien_Einricht_Bauart_TypeClassAdapter() {
		if (bedien_Einricht_Bauart_TypeClassItemProvider == null) {
			bedien_Einricht_Bauart_TypeClassItemProvider = new Bedien_Einricht_Bauart_TypeClassItemProvider(this);
		}

		return bedien_Einricht_Bauart_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Einricht_Oertl_Bez_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedien_Einricht_Oertl_Bez_TypeClassItemProvider bedien_Einricht_Oertl_Bez_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Einricht_Oertl_Bez_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedien_Einricht_Oertl_Bez_TypeClassAdapter() {
		if (bedien_Einricht_Oertl_Bez_TypeClassItemProvider == null) {
			bedien_Einricht_Oertl_Bez_TypeClassItemProvider = new Bedien_Einricht_Oertl_Bez_TypeClassItemProvider(this);
		}

		return bedien_Einricht_Oertl_Bez_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Einricht_Oertlich_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedien_Einricht_Oertlich_Allg_AttributeGroupItemProvider bedien_Einricht_Oertlich_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Einricht_Oertlich_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedien_Einricht_Oertlich_Allg_AttributeGroupAdapter() {
		if (bedien_Einricht_Oertlich_Allg_AttributeGroupItemProvider == null) {
			bedien_Einricht_Oertlich_Allg_AttributeGroupItemProvider = new Bedien_Einricht_Oertlich_Allg_AttributeGroupItemProvider(this);
		}

		return bedien_Einricht_Oertlich_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Einrichtung_Oertlich} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedien_Einrichtung_OertlichItemProvider bedien_Einrichtung_OertlichItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Einrichtung_Oertlich}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedien_Einrichtung_OertlichAdapter() {
		if (bedien_Einrichtung_OertlichItemProvider == null) {
			bedien_Einrichtung_OertlichItemProvider = new Bedien_Einrichtung_OertlichItemProvider(this);
		}

		return bedien_Einrichtung_OertlichItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Einrichtung_Oertlich_Bezeichnung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedien_Einrichtung_Oertlich_Bezeichnung_AttributeGroupItemProvider bedien_Einrichtung_Oertlich_Bezeichnung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Einrichtung_Oertlich_Bezeichnung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedien_Einrichtung_Oertlich_Bezeichnung_AttributeGroupAdapter() {
		if (bedien_Einrichtung_Oertlich_Bezeichnung_AttributeGroupItemProvider == null) {
			bedien_Einrichtung_Oertlich_Bezeichnung_AttributeGroupItemProvider = new Bedien_Einrichtung_Oertlich_Bezeichnung_AttributeGroupItemProvider(this);
		}

		return bedien_Einrichtung_Oertlich_Bezeichnung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_GBT} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedien_GBTItemProvider bedien_GBTItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_GBT}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedien_GBTAdapter() {
		if (bedien_GBTItemProvider == null) {
			bedien_GBTItemProvider = new Bedien_GBTItemProvider(this);
		}

		return bedien_GBTItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_GBT_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedien_GBT_Allg_AttributeGroupItemProvider bedien_GBT_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_GBT_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedien_GBT_Allg_AttributeGroupAdapter() {
		if (bedien_GBT_Allg_AttributeGroupItemProvider == null) {
			bedien_GBT_Allg_AttributeGroupItemProvider = new Bedien_GBT_Allg_AttributeGroupItemProvider(this);
		}

		return bedien_GBT_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Oberflaeche} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedien_OberflaecheItemProvider bedien_OberflaecheItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Oberflaeche}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedien_OberflaecheAdapter() {
		if (bedien_OberflaecheItemProvider == null) {
			bedien_OberflaecheItemProvider = new Bedien_OberflaecheItemProvider(this);
		}

		return bedien_OberflaecheItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Oberflaeche_Anhaenge_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedien_Oberflaeche_Anhaenge_AttributeGroupItemProvider bedien_Oberflaeche_Anhaenge_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Oberflaeche_Anhaenge_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedien_Oberflaeche_Anhaenge_AttributeGroupAdapter() {
		if (bedien_Oberflaeche_Anhaenge_AttributeGroupItemProvider == null) {
			bedien_Oberflaeche_Anhaenge_AttributeGroupItemProvider = new Bedien_Oberflaeche_Anhaenge_AttributeGroupItemProvider(this);
		}

		return bedien_Oberflaeche_Anhaenge_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Oberflaeche_Bild} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedien_Oberflaeche_BildItemProvider bedien_Oberflaeche_BildItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Oberflaeche_Bild}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedien_Oberflaeche_BildAdapter() {
		if (bedien_Oberflaeche_BildItemProvider == null) {
			bedien_Oberflaeche_BildItemProvider = new Bedien_Oberflaeche_BildItemProvider(this);
		}

		return bedien_Oberflaeche_BildItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Oberflaeche_Bild_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedien_Oberflaeche_Bild_Allg_AttributeGroupItemProvider bedien_Oberflaeche_Bild_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Oberflaeche_Bild_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedien_Oberflaeche_Bild_Allg_AttributeGroupAdapter() {
		if (bedien_Oberflaeche_Bild_Allg_AttributeGroupItemProvider == null) {
			bedien_Oberflaeche_Bild_Allg_AttributeGroupItemProvider = new Bedien_Oberflaeche_Bild_Allg_AttributeGroupItemProvider(this);
		}

		return bedien_Oberflaeche_Bild_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Oertlichkeit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedien_OertlichkeitItemProvider bedien_OertlichkeitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Oertlichkeit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedien_OertlichkeitAdapter() {
		if (bedien_OertlichkeitItemProvider == null) {
			bedien_OertlichkeitItemProvider = new Bedien_OertlichkeitItemProvider(this);
		}

		return bedien_OertlichkeitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Oertlichkeit_Kennzahlen_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedien_Oertlichkeit_Kennzahlen_AttributeGroupItemProvider bedien_Oertlichkeit_Kennzahlen_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Oertlichkeit_Kennzahlen_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedien_Oertlichkeit_Kennzahlen_AttributeGroupAdapter() {
		if (bedien_Oertlichkeit_Kennzahlen_AttributeGroupItemProvider == null) {
			bedien_Oertlichkeit_Kennzahlen_AttributeGroupItemProvider = new Bedien_Oertlichkeit_Kennzahlen_AttributeGroupItemProvider(this);
		}

		return bedien_Oertlichkeit_Kennzahlen_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Platz} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedien_PlatzItemProvider bedien_PlatzItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Platz}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedien_PlatzAdapter() {
		if (bedien_PlatzItemProvider == null) {
			bedien_PlatzItemProvider = new Bedien_PlatzItemProvider(this);
		}

		return bedien_PlatzItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Platz_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedien_Platz_Allg_AttributeGroupItemProvider bedien_Platz_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Platz_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedien_Platz_Allg_AttributeGroupAdapter() {
		if (bedien_Platz_Allg_AttributeGroupItemProvider == null) {
			bedien_Platz_Allg_AttributeGroupItemProvider = new Bedien_Platz_Allg_AttributeGroupItemProvider(this);
		}

		return bedien_Platz_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Platz_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedien_Platz_Art_TypeClassItemProvider bedien_Platz_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Platz_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedien_Platz_Art_TypeClassAdapter() {
		if (bedien_Platz_Art_TypeClassItemProvider == null) {
			bedien_Platz_Art_TypeClassItemProvider = new Bedien_Platz_Art_TypeClassItemProvider(this);
		}

		return bedien_Platz_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Standort} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedien_StandortItemProvider bedien_StandortItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Standort}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedien_StandortAdapter() {
		if (bedien_StandortItemProvider == null) {
			bedien_StandortItemProvider = new Bedien_StandortItemProvider(this);
		}

		return bedien_StandortItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Standort_Bezeichnung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedien_Standort_Bezeichnung_AttributeGroupItemProvider bedien_Standort_Bezeichnung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Standort_Bezeichnung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedien_Standort_Bezeichnung_AttributeGroupAdapter() {
		if (bedien_Standort_Bezeichnung_AttributeGroupItemProvider == null) {
			bedien_Standort_Bezeichnung_AttributeGroupItemProvider = new Bedien_Standort_Bezeichnung_AttributeGroupItemProvider(this);
		}

		return bedien_Standort_Bezeichnung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Zentrale} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedien_ZentraleItemProvider bedien_ZentraleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Zentrale}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedien_ZentraleAdapter() {
		if (bedien_ZentraleItemProvider == null) {
			bedien_ZentraleItemProvider = new Bedien_ZentraleItemProvider(this);
		}

		return bedien_ZentraleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Zentrale_Bezeichnung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedien_Zentrale_Bezeichnung_AttributeGroupItemProvider bedien_Zentrale_Bezeichnung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bedien_Zentrale_Bezeichnung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedien_Zentrale_Bezeichnung_AttributeGroupAdapter() {
		if (bedien_Zentrale_Bezeichnung_AttributeGroupItemProvider == null) {
			bedien_Zentrale_Bezeichnung_AttributeGroupItemProvider = new Bedien_Zentrale_Bezeichnung_AttributeGroupItemProvider(this);
		}

		return bedien_Zentrale_Bezeichnung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bedienplatzbezeichnung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedienplatzbezeichnung_TypeClassItemProvider bedienplatzbezeichnung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bedienplatzbezeichnung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedienplatzbezeichnung_TypeClassAdapter() {
		if (bedienplatzbezeichnung_TypeClassItemProvider == null) {
			bedienplatzbezeichnung_TypeClassItemProvider = new Bedienplatzbezeichnung_TypeClassItemProvider(this);
		}

		return bedienplatzbezeichnung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bedienplatznummer_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedienplatznummer_TypeClassItemProvider bedienplatznummer_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bedienplatznummer_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedienplatznummer_TypeClassAdapter() {
		if (bedienplatznummer_TypeClassItemProvider == null) {
			bedienplatznummer_TypeClassItemProvider = new Bedienplatznummer_TypeClassItemProvider(this);
		}

		return bedienplatznummer_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bedienraumnummer_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedienraumnummer_TypeClassItemProvider bedienraumnummer_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bedienraumnummer_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedienraumnummer_TypeClassAdapter() {
		if (bedienraumnummer_TypeClassItemProvider == null) {
			bedienraumnummer_TypeClassItemProvider = new Bedienraumnummer_TypeClassItemProvider(this);
		}

		return bedienraumnummer_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Betriebsstellenbezeichner_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Betriebsstellenbezeichner_TypeClassItemProvider betriebsstellenbezeichner_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Betriebsstellenbezeichner_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBetriebsstellenbezeichner_TypeClassAdapter() {
		if (betriebsstellenbezeichner_TypeClassItemProvider == null) {
			betriebsstellenbezeichner_TypeClassItemProvider = new Betriebsstellenbezeichner_TypeClassItemProvider(this);
		}

		return betriebsstellenbezeichner_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bez_Bed_Anrueckabschnitt_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bez_Bed_Anrueckabschnitt_TypeClassItemProvider bez_Bed_Anrueckabschnitt_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bez_Bed_Anrueckabschnitt_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBez_Bed_Anrueckabschnitt_TypeClassAdapter() {
		if (bez_Bed_Anrueckabschnitt_TypeClassItemProvider == null) {
			bez_Bed_Anrueckabschnitt_TypeClassItemProvider = new Bez_Bed_Anrueckabschnitt_TypeClassItemProvider(this);
		}

		return bez_Bed_Anrueckabschnitt_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bez_Bed_Anzeige_Element_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bez_Bed_Anzeige_Element_TypeClassItemProvider bez_Bed_Anzeige_Element_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bez_Bed_Anzeige_Element_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBez_Bed_Anzeige_Element_TypeClassAdapter() {
		if (bez_Bed_Anzeige_Element_TypeClassItemProvider == null) {
			bez_Bed_Anzeige_Element_TypeClassItemProvider = new Bez_Bed_Anzeige_Element_TypeClassItemProvider(this);
		}

		return bez_Bed_Anzeige_Element_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bez_Bed_Zentrale_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bez_Bed_Zentrale_TypeClassItemProvider bez_Bed_Zentrale_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bez_Bed_Zentrale_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBez_Bed_Zentrale_TypeClassAdapter() {
		if (bez_Bed_Zentrale_TypeClassItemProvider == null) {
			bez_Bed_Zentrale_TypeClassItemProvider = new Bez_Bed_Zentrale_TypeClassItemProvider(this);
		}

		return bez_Bed_Zentrale_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Bezeichnung_BSO_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bezeichnung_BSO_TypeClassItemProvider bezeichnung_BSO_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Bezeichnung_BSO_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBezeichnung_BSO_TypeClassAdapter() {
		if (bezeichnung_BSO_TypeClassItemProvider == null) {
			bezeichnung_BSO_TypeClassItemProvider = new Bezeichnung_BSO_TypeClassItemProvider(this);
		}

		return bezeichnung_BSO_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.BSO_IP_AB_Teilsystem_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BSO_IP_AB_Teilsystem_AttributeGroupItemProvider bsO_IP_AB_Teilsystem_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.BSO_IP_AB_Teilsystem_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBSO_IP_AB_Teilsystem_AttributeGroupAdapter() {
		if (bsO_IP_AB_Teilsystem_AttributeGroupItemProvider == null) {
			bsO_IP_AB_Teilsystem_AttributeGroupItemProvider = new BSO_IP_AB_Teilsystem_AttributeGroupItemProvider(this);
		}

		return bsO_IP_AB_Teilsystem_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.BSO_IP_Adressblock_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BSO_IP_Adressblock_AttributeGroupItemProvider bsO_IP_Adressblock_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.BSO_IP_Adressblock_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBSO_IP_Adressblock_AttributeGroupAdapter() {
		if (bsO_IP_Adressblock_AttributeGroupItemProvider == null) {
			bsO_IP_Adressblock_AttributeGroupItemProvider = new BSO_IP_Adressblock_AttributeGroupItemProvider(this);
		}

		return bsO_IP_Adressblock_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.BSO_Teilsystem_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BSO_Teilsystem_Art_TypeClassItemProvider bsO_Teilsystem_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.BSO_Teilsystem_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBSO_Teilsystem_Art_TypeClassAdapter() {
		if (bsO_Teilsystem_Art_TypeClassItemProvider == null) {
			bsO_Teilsystem_Art_TypeClassItemProvider = new BSO_Teilsystem_Art_TypeClassItemProvider(this);
		}

		return bsO_Teilsystem_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.C_Wert_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected C_Wert_TypeClassItemProvider c_Wert_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.C_Wert_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createC_Wert_TypeClassAdapter() {
		if (c_Wert_TypeClassItemProvider == null) {
			c_Wert_TypeClassItemProvider = new C_Wert_TypeClassItemProvider(this);
		}

		return c_Wert_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.DD_Wert_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DD_Wert_TypeClassItemProvider dD_Wert_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.DD_Wert_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDD_Wert_TypeClassAdapter() {
		if (dD_Wert_TypeClassItemProvider == null) {
			dD_Wert_TypeClassItemProvider = new DD_Wert_TypeClassItemProvider(this);
		}

		return dD_Wert_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Hersteller_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Hersteller_TypeClassItemProvider hersteller_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Hersteller_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHersteller_TypeClassAdapter() {
		if (hersteller_TypeClassItemProvider == null) {
			hersteller_TypeClassItemProvider = new Hersteller_TypeClassItemProvider(this);
		}

		return hersteller_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Hupe_Anschaltzeit_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Hupe_Anschaltzeit_TypeClassItemProvider hupe_Anschaltzeit_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Hupe_Anschaltzeit_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHupe_Anschaltzeit_TypeClassAdapter() {
		if (hupe_Anschaltzeit_TypeClassItemProvider == null) {
			hupe_Anschaltzeit_TypeClassItemProvider = new Hupe_Anschaltzeit_TypeClassItemProvider(this);
		}

		return hupe_Anschaltzeit_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.IP_Adressblock_Blau_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IP_Adressblock_Blau_TypeClassItemProvider iP_Adressblock_Blau_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.IP_Adressblock_Blau_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIP_Adressblock_Blau_TypeClassAdapter() {
		if (iP_Adressblock_Blau_TypeClassItemProvider == null) {
			iP_Adressblock_Blau_TypeClassItemProvider = new IP_Adressblock_Blau_TypeClassItemProvider(this);
		}

		return iP_Adressblock_Blau_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.IP_Adressblock_Blau_V4_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IP_Adressblock_Blau_V4_TypeClassItemProvider iP_Adressblock_Blau_V4_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.IP_Adressblock_Blau_V4_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIP_Adressblock_Blau_V4_TypeClassAdapter() {
		if (iP_Adressblock_Blau_V4_TypeClassItemProvider == null) {
			iP_Adressblock_Blau_V4_TypeClassItemProvider = new IP_Adressblock_Blau_V4_TypeClassItemProvider(this);
		}

		return iP_Adressblock_Blau_V4_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.IP_Adressblock_Blau_V6_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IP_Adressblock_Blau_V6_TypeClassItemProvider iP_Adressblock_Blau_V6_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.IP_Adressblock_Blau_V6_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIP_Adressblock_Blau_V6_TypeClassAdapter() {
		if (iP_Adressblock_Blau_V6_TypeClassItemProvider == null) {
			iP_Adressblock_Blau_V6_TypeClassItemProvider = new IP_Adressblock_Blau_V6_TypeClassItemProvider(this);
		}

		return iP_Adressblock_Blau_V6_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.IP_Adressblock_Grau_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IP_Adressblock_Grau_TypeClassItemProvider iP_Adressblock_Grau_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.IP_Adressblock_Grau_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIP_Adressblock_Grau_TypeClassAdapter() {
		if (iP_Adressblock_Grau_TypeClassItemProvider == null) {
			iP_Adressblock_Grau_TypeClassItemProvider = new IP_Adressblock_Grau_TypeClassItemProvider(this);
		}

		return iP_Adressblock_Grau_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.IP_Adressblock_Grau_V4_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IP_Adressblock_Grau_V4_TypeClassItemProvider iP_Adressblock_Grau_V4_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.IP_Adressblock_Grau_V4_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIP_Adressblock_Grau_V4_TypeClassAdapter() {
		if (iP_Adressblock_Grau_V4_TypeClassItemProvider == null) {
			iP_Adressblock_Grau_V4_TypeClassItemProvider = new IP_Adressblock_Grau_V4_TypeClassItemProvider(this);
		}

		return iP_Adressblock_Grau_V4_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.IP_Adressblock_Grau_V6_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IP_Adressblock_Grau_V6_TypeClassItemProvider iP_Adressblock_Grau_V6_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.IP_Adressblock_Grau_V6_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIP_Adressblock_Grau_V6_TypeClassAdapter() {
		if (iP_Adressblock_Grau_V6_TypeClassItemProvider == null) {
			iP_Adressblock_Grau_V6_TypeClassItemProvider = new IP_Adressblock_Grau_V6_TypeClassItemProvider(this);
		}

		return iP_Adressblock_Grau_V6_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Kennzahl_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Kennzahl_TypeClassItemProvider kennzahl_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Kennzahl_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createKennzahl_TypeClassAdapter() {
		if (kennzahl_TypeClassItemProvider == null) {
			kennzahl_TypeClassItemProvider = new Kennzahl_TypeClassItemProvider(this);
		}

		return kennzahl_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Melder_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Melder_TypeClassItemProvider melder_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Melder_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMelder_TypeClassAdapter() {
		if (melder_TypeClassItemProvider == null) {
			melder_TypeClassItemProvider = new Melder_TypeClassItemProvider(this);
		}

		return melder_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Oberflaeche_Bildart_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Oberflaeche_Bildart_TypeClassItemProvider oberflaeche_Bildart_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Oberflaeche_Bildart_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOberflaeche_Bildart_TypeClassAdapter() {
		if (oberflaeche_Bildart_TypeClassItemProvider == null) {
			oberflaeche_Bildart_TypeClassItemProvider = new Oberflaeche_Bildart_TypeClassItemProvider(this);
		}

		return oberflaeche_Bildart_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Oberflaeche_Zustaendigkeit_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Oberflaeche_Zustaendigkeit_TypeClassItemProvider oberflaeche_Zustaendigkeit_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Oberflaeche_Zustaendigkeit_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOberflaeche_Zustaendigkeit_TypeClassAdapter() {
		if (oberflaeche_Zustaendigkeit_TypeClassItemProvider == null) {
			oberflaeche_Zustaendigkeit_TypeClassItemProvider = new Oberflaeche_Zustaendigkeit_TypeClassItemProvider(this);
		}

		return oberflaeche_Zustaendigkeit_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Regionalbereich_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Regionalbereich_TypeClassItemProvider regionalbereich_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Regionalbereich_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRegionalbereich_TypeClassAdapter() {
		if (regionalbereich_TypeClassItemProvider == null) {
			regionalbereich_TypeClassItemProvider = new Regionalbereich_TypeClassItemProvider(this);
		}

		return regionalbereich_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Rueckschauzeit_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Rueckschauzeit_TypeClassItemProvider rueckschauzeit_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Rueckschauzeit_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRueckschauzeit_TypeClassAdapter() {
		if (rueckschauzeit_TypeClassItemProvider == null) {
			rueckschauzeit_TypeClassItemProvider = new Rueckschauzeit_TypeClassItemProvider(this);
		}

		return rueckschauzeit_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Schalter_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Schalter_TypeClassItemProvider schalter_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Schalter_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSchalter_TypeClassAdapter() {
		if (schalter_TypeClassItemProvider == null) {
			schalter_TypeClassItemProvider = new Schalter_TypeClassItemProvider(this);
		}

		return schalter_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Schrankreihe_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Schrankreihe_TypeClassItemProvider schrankreihe_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Schrankreihe_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSchrankreihe_TypeClassAdapter() {
		if (schrankreihe_TypeClassItemProvider == null) {
			schrankreihe_TypeClassItemProvider = new Schrankreihe_TypeClassItemProvider(this);
		}

		return schrankreihe_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Steuerbezirksname_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Steuerbezirksname_TypeClassItemProvider steuerbezirksname_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Steuerbezirksname_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSteuerbezirksname_TypeClassAdapter() {
		if (steuerbezirksname_TypeClassItemProvider == null) {
			steuerbezirksname_TypeClassItemProvider = new Steuerbezirksname_TypeClassItemProvider(this);
		}

		return steuerbezirksname_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Steuerbezirksnummer_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Steuerbezirksnummer_TypeClassItemProvider steuerbezirksnummer_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Steuerbezirksnummer_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSteuerbezirksnummer_TypeClassAdapter() {
		if (steuerbezirksnummer_TypeClassItemProvider == null) {
			steuerbezirksnummer_TypeClassItemProvider = new Steuerbezirksnummer_TypeClassItemProvider(this);
		}

		return steuerbezirksnummer_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Taste_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Taste_TypeClassItemProvider taste_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Taste_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTaste_TypeClassAdapter() {
		if (taste_TypeClassItemProvider == null) {
			taste_TypeClassItemProvider = new Taste_TypeClassItemProvider(this);
		}

		return taste_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Vorschauzeit_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Vorschauzeit_TypeClassItemProvider vorschauzeit_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Vorschauzeit_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVorschauzeit_TypeClassAdapter() {
		if (vorschauzeit_TypeClassItemProvider == null) {
			vorschauzeit_TypeClassItemProvider = new Vorschauzeit_TypeClassItemProvider(this);
		}

		return vorschauzeit_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.X_Wert_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected X_Wert_TypeClassItemProvider x_Wert_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.X_Wert_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createX_Wert_TypeClassAdapter() {
		if (x_Wert_TypeClassItemProvider == null) {
			x_Wert_TypeClassItemProvider = new X_Wert_TypeClassItemProvider(this);
		}

		return x_Wert_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.Y_Wert_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Y_Wert_TypeClassItemProvider y_Wert_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.Y_Wert_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createY_Wert_TypeClassAdapter() {
		if (y_Wert_TypeClassItemProvider == null) {
			y_Wert_TypeClassItemProvider = new Y_Wert_TypeClassItemProvider(this);
		}

		return y_Wert_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bedienung.YY_Wert_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected YY_Wert_TypeClassItemProvider yY_Wert_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bedienung.YY_Wert_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createYY_Wert_TypeClassAdapter() {
		if (yY_Wert_TypeClassItemProvider == null) {
			yY_Wert_TypeClassItemProvider = new YY_Wert_TypeClassItemProvider(this);
		}

		return yY_Wert_TypeClassItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (a_Wert_TypeClassItemProvider != null) a_Wert_TypeClassItemProvider.dispose();
		if (anbindung_IB2_TypeClassItemProvider != null) anbindung_IB2_TypeClassItemProvider.dispose();
		if (anbindung_IB3_TypeClassItemProvider != null) anbindung_IB3_TypeClassItemProvider.dispose();
		if (b_Wert_TypeClassItemProvider != null) b_Wert_TypeClassItemProvider.dispose();
		if (bedien_AnrueckabschnittItemProvider != null) bedien_AnrueckabschnittItemProvider.dispose();
		if (bedien_Anrueckabschnitt_Bezeichnung_AttributeGroupItemProvider != null) bedien_Anrueckabschnitt_Bezeichnung_AttributeGroupItemProvider.dispose();
		if (bedien_Anzeige_ElementItemProvider != null) bedien_Anzeige_ElementItemProvider.dispose();
		if (bedien_Anzeige_Element_Allg_AttributeGroupItemProvider != null) bedien_Anzeige_Element_Allg_AttributeGroupItemProvider.dispose();
		if (bedien_Anzeige_Element_Bezeichnung_AttributeGroupItemProvider != null) bedien_Anzeige_Element_Bezeichnung_AttributeGroupItemProvider.dispose();
		if (bedien_BezirkItemProvider != null) bedien_BezirkItemProvider.dispose();
		if (bedien_Bezirk_Adressformel_AttributeGroupItemProvider != null) bedien_Bezirk_Adressformel_AttributeGroupItemProvider.dispose();
		if (bedien_Bezirk_Allg_AttributeGroupItemProvider != null) bedien_Bezirk_Allg_AttributeGroupItemProvider.dispose();
		if (bedien_Bezirk_Anhaenge_AttributeGroupItemProvider != null) bedien_Bezirk_Anhaenge_AttributeGroupItemProvider.dispose();
		if (bedien_Einricht_Bauart_TypeClassItemProvider != null) bedien_Einricht_Bauart_TypeClassItemProvider.dispose();
		if (bedien_Einricht_Oertl_Bez_TypeClassItemProvider != null) bedien_Einricht_Oertl_Bez_TypeClassItemProvider.dispose();
		if (bedien_Einricht_Oertlich_Allg_AttributeGroupItemProvider != null) bedien_Einricht_Oertlich_Allg_AttributeGroupItemProvider.dispose();
		if (bedien_Einrichtung_OertlichItemProvider != null) bedien_Einrichtung_OertlichItemProvider.dispose();
		if (bedien_Einrichtung_Oertlich_Bezeichnung_AttributeGroupItemProvider != null) bedien_Einrichtung_Oertlich_Bezeichnung_AttributeGroupItemProvider.dispose();
		if (bedien_GBTItemProvider != null) bedien_GBTItemProvider.dispose();
		if (bedien_GBT_Allg_AttributeGroupItemProvider != null) bedien_GBT_Allg_AttributeGroupItemProvider.dispose();
		if (bedien_OberflaecheItemProvider != null) bedien_OberflaecheItemProvider.dispose();
		if (bedien_Oberflaeche_Anhaenge_AttributeGroupItemProvider != null) bedien_Oberflaeche_Anhaenge_AttributeGroupItemProvider.dispose();
		if (bedien_Oberflaeche_BildItemProvider != null) bedien_Oberflaeche_BildItemProvider.dispose();
		if (bedien_Oberflaeche_Bild_Allg_AttributeGroupItemProvider != null) bedien_Oberflaeche_Bild_Allg_AttributeGroupItemProvider.dispose();
		if (bedien_OertlichkeitItemProvider != null) bedien_OertlichkeitItemProvider.dispose();
		if (bedien_Oertlichkeit_Kennzahlen_AttributeGroupItemProvider != null) bedien_Oertlichkeit_Kennzahlen_AttributeGroupItemProvider.dispose();
		if (bedien_PlatzItemProvider != null) bedien_PlatzItemProvider.dispose();
		if (bedien_Platz_Allg_AttributeGroupItemProvider != null) bedien_Platz_Allg_AttributeGroupItemProvider.dispose();
		if (bedien_Platz_Art_TypeClassItemProvider != null) bedien_Platz_Art_TypeClassItemProvider.dispose();
		if (bedien_StandortItemProvider != null) bedien_StandortItemProvider.dispose();
		if (bedien_Standort_Bezeichnung_AttributeGroupItemProvider != null) bedien_Standort_Bezeichnung_AttributeGroupItemProvider.dispose();
		if (bedien_ZentraleItemProvider != null) bedien_ZentraleItemProvider.dispose();
		if (bedien_Zentrale_Bezeichnung_AttributeGroupItemProvider != null) bedien_Zentrale_Bezeichnung_AttributeGroupItemProvider.dispose();
		if (bedienplatzbezeichnung_TypeClassItemProvider != null) bedienplatzbezeichnung_TypeClassItemProvider.dispose();
		if (bedienplatznummer_TypeClassItemProvider != null) bedienplatznummer_TypeClassItemProvider.dispose();
		if (bedienraumnummer_TypeClassItemProvider != null) bedienraumnummer_TypeClassItemProvider.dispose();
		if (betriebsstellenbezeichner_TypeClassItemProvider != null) betriebsstellenbezeichner_TypeClassItemProvider.dispose();
		if (bez_Bed_Anrueckabschnitt_TypeClassItemProvider != null) bez_Bed_Anrueckabschnitt_TypeClassItemProvider.dispose();
		if (bez_Bed_Anzeige_Element_TypeClassItemProvider != null) bez_Bed_Anzeige_Element_TypeClassItemProvider.dispose();
		if (bez_Bed_Zentrale_TypeClassItemProvider != null) bez_Bed_Zentrale_TypeClassItemProvider.dispose();
		if (bezeichnung_BSO_TypeClassItemProvider != null) bezeichnung_BSO_TypeClassItemProvider.dispose();
		if (bsO_IP_AB_Teilsystem_AttributeGroupItemProvider != null) bsO_IP_AB_Teilsystem_AttributeGroupItemProvider.dispose();
		if (bsO_IP_Adressblock_AttributeGroupItemProvider != null) bsO_IP_Adressblock_AttributeGroupItemProvider.dispose();
		if (bsO_Teilsystem_Art_TypeClassItemProvider != null) bsO_Teilsystem_Art_TypeClassItemProvider.dispose();
		if (c_Wert_TypeClassItemProvider != null) c_Wert_TypeClassItemProvider.dispose();
		if (dD_Wert_TypeClassItemProvider != null) dD_Wert_TypeClassItemProvider.dispose();
		if (hersteller_TypeClassItemProvider != null) hersteller_TypeClassItemProvider.dispose();
		if (hupe_Anschaltzeit_TypeClassItemProvider != null) hupe_Anschaltzeit_TypeClassItemProvider.dispose();
		if (iP_Adressblock_Blau_TypeClassItemProvider != null) iP_Adressblock_Blau_TypeClassItemProvider.dispose();
		if (iP_Adressblock_Blau_V4_TypeClassItemProvider != null) iP_Adressblock_Blau_V4_TypeClassItemProvider.dispose();
		if (iP_Adressblock_Blau_V6_TypeClassItemProvider != null) iP_Adressblock_Blau_V6_TypeClassItemProvider.dispose();
		if (iP_Adressblock_Grau_TypeClassItemProvider != null) iP_Adressblock_Grau_TypeClassItemProvider.dispose();
		if (iP_Adressblock_Grau_V4_TypeClassItemProvider != null) iP_Adressblock_Grau_V4_TypeClassItemProvider.dispose();
		if (iP_Adressblock_Grau_V6_TypeClassItemProvider != null) iP_Adressblock_Grau_V6_TypeClassItemProvider.dispose();
		if (kennzahl_TypeClassItemProvider != null) kennzahl_TypeClassItemProvider.dispose();
		if (melder_TypeClassItemProvider != null) melder_TypeClassItemProvider.dispose();
		if (oberflaeche_Bildart_TypeClassItemProvider != null) oberflaeche_Bildart_TypeClassItemProvider.dispose();
		if (oberflaeche_Zustaendigkeit_TypeClassItemProvider != null) oberflaeche_Zustaendigkeit_TypeClassItemProvider.dispose();
		if (regionalbereich_TypeClassItemProvider != null) regionalbereich_TypeClassItemProvider.dispose();
		if (rueckschauzeit_TypeClassItemProvider != null) rueckschauzeit_TypeClassItemProvider.dispose();
		if (schalter_TypeClassItemProvider != null) schalter_TypeClassItemProvider.dispose();
		if (schrankreihe_TypeClassItemProvider != null) schrankreihe_TypeClassItemProvider.dispose();
		if (steuerbezirksname_TypeClassItemProvider != null) steuerbezirksname_TypeClassItemProvider.dispose();
		if (steuerbezirksnummer_TypeClassItemProvider != null) steuerbezirksnummer_TypeClassItemProvider.dispose();
		if (taste_TypeClassItemProvider != null) taste_TypeClassItemProvider.dispose();
		if (vorschauzeit_TypeClassItemProvider != null) vorschauzeit_TypeClassItemProvider.dispose();
		if (x_Wert_TypeClassItemProvider != null) x_Wert_TypeClassItemProvider.dispose();
		if (y_Wert_TypeClassItemProvider != null) y_Wert_TypeClassItemProvider.dispose();
		if (yY_Wert_TypeClassItemProvider != null) yY_Wert_TypeClassItemProvider.dispose();
	}

}
