/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.browser.cef;

import java.net.HttpCookie;
import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.set.browser.cef.CEFSchemeHandlerFactory;
import org.eclipse.set.browser.cef.Chromium;
import org.eclipse.set.browser.cef.MessageLoop;
import org.eclipse.set.browser.cef.handlers.AppHandler;
import org.eclipse.set.browser.cef.handlers.CookieVisitor;
import org.eclipse.set.browser.lib.CEFLibrary;
import org.eclipse.set.browser.lib.ChromiumLib;
import org.eclipse.set.browser.lib.cef_cookie_visitor_t;
import org.eclipse.set.browser.swt.WebBrowser;
import org.eclipse.swt.widgets.Display;

public class ChromiumStatic {
    public static AtomicInteger browsers = new AtomicInteger(0);
    public static int disposingAny = 0;
    public static Map<Integer, Chromium> instances = new HashMap<Integer, Chromium>();
    public static int INSTANCES = 0;
    public static boolean shuttingDown;
    private static AppHandler app;
    private static CookieVisitor cookieVisitor;
    private static MessageLoop messageLoop;
    private static CEFSchemeHandlerFactory schemeHandlerFactory;

    static {
        messageLoop = new MessageLoop();
        schemeHandlerFactory = new CEFSchemeHandlerFactory();
    }

    public static MessageLoop getMessageLoop() {
        return messageLoop;
    }

    public static CEFSchemeHandlerFactory getSchemeHandlerFactory() {
        return schemeHandlerFactory;
    }

    public static void shutdown() {
        if (app == null) {
            return;
        }
        if (browsers.get() == 0) {
            messageLoop.shutdown();
            ChromiumLib.cefswt_shutdown();
            cookieVisitor.dispose();
            app.dispose();
            app = null;
        } else if (!shuttingDown) {
            shuttingDown = true;
        }
    }

    private static String getBrowserLocale() {
        return System.getProperty("org.eclipse.set.browser.locale", "en-US");
    }

    private static int getDebugPort() {
        try {
            return Integer.parseInt(System.getProperty("org.eclipse.set.browser.remote-debugging-port", "0"));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static String getUserAgentProduct() {
        return System.getProperty("org.eclipse.set.browser.user-agent-product", "Eclipse SET");
    }

    private static void setupCookies() {
        WebBrowser.NativeClearSessions = cef_cookie_visitor_t::cefswt_delete_cookies;
        WebBrowser.NativeSetCookie = () -> {
            List<HttpCookie> cookies = HttpCookie.parse(WebBrowser.CookieValue);
            Iterator<HttpCookie> iterator = cookies.iterator();
            if (iterator.hasNext()) {
                HttpCookie cookie = iterator.next();
                long age = cookie.getMaxAge();
                if (age != -1L) {
                    age = Instant.now().plusSeconds(age).getEpochSecond();
                }
                WebBrowser.CookieResult = cef_cookie_visitor_t.cefswt_set_cookie((String)WebBrowser.CookieUrl, (String)cookie.getName(), (String)cookie.getValue(), (String)cookie.getDomain(), (String)cookie.getPath(), (int)(cookie.getSecure() ? 1 : 0), (int)(cookie.isHttpOnly() ? 1 : 0), (double)age);
            }
        };
        WebBrowser.NativeGetCookie = () -> cookieVisitor.getCookie();
    }

    static synchronized void initCEF(Display display) {
        if (app == null) {
            CEFLibrary.loadLibraries();
            ChromiumStatic.setupCookies();
            app = new AppHandler();
            cookieVisitor = new CookieVisitor();
            ChromiumLib.cefswt_init((long)app.get(), (String)CEFLibrary.getSubprocessExePath(), (String)CEFLibrary.getCEFPath(), (String)CEFLibrary.getTempPath(), (String)ChromiumStatic.getUserAgentProduct(), (String)ChromiumStatic.getBrowserLocale(), (int)ChromiumStatic.getDebugPort());
            display.disposeExec(() -> {
                if (app == null || shuttingDown) {
                    return;
                }
                ChromiumStatic.shutdown();
            });
        }
    }
}

