/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.addons.autosuggest;

import org.eclipse.rap.addons.autosuggest.ColumnDataProvider;
import org.eclipse.rap.addons.autosuggest.ColumnTemplate;
import org.eclipse.rap.addons.autosuggest.DataProvider;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.remote.Connection;
import org.eclipse.rap.rwt.remote.RemoteObject;

public class DataSource {
    private static final String REMOTE_TYPE = "rwt.remote.Model";
    private final RemoteObject remoteObject;
    private DataProvider<Object> dataProvider;
    private ColumnTemplate template;
    private boolean isDisposed;

    public DataSource() {
        Connection connection = RWT.getUISession().getConnection();
        this.remoteObject = connection.createRemoteObject(REMOTE_TYPE);
    }

    public void setDataProvider(DataProvider<?> dataProvider) {
        this.checkDisposed();
        if (dataProvider == null) {
            throw new NullPointerException("Parameter must not be null: dataProvider");
        }
        this.dataProvider = dataProvider;
        this.setInitialData();
    }

    public void setFilterScript(String script) {
        this.checkDisposed();
        this.remoteObject.set("filterScript", script);
    }

    public void setTemplate(ColumnTemplate template) {
        this.checkDisposed();
        this.template = template;
    }

    public void dispose() {
        if (!this.isDisposed) {
            this.isDisposed = true;
            this.remoteObject.destroy();
        }
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    String getId() {
        return this.remoteObject.getId();
    }

    ColumnTemplate getTemplate() {
        return this.template;
    }

    private void checkDisposed() {
        if (this.isDisposed) {
            throw new IllegalStateException("AutoSuggest is disposed");
        }
    }

    private void setInitialData() {
        boolean hasColumns = this.dataProvider instanceof ColumnDataProvider;
        this.remoteObject.set("data", (JsonValue)(hasColumns ? this.getColumnData() : this.getStringData()));
    }

    private JsonArray getStringData() {
        JsonArray array = new JsonArray();
        for (Object element : this.dataProvider.getSuggestions()) {
            array.add(this.dataProvider.getValue(element));
        }
        return array;
    }

    private JsonArray getColumnData() {
        JsonArray array = new JsonArray();
        ColumnDataProvider columnDataProvider = (ColumnDataProvider)this.dataProvider;
        for (Object element : this.dataProvider.getSuggestions()) {
            String[] texts;
            JsonArray row = new JsonArray().add(this.dataProvider.getValue(element));
            String[] stringArray = texts = columnDataProvider.getTexts(element);
            int n = texts.length;
            int n2 = 0;
            while (n2 < n) {
                String text = stringArray[n2];
                row.add(text);
                ++n2;
            }
            array.add((JsonValue)row);
        }
        return array;
    }
}

