/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.net.Socket;
import javax.net.ssl.SSLSession;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SSLUtil;
import org.apache.tomcat.util.net.ServerSocketFactory;
import org.apache.tomcat.util.net.jsse.JSSEImplementation;

public abstract class SSLImplementation {
    private static final Log logger = LogFactory.getLog(SSLImplementation.class);
    private static final String JSSEImplementationClass = "org.apache.tomcat.util.net.jsse.JSSEImplementation";
    private static final String[] implementations = new String[]{"org.apache.tomcat.util.net.jsse.JSSEImplementation"};

    public static SSLImplementation getInstance() throws ClassNotFoundException {
        int i = 0;
        while (i < implementations.length) {
            try {
                SSLImplementation impl = SSLImplementation.getInstance(implementations[i]);
                return impl;
            }
            catch (Exception e) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Error creating " + implementations[i], e);
                }
                ++i;
            }
        }
        throw new ClassNotFoundException("Can't find any SSL implementation");
    }

    public static SSLImplementation getInstance(String className) throws ClassNotFoundException {
        if (className == null) {
            return SSLImplementation.getInstance();
        }
        try {
            if (JSSEImplementationClass.equals(className)) {
                return new JSSEImplementation();
            }
            Class<?> clazz = Class.forName(className);
            return (SSLImplementation)clazz.newInstance();
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Error loading SSL Implementation " + className, e);
            }
            throw new ClassNotFoundException("Error loading SSL Implementation " + className + " :" + e.toString());
        }
    }

    public abstract String getImplementationName();

    public abstract ServerSocketFactory getServerSocketFactory(AbstractEndpoint var1);

    public abstract SSLSupport getSSLSupport(Socket var1);

    public abstract SSLSupport getSSLSupport(SSLSession var1);

    public abstract SSLUtil getSSLUtil(AbstractEndpoint var1);
}

