/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.Contained;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Valve;
import org.apache.catalina.comet.CometEvent;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.res.StringManager;

public abstract class ValveBase
extends LifecycleMBeanBase
implements Contained,
Valve {
    protected boolean asyncSupported;
    protected Container container = null;
    protected Log containerLog = null;
    protected static final String info = "org.apache.catalina.core.ValveBase/1.0";
    protected Valve next = null;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.valves");

    public ValveBase() {
        this(false);
    }

    public ValveBase(boolean asyncSupported) {
        this.asyncSupported = asyncSupported;
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    public void setAsyncSupported(boolean asyncSupported) {
        this.asyncSupported = asyncSupported;
    }

    @Override
    public void setContainer(Container container) {
        this.container = container;
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public Valve getNext() {
        return this.next;
    }

    @Override
    public void setNext(Valve valve) {
        this.next = valve;
    }

    @Override
    public void backgroundProcess() {
    }

    @Override
    public abstract void invoke(Request var1, Response var2) throws IOException, ServletException;

    @Override
    public void event(Request request, Response response, CometEvent event) throws IOException, ServletException {
        this.getNext().event(request, response, event);
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        this.containerLog = this.getContainer().getLogger();
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append('[');
        if (this.container == null) {
            sb.append("Container is null");
        } else {
            sb.append(this.container.getName());
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public String getObjectNameKeyProperties() {
        String className;
        int period;
        StringBuilder name = new StringBuilder("type=Valve");
        Container container = this.getContainer();
        name.append(MBeanUtils.getContainerKeyProperties(container));
        int seq = 0;
        Pipeline p = container.getPipeline();
        if (p != null) {
            Valve[] valveArray = p.getValves();
            int n = valveArray.length;
            int n2 = 0;
            while (n2 < n) {
                Valve valve = valveArray[n2];
                if (valve != null) {
                    if (valve == this) break;
                    if (valve.getClass() == this.getClass()) {
                        ++seq;
                    }
                }
                ++n2;
            }
        }
        if (seq > 0) {
            name.append(",seq=");
            name.append(seq);
        }
        if ((period = (className = this.getClass().getName()).lastIndexOf(46)) >= 0) {
            className = className.substring(period + 1);
        }
        name.append(",name=");
        name.append(className);
        return name.toString();
    }

    @Override
    public String getDomainInternal() {
        return MBeanUtils.getDomain(this.getContainer());
    }
}

