/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.examples.pages;

import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.rap.examples.ExampleUtil;
import org.eclipse.rap.examples.IExamplePage;
import org.eclipse.rap.examples.Infobox;
import org.eclipse.rap.examples.pages.internal.ImageUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class ButtonExamplePage
implements IExamplePage {
    protected Image errorImage;
    protected Image warningImage;

    public void createControl(Composite parent) {
        this.createImages();
        parent.setLayout((Layout)ExampleUtil.createMainLayout((int)3, (int)30));
        this.createPushButtons(parent);
        this.createRadioAndCheckButtons(parent);
        Infobox infobox = new Infobox(parent);
        infobox.addParagraph("Use the Button widget to create push buttons, toggle buttons, checkboxes and radiobuttons.");
        infobox.addParagraph("Push and toggle buttons also support images.");
    }

    private void createImages() {
        this.errorImage = ButtonExamplePage.getDecorationImage("DEC_ERROR");
        this.warningImage = ButtonExamplePage.getDecorationImage("DEC_WARNING");
    }

    private void createPushButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)ExampleUtil.createGridLayout((int)3, (boolean)false, (boolean)true, (boolean)true));
        composite.setLayoutData((Object)ExampleUtil.createHorzFillData());
        ExampleUtil.createHeading((Composite)composite, (String)"Push and Toggle Buttons", (int)3);
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)ExampleUtil.createHorzFillData());
        button.setText("Cancel");
        Button button1 = new Button(composite, 8);
        button1.setText("Add");
        button1.setLayoutData((Object)ExampleUtil.createHorzFillData());
        Display display = parent.getDisplay();
        Image imgAdd = ImageUtil.getImage((Device)display, "add_obj.png");
        button1.setImage(imgAdd);
        Button button2 = new Button(composite, 8);
        button2.setLayoutData((Object)ExampleUtil.createHorzFillData());
        button2.setText("Delete");
        Image imgDelete = ImageUtil.getImage((Device)display, "delete_obj.png");
        button2.setImage(imgDelete);
        Button toggle1 = new Button(composite, 2);
        toggle1.setLayoutData((Object)new GridData(4, 128, true, false));
        Image imgSynced = ImageUtil.getImage((Device)display, "synced.png");
        toggle1.setImage(imgSynced);
        toggle1.setToolTipText("Keep in sync");
        final Button toggle2 = new Button(composite, 16386);
        toggle2.setLayoutData((Object)new GridData(4, 128, true, true));
        toggle2.setText("Unlocked");
        final Image imgLocked = ImageUtil.getImage((Device)display, "lockedstate.png");
        final Image imgUnlocked = ImageUtil.getImage((Device)display, "unlockedstate.png");
        toggle2.setImage(imgUnlocked);
        toggle2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = toggle2.getSelection();
                toggle2.setText(selected ? "Locked" : "Unlocked");
                toggle2.setImage(selected ? imgLocked : imgUnlocked);
            }
        });
        Button button3 = new Button(composite, 8);
        button3.setLayoutData((Object)ExampleUtil.createFillData());
        Image imageDownload = ImageUtil.getImage((Device)display, "go-bottom.png");
        button3.setImage(imageDownload);
        button3.setToolTipText("Download");
    }

    private void createRadioAndCheckButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)ExampleUtil.createGridLayout((int)2, (boolean)false, (boolean)true, (boolean)true));
        composite.setLayoutData((Object)ExampleUtil.createHorzFillData());
        ExampleUtil.createHeading((Composite)composite, (String)"Checkboxes and Radiobuttons", (int)2);
        Composite radioComp = new Composite(composite, 0);
        radioComp.setLayoutData((Object)new GridData(4, 128, true, false));
        RowLayout radioLayout = ButtonExamplePage.createRowLayout(512);
        radioComp.setLayout((Layout)radioLayout);
        Button radio1 = new Button(radioComp, 16);
        radio1.setText("Salami");
        radio1.setSelection(true);
        Button radio2 = new Button(radioComp, 16);
        radio2.setText("Funghi");
        Button radio3 = new Button(radioComp, 16);
        radio3.setText("Calzone");
        Composite checkComp = new Composite(composite, 0);
        checkComp.setLayoutData((Object)new GridData(4, 128, true, false));
        RowLayout checkLayout = ButtonExamplePage.createRowLayout(512);
        checkComp.setLayout((Layout)checkLayout);
        Button check1 = new Button(checkComp, 32);
        check1.setText("Extra Cheese");
        Button check2 = new Button(checkComp, 32);
        check2.setText("Extra Hot");
        Button check3 = new Button(checkComp, 32);
        check3.setText("King Size");
        check3.setSelection(true);
    }

    private static RowLayout createRowLayout(int style) {
        RowLayout layout = new RowLayout(style);
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginBottom = 0;
        layout.spacing = 10;
        layout.fill = true;
        layout.wrap = false;
        return layout;
    }

    private static Image getDecorationImage(String id) {
        FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
        FieldDecoration decoration = registry.getFieldDecoration(id);
        return decoration.getImage();
    }
}

