/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rap.fileupload.UploadSizeLimitExceededException;
import org.eclipse.rap.fileupload.UploadTimeLimitExceededException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.widgets.FileUploadRunnable;
import org.eclipse.swt.internal.widgets.ImageUtil;
import org.eclipse.swt.internal.widgets.LayoutUtil;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class UploadPanel
extends Composite {
    private static long KB = 1000L;
    private static long MB = 1000000L;
    private static long SEC = 1000L;
    private static long MIN = 60000L;
    private static String FILENAME_KEY = "filename";
    private final String[] fileNames;
    private Image emptyIcon;
    private Image waitingIcon;
    private Image uploadingIcon;
    private Image finishedIcon;
    private Image failedIcon;
    private final List<Label> icons;
    private final List<Label> labels;

    public UploadPanel(Composite parent, String[] fileNames) {
        super(parent, 0);
        this.fileNames = fileNames;
        this.initImages();
        this.setLayout((Layout)LayoutUtil.createGridLayout(1, 0, 5));
        this.icons = new ArrayList<Label>();
        this.labels = new ArrayList<Label>();
        this.createChildren();
    }

    private void initImages() {
        Display display = this.getDisplay();
        this.emptyIcon = ImageUtil.getImage(display, "empty.png");
        this.waitingIcon = ImageUtil.getImage(display, "waiting.png");
        this.uploadingIcon = ImageUtil.getImage(display, "uploading.png");
        this.finishedIcon = ImageUtil.getImage(display, "finished.png");
        this.failedIcon = ImageUtil.getImage(display, "failed.png");
    }

    private void createChildren() {
        String[] stringArray = this.fileNames;
        int n = this.fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            if (fileName != null) {
                Composite container = new Composite((Composite)this, 2048);
                container.setLayout((Layout)UploadPanel.createContainerLayout());
                container.setLayoutData((Object)LayoutUtil.createHorizontalFillData());
                Label icon = new Label(container, 0);
                icon.setData(FILENAME_KEY, (Object)fileName);
                icon.setImage(this.emptyIcon);
                this.icons.add(icon);
                Label name = new Label(container, 0);
                name.setData("org.eclipse.rap.rwt.markupEnabled", (Object)Boolean.TRUE);
                name.setData(FILENAME_KEY, (Object)fileName);
                name.setLayoutData((Object)LayoutUtil.createHorizontalFillData());
                name.setText(fileName);
                this.labels.add(name);
            }
            ++n2;
        }
    }

    private static GridLayout createContainerLayout() {
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 0;
        return layout;
    }

    void updateTexts(Exception exception) {
        this.updateToolTips(exception);
        this.updateLabels(exception);
        this.getParent().getParent().notifyListeners(11, new Event());
    }

    void updateIcons(FileUploadRunnable.State state) {
        for (Label icon : this.icons) {
            if (icon.isDisposed()) continue;
            icon.setImage(this.getImage(state));
        }
    }

    private void updateToolTips(Exception exception) {
        for (Label icon : this.icons) {
            if (icon.isDisposed()) continue;
            String fileName = (String)icon.getData(FILENAME_KEY);
            icon.setToolTipText(UploadPanel.getErrorToolTip(fileName, exception));
        }
    }

    private void updateLabels(Exception exception) {
        for (Label label : this.labels) {
            if (label.isDisposed()) continue;
            String fileName = (String)label.getData(FILENAME_KEY);
            label.setText(UploadPanel.prepareText(fileName, exception));
        }
    }

    private Image getImage(FileUploadRunnable.State state) {
        Image image = this.emptyIcon;
        if (state.equals((Object)FileUploadRunnable.State.WAITING)) {
            image = this.waitingIcon;
        } else if (state.equals((Object)FileUploadRunnable.State.UPLOADING)) {
            image = this.uploadingIcon;
        } else if (state.equals((Object)FileUploadRunnable.State.FINISHED)) {
            image = this.finishedIcon;
        } else if (state.equals((Object)FileUploadRunnable.State.FAILED)) {
            image = this.failedIcon;
        }
        return image;
    }

    private static String prepareText(String fileName, Exception exception) {
        String errorMessage = UploadPanel.getErrorMessage(fileName, exception);
        if (errorMessage != null) {
            return String.valueOf(fileName) + "<br/><small style=\"color: red;\">" + errorMessage + "</small>";
        }
        return fileName;
    }

    private static String getErrorToolTip(String fileName, Exception exception) {
        if (exception instanceof UploadSizeLimitExceededException) {
            UploadSizeLimitExceededException usle = (UploadSizeLimitExceededException)exception;
            if (fileName.equals(usle.getFileName())) {
                long size = usle.getSizeLimit();
                String key = "SWT_UploadFailed_SizeLimitExceeded";
                return Compatibility.getMessage((String)key, (Object[])new Object[]{UploadPanel.formatSize(size)});
            }
            return SWT.getMessage((String)"SWT_UploadFailed");
        }
        if (exception instanceof UploadTimeLimitExceededException) {
            long time = ((UploadTimeLimitExceededException)exception).getTimeLimit();
            return Compatibility.getMessage((String)"SWT_UploadFailed_TimeLimitExceeded", (Object[])new Object[]{UploadPanel.formatTime(time)});
        }
        if (exception != null) {
            return SWT.getMessage((String)"SWT_UploadFailed");
        }
        return null;
    }

    private static String getErrorMessage(String fileName, Exception exception) {
        if (exception instanceof UploadSizeLimitExceededException) {
            UploadSizeLimitExceededException usle = (UploadSizeLimitExceededException)exception;
            if (fileName.equals(usle.getFileName())) {
                long size = usle.getSizeLimit();
                String key = "SWT_UploadFailed_SizeLimitExceeded";
                return Compatibility.getMessage((String)key, (Object[])new Object[]{UploadPanel.formatSize(size)});
            }
            return null;
        }
        if (exception instanceof UploadTimeLimitExceededException) {
            long time = ((UploadTimeLimitExceededException)exception).getTimeLimit();
            return Compatibility.getMessage((String)"SWT_UploadFailed_TimeLimitExceeded", (Object[])new Object[]{UploadPanel.formatTime(time)});
        }
        if (exception != null) {
            return SWT.getMessage((String)"SWT_UploadFailed");
        }
        return null;
    }

    private static String formatSize(long size) {
        if (size >= MB) {
            return String.valueOf(Math.round(size / MB)) + " MB";
        }
        if (size >= KB) {
            return String.valueOf(Math.round(size / KB)) + " kB";
        }
        return String.valueOf(size) + " B";
    }

    private static String formatTime(long time) {
        if (time >= MIN) {
            return String.valueOf(Math.round(time / MIN)) + " min";
        }
        if (time >= SEC) {
            return String.valueOf(Math.round(time / SEC)) + " sec";
        }
        return String.valueOf(time) + " milliseconds";
    }
}

