/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.presence.collab.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerListener;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.IContainerManagerListener;
import org.eclipse.ecf.core.events.IContainerConnectedEvent;
import org.eclipse.ecf.core.events.IContainerDisconnectedEvent;
import org.eclipse.ecf.core.events.IContainerDisposeEvent;
import org.eclipse.ecf.core.events.IContainerEjectedEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.start.IECFStart;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.datashare.IChannelContainerAdapter;
import org.eclipse.ecf.internal.presence.collab.ui.Activator;
import org.eclipse.ecf.internal.presence.collab.ui.Messages;
import org.eclipse.ecf.presence.collab.ui.screencapture.ScreenCaptureShare;
import org.eclipse.ecf.presence.collab.ui.url.URLShare;
import org.eclipse.ecf.presence.collab.ui.view.ViewShare;
import org.eclipse.osgi.util.NLS;

public class ShareReceiversECFStart
implements IECFStart {
    IContainerListener containerListener = new IContainerListener(){

        public void handleEvent(IContainerEvent event) {
            Activator activator = Activator.getDefault();
            if (activator == null) {
                return;
            }
            IContainerManager containerManager = activator.getContainerManager();
            if (containerManager == null) {
                return;
            }
            IContainer container = containerManager.getContainer(event.getLocalContainerID());
            if (container == null) {
                return;
            }
            if (event instanceof IContainerConnectedEvent || event instanceof IContainerDisconnectedEvent) {
                IChannelContainerAdapter cca;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ecf.datashare.IChannelContainerAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((cca = (IChannelContainerAdapter)container.getAdapter((Class)clazz)) == null) {
                    return;
                }
                ID containerID = container.getID();
                if (event instanceof IContainerConnectedEvent) {
                    try {
                        URLShare.addURLShare(containerID, cca);
                    }
                    catch (ECFException e) {
                        Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.ecf.presence.collab.ui", 1, NLS.bind((String)Messages.ShareReceiversECFStart_STATUS_URLSHARE_NOT_CREATED, (Object)container.getID()), null));
                    }
                    try {
                        ViewShare.addViewShare(containerID, cca);
                    }
                    catch (ECFException e) {
                        Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.ecf.presence.collab.ui", 1, NLS.bind((String)Messages.ShareReceiversECFStart_STATUS_VIEWSHARE_NOT_CREATED, (Object)container.getID()), null));
                    }
                    try {
                        ScreenCaptureShare.addScreenCaptureShare(containerID, cca);
                    }
                    catch (ECFException e) {
                        Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.ecf.presence.collab.ui", 1, NLS.bind((String)Messages.ShareReceiversECFStart_STATUS_SCREENCAPTURESHARE_NOT_CREATED, (Object)container.getID()), null));
                    }
                } else if (event instanceof IContainerDisconnectedEvent || event instanceof IContainerEjectedEvent) {
                    ScreenCaptureShare scShare;
                    ViewShare viewShare;
                    URLShare urlShare = URLShare.removeURLShare(containerID);
                    if (urlShare != null) {
                        urlShare.dispose();
                    }
                    if ((viewShare = ViewShare.removeViewShare(containerID)) != null) {
                        viewShare.dispose();
                    }
                    if ((scShare = ScreenCaptureShare.removeScreenCaptureShare(containerID)) != null) {
                        scShare.dispose();
                    }
                }
            } else if (event instanceof IContainerDisposeEvent) {
                containerManager.removeListener(ShareReceiversECFStart.this.containerManagerListener);
                container.removeListener(ShareReceiversECFStart.this.containerListener);
            }
        }
    };
    IContainerManagerListener containerManagerListener = new IContainerManagerListener(){

        public void containerAdded(IContainer container) {
            IChannelContainerAdapter cca;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ecf.datashare.IChannelContainerAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((cca = (IChannelContainerAdapter)container.getAdapter((Class)clazz)) == null) {
                return;
            }
            container.addListener(ShareReceiversECFStart.this.containerListener);
        }

        public void containerRemoved(IContainer container) {
            container.removeListener(ShareReceiversECFStart.this.containerListener);
        }
    };
    static /* synthetic */ Class class$0;

    public IStatus run(IProgressMonitor monitor) {
        IContainerManager containerManager = Activator.getDefault().getContainerManager();
        if (containerManager == null) {
            return new Status(2, "org.eclipse.ecf.presence.collab.ui", 2, Messages.StartURLShareAndViewShare_ERROR_CONTAINERMANAGER_NOT_ACCESSIBLE, null);
        }
        containerManager.addListener(this.containerManagerListener);
        return Status.OK_STATUS;
    }
}

