/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.example.collab.share.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.eclipse.ecf.core.sharedobject.util.SimpleFIFOQueue;
import org.eclipse.ecf.internal.example.collab.Messages;

public class SharedObjectInputStream
extends InputStream {
    protected SimpleFIFOQueue queue = new SimpleFIFOQueue();
    int currentLength;
    int currentRead;
    boolean useCompression;
    ByteArrayInputStream inputStream;
    GZIPInputStream compressor;

    public SharedObjectInputStream(boolean compression) {
        this.useCompression = compression;
    }

    public SharedObjectInputStream() {
        this(true);
    }

    protected final void resetStreams(Data d) throws IOException {
        this.currentRead = 0;
        this.inputStream = new ByteArrayInputStream(d.getData());
        this.currentLength = d.getLength();
        if (this.useCompression) {
            this.compressor = new GZIPInputStream(this.inputStream);
        }
    }

    @Override
    public final int read() throws IOException {
        if (this.currentRead >= this.currentLength) {
            Data d = (Data)this.queue.dequeue();
            if (d == null) {
                throw new IOException(Messages.SharedObjectInputStream_EXCEPTION_NO_DATA);
            }
            this.resetStreams(d);
        }
        ++this.currentRead;
        return this.streamRead();
    }

    protected final int streamRead() throws IOException {
        if (this.useCompression) {
            return this.compressor.read();
        }
        return this.inputStream.read();
    }

    public void add(int length, byte[] d) {
        this.queue.enqueue((Object)new Data(length, d));
    }

    protected static class Data {
        int myLength;
        byte[] myData;

        protected Data(int length, byte[] d) {
            this.myLength = length;
            this.myData = d;
        }

        protected int getLength() {
            return this.myLength;
        }

        protected byte[] getData() {
            return this.myData;
        }
    }
}

