/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.filetransfer.scp;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.Session;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.core.util.StringUtils;
import org.eclipse.ecf.filetransfer.SendFileTransferException;
import org.eclipse.ecf.internal.provider.filetransfer.scp.IScpFileTransfer;
import org.eclipse.ecf.internal.provider.filetransfer.scp.Messages;
import org.eclipse.ecf.internal.provider.filetransfer.scp.ScpUtil;
import org.eclipse.ecf.provider.filetransfer.outgoing.AbstractOutgoingFileTransfer;
import org.eclipse.osgi.util.NLS;

public class ScpOutgoingFileTransfer
extends AbstractOutgoingFileTransfer
implements IScpFileTransfer {
    private static final String SCP_COMMAND = System.getProperty("org.eclipse.ecf.filetransfer.scp.outgoing.scpcommand", "scp -p -t ");
    private static final String SCP_EXEC = System.getProperty("org.eclipse.ecf.filetransfer.scp.outgoing.scpcommand", "exec");
    String username;
    private ChannelExec channel;
    private InputStream responseStream;
    private ScpUtil scpUtil;

    protected void openStreams() throws SendFileTransferException {
        try {
            File localFile = this.getFileTransferInfo().getFile();
            this.setInputStream(new BufferedInputStream(new FileInputStream(localFile)));
            URL url = this.getRemoteFileURL();
            this.username = url.getUserInfo();
            this.scpUtil = new ScpUtil(this);
            Session s = this.scpUtil.getSession();
            s.connect();
            String targetFileName = this.scpUtil.trimTargetFile(url.getPath());
            String command = String.valueOf(SCP_COMMAND) + targetFileName;
            this.channel = (ChannelExec)s.openChannel(SCP_EXEC);
            this.channel.setCommand(command);
            OutputStream outs = this.channel.getOutputStream();
            this.responseStream = this.channel.getInputStream();
            this.channel.connect();
            this.scpUtil.checkAck(this.responseStream);
            this.sendFileNameAndSize(localFile, targetFileName, outs, this.responseStream);
            this.setOutputStream(outs);
        }
        catch (Exception e) {
            throw new SendFileTransferException(NLS.bind((String)Messages.ScpOutgoingFileTransfer_EXCEPTION_CONNECTING, (Object)this.getRemoteFileURL().toString()), (Throwable)e);
        }
    }

    public Map getOptions() {
        return this.options;
    }

    public URL getTargetURL() {
        return this.getRemoteFileURL();
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    private void sendFileNameAndSize(File localFile, String fileName, OutputStream outs, InputStream ins) throws IOException {
        long filesize = localFile.length();
        String[] targetFile = StringUtils.split((String)fileName, (char)'/');
        StringBuffer command = new StringBuffer("C0644 ");
        command.append(filesize).append(" ").append(targetFile[targetFile.length - 1]).append("\n");
        outs.write(command.toString().getBytes());
        outs.flush();
        this.scpUtil.checkAck(ins);
    }

    protected void hardClose() {
        try {
            if (this.scpUtil != null) {
                this.scpUtil.sendZeroToStream(this.remoteFileContents);
                this.scpUtil.checkAck(this.responseStream);
            }
            if (this.channel != null) {
                this.channel.disconnect();
                this.channel = null;
            }
            if (this.scpUtil != null) {
                this.scpUtil.dispose();
                this.scpUtil = null;
            }
        }
        catch (IOException e) {
            this.exception = e;
        }
        this.username = null;
        super.hardClose();
    }

    protected void setupProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public String getUsername() {
        return this.username;
    }

    public IConnectContext getConnectContext() {
        return this.connectContext;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

