/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.tests.reqif10.serialization.tc500x;

import java.io.IOException;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.tests.reqif10.serialization.tc500x.TC500xS;
import org.eclipse.rmf.tests.reqif10.serialization.tc500x.TC500xT;
import org.eclipse.rmf.tests.reqif10.serialization.util.AbstractTestCase;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TC500xTests
extends AbstractTestCase {
    static final String FILENAME_TC500xS = TC500xTests.getWorkingFileName("TC500x_S.reqif");
    static ReqIF originalTC500xS = null;
    static ReqIF loadedTC500xS = null;
    static final String FILENAME_TC500xT = TC500xTests.getWorkingFileName("TC500x_T.reqif");
    static ReqIF originalTC500xT = null;
    static ReqIF loadedTC500xT = null;

    @BeforeClass
    public static void setupOnce() throws Exception {
        AbstractTestCase.setupOnce();
        originalTC500xS = new TC500xS().getReqIF();
        TC500xTests.saveReqIFFile((EObject)originalTC500xS, FILENAME_TC500xS);
        loadedTC500xS = TC500xTests.loadReqIFFile(FILENAME_TC500xS);
        originalTC500xT = new TC500xT().getReqIF();
        TC500xTests.saveReqIFFile((EObject)originalTC500xT, FILENAME_TC500xT);
        loadedTC500xT = TC500xTests.loadReqIFFile(FILENAME_TC500xT);
    }

    @Test
    public void testSchemaCompliance() throws Exception {
        this.validateAgainstSchema(FILENAME_TC500xS);
        this.validateAgainstSchema(FILENAME_TC500xT);
    }

    @Test
    public void testReqIFNotNull() {
        Assert.assertNotNull((String)"The loaded ReqIF model shall not be Null", (Object)loadedTC500xS);
        Assert.assertNotNull((String)"The loaded ReqIF model shall not be Null", (Object)loadedTC500xT);
    }

    @Test
    public void testNoProxiesSource() throws IOException {
        EcoreUtil.resolveAll((EObject)loadedTC500xS);
        Map map = EcoreUtil.ProxyCrossReferencer.find((EObject)loadedTC500xS);
        Assert.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testCountProxiesTarget() throws IOException {
        EcoreUtil.resolveAll((EObject)loadedTC500xT);
        Map map = EcoreUtil.ProxyCrossReferencer.find((EObject)loadedTC500xT);
        Assert.assertEquals((long)2L, (long)map.size());
    }

    @Test
    public void testNoXMLAnyTypeSource() {
        TreeIterator iterator = EcoreUtil.getAllContents((EObject)loadedTC500xS, (boolean)true);
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            Assert.assertFalse((boolean)(eObject instanceof AnyType));
        }
    }

    @Test
    public void testNoXMLAnyTypeTarget() {
        TreeIterator iterator = EcoreUtil.getAllContents((EObject)loadedTC500xT, (boolean)true);
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            Assert.assertFalse((boolean)(eObject instanceof AnyType));
        }
    }
}

