/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.provider;

import java.net.URISyntaxException;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.rmf.reqif10.DatatypeDefinition;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.ReqIF10Package;
import org.eclipse.rmf.reqif10.pror.provider.VirtualDatatypeDefinitionItemProvider;
import org.eclipse.rmf.reqif10.pror.util.ProrUtil;
import org.eclipse.rmf.reqif10.provider.IdentifiableTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class DatatypeDefinitionTest
extends IdentifiableTest {
    private ReqIF reqif;

    protected DatatypeDefinition getFixture() {
        return (DatatypeDefinition)this.fixture;
    }

    @Before
    public void setupReqif() throws URISyntaxException {
        this.reqif = this.getTestReqif("simple.reqif");
    }

    @Test
    public void testParentIsVirtual() throws URISyntaxException {
        ReqIF reqif = this.getTestReqif("simple.reqif");
        this.getItemProvider(reqif.getCoreContent()).getChildren((Object)reqif.getCoreContent());
        this.setViaCommand(reqif.getCoreContent(), (EStructuralFeature)ReqIF10Package.Literals.REQ_IF_CONTENT__DATATYPES, this.getFixture());
        ItemProviderAdapter ip = ProrUtil.getItemProvider((AdapterFactory)this.adapterFactory, (Object)this.getFixture());
        Assert.assertTrue((boolean)(ip.getParent((Object)this.getFixture()) instanceof VirtualDatatypeDefinitionItemProvider));
    }

    @Test
    public void testSetLastChangeAfterCreation() throws URISyntaxException {
        ReqIF reqif = this.getTestReqif("simple.reqif");
        DatatypeDefinition id = this.getFixture();
        this.setViaCommand(reqif.getCoreContent(), (EStructuralFeature)ReqIF10Package.eINSTANCE.getReqIFContent_Datatypes(), id);
        junit.framework.Assert.assertNotNull((Object)id.getLastChange());
    }

    protected EStructuralFeature getParentFeature() {
        return ReqIF10Package.eINSTANCE.getReqIFContent_Datatypes();
    }

    protected EObject getParent() {
        return this.reqif.getCoreContent();
    }
}

