/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.util;

import java.net.URISyntaxException;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.ReqIF10Factory;
import org.eclipse.rmf.reqif10.ReqIF10Package;
import org.eclipse.rmf.reqif10.ReqIFToolExtension;
import org.eclipse.rmf.reqif10.Specification;
import org.eclipse.rmf.reqif10.common.util.ReqIFToolExtensionUtil;
import org.eclipse.rmf.reqif10.pror.configuration.Column;
import org.eclipse.rmf.reqif10.pror.configuration.ConfigurationFactory;
import org.eclipse.rmf.reqif10.pror.configuration.ConfigurationPackage;
import org.eclipse.rmf.reqif10.pror.configuration.ProrGeneralConfiguration;
import org.eclipse.rmf.reqif10.pror.configuration.ProrPresentationConfigurations;
import org.eclipse.rmf.reqif10.pror.configuration.ProrToolExtension;
import org.eclipse.rmf.reqif10.pror.testframework.AbstractItemProviderTest;
import org.eclipse.rmf.reqif10.pror.util.ConfigurationUtil;
import org.junit.Assert;
import org.junit.Test;

public class ConfigurationUtilTest
extends AbstractItemProviderTest {
    @Test
    public void testGetProrToolExtensionNothingThere() throws URISyntaxException {
        ReqIF reqif = this.getTestReqif("simple.reqif");
        Assert.assertEquals((long)0L, (long)reqif.getToolExtensions().size());
        Assert.assertNotNull((Object)ConfigurationUtil.createProrToolExtension((ReqIF)reqif, (EditingDomain)this.editingDomain));
        Assert.assertEquals((long)1L, (long)reqif.getToolExtensions().size());
    }

    @Test
    public void testGetProrToolExtensionAlreadyThere() throws URISyntaxException {
        ReqIF reqif = this.getTestReqif("simple.reqif");
        Assert.assertEquals((long)0L, (long)reqif.getToolExtensions().size());
        ProrToolExtension extension = ConfigurationFactory.eINSTANCE.createProrToolExtension();
        this.commandStack.execute(ReqIFToolExtensionUtil.getAddToolExtensionCommand((ReqIF)reqif, (EObject)extension));
        Assert.assertEquals((long)1L, (long)reqif.getToolExtensions().size());
        ProrToolExtension retrieved = ConfigurationUtil.createProrToolExtension((ReqIF)reqif, (EditingDomain)this.editingDomain);
        Assert.assertEquals((long)1L, (long)reqif.getToolExtensions().size());
        Assert.assertSame((Object)extension, (Object)retrieved);
    }

    @Test
    public void testGetProrToolExtensionAnotherOneThere() throws URISyntaxException {
        ReqIF reqif = this.getTestReqif("simple.reqif");
        EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
        this.commandStack.execute(ReqIFToolExtensionUtil.getAddToolExtensionCommand((ReqIF)reqif, (EObject)ePackage));
        Assert.assertEquals((long)1L, (long)reqif.getToolExtensions().size());
        Assert.assertNotNull((Object)ConfigurationUtil.createProrToolExtension((ReqIF)reqif, (EditingDomain)this.editingDomain));
        Assert.assertEquals((long)2L, (long)reqif.getToolExtensions().size());
    }

    @Test
    public void testGetDefaultLabelsNothingThere() throws URISyntaxException {
        ReqIF reqif = this.getTestReqif("simple.reqif");
        List labels = ConfigurationUtil.getDefaultLabels((ReqIF)reqif);
        Assert.assertEquals((long)0L, (long)labels.size());
    }

    @Test
    public void testGetDefaultLabelsOnlyGeneralConfigThere() throws URISyntaxException {
        ReqIF reqif = this.getTestReqif("simple.reqif");
        ProrToolExtension extension = ConfigurationFactory.eINSTANCE.createProrToolExtension();
        this.commandStack.execute(ReqIFToolExtensionUtil.getAddToolExtensionCommand((ReqIF)reqif, (EObject)extension));
        ProrGeneralConfiguration generalConfig = ConfigurationFactory.eINSTANCE.createProrGeneralConfiguration();
        this.setViaCommand(extension, (EStructuralFeature)ConfigurationPackage.Literals.PROR_TOOL_EXTENSION__GENERAL_CONFIGURATION, generalConfig);
        Assert.assertNull((Object)generalConfig.getLabelConfiguration());
        List labels = ConfigurationUtil.getDefaultLabels((ReqIF)reqif);
        Assert.assertEquals((long)0L, (long)labels.size());
    }

    @Test
    public void testGetLeftHeaderColumn() throws URISyntaxException {
        ReqIF reqif = this.getTestReqif("simple.reqif");
        Specification specification = (Specification)reqif.getCoreContent().getSpecifications().get(0);
        Column leftHeaderColumn = ConfigurationUtil.getLeftHeaderColumn((Specification)specification, (EditingDomain)this.editingDomain);
        Assert.assertNotNull((Object)leftHeaderColumn);
    }

    @Test
    public void testGetPresentationConfigurations() {
        ReqIF reqif = ReqIF10Factory.eINSTANCE.createReqIF();
        Assert.assertNull((Object)ConfigurationUtil.getPresentationConfigurations((ReqIF)reqif));
        ReqIFToolExtension reqIFToolExtension = ReqIF10Factory.eINSTANCE.createReqIFToolExtension();
        ProrToolExtension toolExtension = ConfigurationFactory.eINSTANCE.createProrToolExtension();
        reqIFToolExtension.getExtensions().add((Object)toolExtension);
        reqif.getToolExtensions().add((Object)reqIFToolExtension);
        this.setViaCommand(reqif, (EStructuralFeature)ReqIF10Package.Literals.REQ_IF__TOOL_EXTENSIONS, toolExtension);
        Assert.assertNull((Object)ConfigurationUtil.getPresentationConfigurations((ReqIF)reqif));
        ProrPresentationConfigurations configurations = ConfigurationFactory.eINSTANCE.createProrPresentationConfigurations();
        toolExtension.setPresentationConfigurations(configurations);
        Assert.assertNotNull((Object)ConfigurationUtil.getPresentationConfigurations((ReqIF)reqif));
    }
}

