/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.configuration.provider;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.common.util.ReqIFToolExtensionUtil;
import org.eclipse.rmf.reqif10.pror.configuration.ConfigurationFactory;
import org.eclipse.rmf.reqif10.pror.configuration.ConfigurationPackage;
import org.eclipse.rmf.reqif10.pror.configuration.LabelConfiguration;
import org.eclipse.rmf.reqif10.pror.configuration.ProrGeneralConfiguration;
import org.eclipse.rmf.reqif10.pror.configuration.ProrToolExtension;
import org.eclipse.rmf.reqif10.pror.testframework.AbstractItemProviderTest;
import org.eclipse.rmf.reqif10.pror.util.ProrUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProrGeneralConfigurationTest
extends AbstractItemProviderTest {
    protected ProrGeneralConfiguration fixture = null;

    protected void setFixture(ProrGeneralConfiguration fixture) {
        this.fixture = fixture;
    }

    protected ProrGeneralConfiguration getFixture() {
        return this.fixture;
    }

    @Before
    public void setUp() throws Exception {
        this.setFixture(ConfigurationFactory.eINSTANCE.createProrGeneralConfiguration());
    }

    @After
    public void tearDown() throws Exception {
        this.setFixture(null);
    }

    @Test
    public void testNotifySpecObjects() throws Exception {
        ReqIF reqif = this.getTestReqif("simple.reqif");
        ProrToolExtension toolExtension = ConfigurationFactory.eINSTANCE.createProrToolExtension();
        toolExtension.setGeneralConfiguration(this.fixture);
        ReqIFToolExtensionUtil.addToolExtension((ReqIF)reqif, (EObject)toolExtension);
        SpecObject specObject = (SpecObject)reqif.getCoreContent().getSpecObjects().get(0);
        ItemProviderAdapter ip = ProrUtil.getItemProvider((AdapterFactory)this.adapterFactory, (Object)specObject);
        ip.addListener(this.listener);
        Assert.assertEquals((long)0L, (long)this.notifications.size());
        LabelConfiguration labelConfiguration = ConfigurationFactory.eINSTANCE.createLabelConfiguration();
        labelConfiguration.getDefaultLabel().add((Object)"Foo");
        this.setViaCommand(this.fixture, (EStructuralFeature)ConfigurationPackage.Literals.PROR_GENERAL_CONFIGURATION__LABEL_CONFIGURATION, labelConfiguration);
        Assert.assertEquals((long)1L, (long)this.notifications.size());
        this.setViaCommand(labelConfiguration, (EStructuralFeature)ConfigurationPackage.Literals.LABEL_CONFIGURATION__DEFAULT_LABEL, "Bar");
        Assert.assertEquals((long)2L, (long)this.notifications.size());
    }

    @Test
    public void testNotifyOnChange() throws Exception {
        ReqIF reqif = this.getTestReqif("simple.reqif");
        ProrToolExtension toolExtension = ConfigurationFactory.eINSTANCE.createProrToolExtension();
        toolExtension.setGeneralConfiguration(this.fixture);
        ReqIFToolExtensionUtil.addToolExtension((ReqIF)reqif, (EObject)toolExtension);
        ProrUtil.getItemProvider((AdapterFactory)this.adapterFactory, (Object)this.fixture).addListener(this.listener);
        Assert.assertEquals((long)0L, (long)this.notifications.size());
        LabelConfiguration labelConfiguration = ConfigurationFactory.eINSTANCE.createLabelConfiguration();
        this.fixture.setLabelConfiguration(labelConfiguration);
        Assert.assertEquals((long)1L, (long)this.notifications.size());
    }
}

