/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.util;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.DatatypeDefinition;
import org.eclipse.rmf.reqif10.EnumValue;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.Specification;
import org.eclipse.rmf.reqif10.XhtmlContent;
import org.eclipse.rmf.reqif10.common.util.ProrXhtmlSimplifiedHelper;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;
import org.eclipse.rmf.reqif10.common.util.ReqIF10XhtmlUtil;
import org.eclipse.rmf.reqif10.pror.configuration.Column;
import org.eclipse.rmf.reqif10.pror.configuration.ProrPresentationConfiguration;
import org.eclipse.rmf.reqif10.pror.configuration.ProrSpecViewConfiguration;
import org.eclipse.rmf.reqif10.pror.configuration.UnifiedColumn;
import org.eclipse.rmf.reqif10.pror.editor.presentation.service.IProrCellRenderer;
import org.eclipse.rmf.reqif10.pror.editor.presentation.service.PresentationEditorInterface;
import org.eclipse.rmf.reqif10.pror.util.ConfigurationUtil;
import org.eclipse.rmf.reqif10.pror.util.ProrUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLPrinter {
    private Specification spec;
    private AdapterFactory adapterFactory;
    private File sourceFolder;
    private ProrSpecViewConfiguration config;
    private File targetFolder;

    public HTMLPrinter(Specification spec, EditingDomain domain, AdapterFactory adapterFactory) {
        this.spec = spec;
        this.adapterFactory = adapterFactory;
        this.sourceFolder = new File(CommonPlugin.resolve((URI)spec.eResource().getURI()).trimSegments(1).toFileString());
        this.config = ConfigurationUtil.createSpecViewConfiguration((Specification)spec, (EditingDomain)domain);
    }

    public File print() throws IOException {
        this.targetFolder = this.createTempFolder();
        StringBuilder html = new StringBuilder();
        this.createHtmlHeader(html);
        html.append("<table>");
        this.createRowHeader(html);
        this.printRecursive(html, 0, (EList<SpecHierarchy>)this.spec.getChildren());
        html.append("</table>");
        File htmlFile = new File(this.targetFolder, String.valueOf(this.spec.getIdentifier()) + ".html");
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), Charset.forName("UTF-8").newEncoder());
        writer.write(html.toString());
        writer.close();
        htmlFile.deleteOnExit();
        return htmlFile;
    }

    private void createRowHeader(StringBuilder html) {
        html.append("<tr>");
        EList cols = this.config.getColumns();
        for (Column col : cols) {
            html.append("<td><b>" + col.getLabel() + "</b></td>");
        }
        html.append("</tr>\n");
    }

    private File createTempFolder() throws IOException {
        File targetFolder = File.createTempFile("pror-", "");
        targetFolder.delete();
        targetFolder = new File(String.valueOf(targetFolder.getAbsolutePath()) + "/");
        targetFolder.mkdir();
        return targetFolder;
    }

    private void createHtmlHeader(StringBuilder html) {
        String title = ConfigurationUtil.getSpecElementLabel((SpecElementWithAttributes)this.spec, (AdapterFactory)this.adapterFactory);
        html.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
        html.append("<html>\n");
        html.append("<head>\n");
        html.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n");
        html.append("<meta name=\"GENERATOR\" content=\"ProR (www.pror.org)\">\n");
        html.append("<title>" + title + "</title>\n");
        html.append("<style type=\"text/css\">\n");
        html.append("body {font-family: Arial, sans-serif;}\n");
        html.append("h1 {text-align: center;}\n");
        html.append("table, th, td { border-bottom: 1px solid #cccccc; }\n");
        html.append("td { padding: 2pt; }\n");
        html.append("table { border-collapse: collapse; }");
        html.append("</style>\n");
        html.append("</head>\n\n");
        html.append("<body>\n");
        html.append("<h1>" + title + "</h1>\n");
    }

    private void printRecursive(StringBuilder html, int indent, EList<SpecHierarchy> children) {
        for (SpecHierarchy child : children) {
            if (child.getObject() != null) {
                SpecObject specObject = child.getObject();
                boolean first = true;
                html.append("<tr>");
                for (Column col : this.config.getColumns()) {
                    DatatypeDefinition dd;
                    ProrPresentationConfiguration configuration;
                    ItemProviderAdapter itemProvider;
                    AttributeValue av;
                    html.append("<td valign='top'>");
                    if (first) {
                        html.append("<div style='margin-left: " + indent * 20 + "px;'>");
                    }
                    if (col instanceof UnifiedColumn) {
                        av = ReqIF10Util.getAttributeValueForLabel((SpecElementWithAttributes)specObject, (String)"ReqIF.Text");
                        if (av == null || ReqIF10Util.getTheValue((AttributeValue)av) == null) {
                            av = ReqIF10Util.getAttributeValueForLabel((SpecElementWithAttributes)specObject, (String)"ReqIF.ChapterName");
                        }
                    } else {
                        av = ReqIF10Util.getAttributeValueForLabel((SpecElementWithAttributes)specObject, (String)col.getLabel());
                    }
                    if ((itemProvider = ProrUtil.getItemProvider((AdapterFactory)this.adapterFactory, (Object)(configuration = ConfigurationUtil.getPresentationConfiguration((DatatypeDefinition)(dd = ReqIF10Util.getDatatypeDefinition((AttributeValue)av)))))) instanceof PresentationEditorInterface) {
                        PresentationEditorInterface presentationEditor = (PresentationEditorInterface)itemProvider;
                        IProrCellRenderer renderer = presentationEditor.getCellRenderer(av);
                        if (renderer != null) {
                            String content = renderer.doDrawHtmlContent(av);
                            if (content != null) {
                                html.append(content);
                            } else {
                                html.append(this.getValueAsString(av));
                            }
                        }
                    } else {
                        html.append(this.getValueAsString(av));
                    }
                    if (first) {
                        first = false;
                        html.append("</div>");
                    }
                    html.append("</td>");
                }
                html.append("</tr>\n");
            }
            this.printRecursive(html, indent + 1, (EList<SpecHierarchy>)child.getChildren());
        }
    }

    private String getValueAsString(AttributeValue av) {
        Object value;
        Object object = value = av == null ? null : ReqIF10Util.getTheValue((AttributeValue)av);
        if (value == null) {
            return "";
        }
        if (value instanceof List) {
            return this.listAsString(value);
        }
        if (value instanceof XhtmlContent) {
            return this.xhtmlAsString((XhtmlContent)value);
        }
        if (value instanceof GregorianCalendar) {
            GregorianCalendar cal = (GregorianCalendar)value;
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MMM-dd hh:mm:ss z");
            return formatter.format(cal.getTime());
        }
        return value.toString();
    }

    private String xhtmlAsString(XhtmlContent xhtmlContent) {
        String textValue = ProrXhtmlSimplifiedHelper.xhtmlToSimplifiedString((XhtmlContent)xhtmlContent);
        try {
            String xhtmlString = ReqIF10XhtmlUtil.getXhtmlString((XhtmlContent)xhtmlContent);
            xhtmlString = xhtmlString.replace("<xhtml:", "<");
            textValue = xhtmlString = xhtmlString.replace("</xhtml:", "</");
            Document dom = ReqIF10XhtmlUtil.getXhtmlDom((XhtmlContent)xhtmlContent);
            NodeList tags = dom.getElementsByTagName("xhtml:object");
            int i = 0;
            while (i < tags.getLength()) {
                Node xhtmlNode = tags.item(i);
                Node dataNode = xhtmlNode.getAttributes().getNamedItem("data");
                if (dataNode != null) {
                    String filename = dataNode.getTextContent();
                    this.copyEmbeddedObject(filename);
                }
                ++i;
            }
        }
        catch (IOException iOException) {}
        return textValue;
    }

    private void copyEmbeddedObject(String filename) {
        File fullSourceFolder = this.sourceFolder;
        File fullTargetFolder = this.targetFolder;
        StringTokenizer st = new StringTokenizer(filename, "/");
        String token = null;
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            if (!st.hasMoreTokens()) break;
            fullSourceFolder = new File(fullSourceFolder, token);
            fullTargetFolder = new File(fullTargetFolder, token);
            fullTargetFolder.mkdir();
        }
        File source = new File(fullSourceFolder, token);
        File target = new File(fullTargetFolder, token);
        try {
            Files.copy((File)source, (File)target);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String listAsString(Object value) {
        String textValue = "";
        Iterator i = ((List)value).iterator();
        while (i.hasNext()) {
            EnumValue enumValue = (EnumValue)i.next();
            textValue = String.valueOf(textValue) + enumValue.getLongName();
            if (!i.hasNext()) continue;
            textValue = String.valueOf(textValue) + ", ";
        }
        return textValue;
    }
}

