/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.presentation.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.CellEditor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.DatatypeDefinition;
import org.eclipse.rmf.reqif10.DatatypeDefinitionBoolean;
import org.eclipse.rmf.reqif10.DatatypeDefinitionDate;
import org.eclipse.rmf.reqif10.DatatypeDefinitionEnumeration;
import org.eclipse.rmf.reqif10.DatatypeDefinitionInteger;
import org.eclipse.rmf.reqif10.DatatypeDefinitionReal;
import org.eclipse.rmf.reqif10.DatatypeDefinitionString;
import org.eclipse.rmf.reqif10.DatatypeDefinitionXHTML;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;
import org.eclipse.rmf.reqif10.pror.configuration.ProrPresentationConfiguration;
import org.eclipse.rmf.reqif10.pror.configuration.ProrPresentationConfigurations;
import org.eclipse.rmf.reqif10.pror.configuration.provider.ProrPresentationConfigurationsItemProvider;
import org.eclipse.rmf.reqif10.pror.edit.presentation.service.PresentationInterface;
import org.eclipse.rmf.reqif10.pror.edit.presentation.service.PresentationManager;
import org.eclipse.rmf.reqif10.pror.editor.preferences.PreferenceConstants;
import org.eclipse.rmf.reqif10.pror.editor.presentation.Reqif10EditorPlugin;
import org.eclipse.rmf.reqif10.pror.editor.presentation.service.IProrCellRenderer;
import org.eclipse.rmf.reqif10.pror.editor.presentation.service.PresentationEditorInterface;
import org.eclipse.rmf.reqif10.pror.util.ConfigurationUtil;
import org.eclipse.rmf.reqif10.pror.util.ProrUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresentationServiceManager {
    public static final String PRESENTATION_EXTENSION_POINT_NAME = "org.eclipse.rmf.reqif10.pror.editor.presentation";
    private static Map<Class<? extends ProrPresentationConfiguration>, PresentationInterface> presentationServiceRegistry;
    private static final Map<DatatypeDefinition, PresentationEditorInterface> defaultRenderers;

    static {
        defaultRenderers = new HashMap<DatatypeDefinition, PresentationEditorInterface>();
    }

    private PresentationServiceManager() {
        throw new InstantiationError("This class is not designed to be instantiated.");
    }

    public static Map<Class<? extends ProrPresentationConfiguration>, PresentationInterface> getPresentationInterfaceMap() {
        if (presentationServiceRegistry == null) {
            IExtension[] extensions;
            HashMap<Class, PresentationInterface> tmpRegistry = new HashMap<Class, PresentationInterface>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(PRESENTATION_EXTENSION_POINT_NAME);
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    try {
                        PresentationInterface service = (PresentationInterface)configElement.createExecutableExtension("service");
                        tmpRegistry.put(service.getConfigurationInterface(), service);
                        PresentationManager.addService((Class)service.getConfigurationInterface(), (PresentationInterface)service);
                    }
                    catch (CoreException e) {
                        MessageDialog.openError(null, (String)"Plugin Configuration Error", (String)("When initializing the installed plugins, something went wrong.  You can continue working, but Presentations may not be activated:" + e.getMessage()));
                        e.printStackTrace();
                    }
                    ++n4;
                }
                ++n2;
            }
            presentationServiceRegistry = Collections.unmodifiableMap(tmpRegistry);
        }
        return presentationServiceRegistry;
    }

    public static PresentationInterface getPresentationService(ProrPresentationConfiguration configuration) {
        for (Class<? extends ProrPresentationConfiguration> clazz : PresentationServiceManager.getPresentationInterfaceMap().keySet()) {
            if (!clazz.isInstance(configuration)) continue;
            return PresentationServiceManager.getPresentationInterfaceMap().get(clazz);
        }
        return null;
    }

    public static void notifiyOpenReqif(ReqIF reqif, AdapterFactory adapterFactory, EditingDomain editingDomain) {
        ProrPresentationConfigurations configs = ConfigurationUtil.getPresentationConfigurations((ReqIF)reqif);
        if (configs == null) {
            return;
        }
        ((ProrPresentationConfigurationsItemProvider)ProrUtil.getItemProvider((AdapterFactory)adapterFactory, (Object)configs)).setEditingDomain(editingDomain);
        for (ProrPresentationConfiguration config : configs.getPresentationConfigurations()) {
            System.out.println("Registering: " + config);
            ProrUtil.getConfigItemProvider((ProrPresentationConfiguration)config, (AdapterFactory)adapterFactory).registerPresentationConfiguration(config, editingDomain);
        }
    }

    public static void notifiyCloseReqif(ReqIF reqif, AdapterFactory adapterFactory, EditingDomain editingDomain) {
        ProrPresentationConfigurations configs = ConfigurationUtil.getPresentationConfigurations((ReqIF)reqif);
        if (configs == null) {
            return;
        }
        for (ProrPresentationConfiguration config : configs.getPresentationConfigurations()) {
            System.out.println("Unregistering: " + config);
            ProrUtil.getConfigItemProvider((ProrPresentationConfiguration)config, (AdapterFactory)adapterFactory).unregisterPresentationConfiguration(config);
        }
    }

    public static PresentationInterface getPresentationService(AttributeValue value, EditingDomain editingDomain) {
        PresentationInterface service = null;
        ProrPresentationConfiguration config = ConfigurationUtil.getPresentationConfig((AttributeValue)value);
        if (config != null) {
            service = PresentationServiceManager.getPresentationService(config);
        }
        return service;
    }

    public static void clearDefaultRenderers() {
        defaultRenderers.clear();
    }

    public static IProrCellRenderer getDefaultCellRenderer(AttributeValue attrValue, AdapterFactory adapterFactory) {
        DatatypeDefinition dd = ReqIF10Util.getDatatypeDefinition((AttributeValue)attrValue);
        if (dd == null) {
            return null;
        }
        PresentationServiceManager.ensureDefaultEntry(dd, adapterFactory);
        PresentationEditorInterface presentationEditor = defaultRenderers.get(dd);
        return presentationEditor == null ? null : presentationEditor.getCellRenderer(attrValue);
    }

    public static CellEditor getDefaultCellEditor(AgileGrid agileGrid, EditingDomain editingDomain, AdapterFactory adapterFactory, AttributeValue attrValue, SpecElementWithAttributes specElement, Object affectedObject) {
        DatatypeDefinition dd = ReqIF10Util.getDatatypeDefinition((AttributeValue)attrValue);
        if (dd == null) {
            return null;
        }
        PresentationServiceManager.ensureDefaultEntry(dd, adapterFactory);
        PresentationEditorInterface presentationEditor = defaultRenderers.get(dd);
        return presentationEditor == null ? null : presentationEditor.getCellEditor(agileGrid, editingDomain, attrValue, specElement, affectedObject);
    }

    private static void ensureDefaultEntry(DatatypeDefinition dd, AdapterFactory adapterFactory) {
        if (defaultRenderers.containsKey(dd)) {
            return;
        }
        String className = PresentationServiceManager.getPresentationClassName(dd);
        Map<Class<? extends ProrPresentationConfiguration>, PresentationInterface> presentationMap = PresentationServiceManager.getPresentationInterfaceMap();
        for (Class<? extends ProrPresentationConfiguration> key : presentationMap.keySet()) {
            if (!className.equals(key.getCanonicalName())) continue;
            PresentationInterface p = presentationMap.get(key);
            ProrPresentationConfiguration config = p.getConfigurationInstance();
            config.setDatatype(dd);
            ItemProviderAdapter provider = ProrUtil.getItemProvider((AdapterFactory)adapterFactory, (Object)config);
            if (provider instanceof PresentationEditorInterface) {
                defaultRenderers.put(dd, (PresentationEditorInterface)provider);
                continue;
            }
            defaultRenderers.put(dd, null);
        }
    }

    private static String getPresentationClassName(DatatypeDefinition dd) {
        IPreferenceStore store = Reqif10EditorPlugin.getPlugin().getPreferenceStore();
        if (dd instanceof DatatypeDefinitionString) {
            return store.getString(PreferenceConstants.P_DEFAULT_PRESENTATION_STRING);
        }
        if (dd instanceof DatatypeDefinitionXHTML) {
            return store.getString(PreferenceConstants.P_DEFAULT_PRESENTATION_XHTML);
        }
        if (dd instanceof DatatypeDefinitionBoolean) {
            return store.getString(PreferenceConstants.P_DEFAULT_PRESENTATION_BOOLEAN);
        }
        if (dd instanceof DatatypeDefinitionDate) {
            return store.getString(PreferenceConstants.P_DEFAULT_PRESENTATION_DATE);
        }
        if (dd instanceof DatatypeDefinitionEnumeration) {
            return store.getString(PreferenceConstants.P_DEFAULT_PRESENTATION_ENUMERATION);
        }
        if (dd instanceof DatatypeDefinitionInteger) {
            return store.getString(PreferenceConstants.P_DEFAULT_PRESENTATION_INTEGER);
        }
        if (dd instanceof DatatypeDefinitionReal) {
            return store.getString(PreferenceConstants.P_DEFAULT_PRESENTATION_REAL);
        }
        throw new IllegalArgumentException("Not yet covered: " + dd);
    }
}

