/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.agilegrid;

import java.util.HashSet;
import java.util.Set;
import org.agilemore.agilegrid.AgileGrid;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.SpecRelation;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;
import org.eclipse.rmf.reqif10.pror.editor.agilegrid.AbstractProrSpecCellRenderer;
import org.eclipse.rmf.reqif10.pror.editor.presentation.Reqif10EditorPlugin;
import org.eclipse.rmf.reqif10.pror.util.ConfigurationUtil;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class ProrLinkCellRenderer
extends AbstractProrSpecCellRenderer {
    private Set<SpecRelation> incoming;
    private Set<SpecRelation> outgoing;
    private final Image specRelationConnectorIcon = ExtendedImageRegistry.getInstance().getImage(Reqif10EditorPlugin.INSTANCE.getImage("full/obj16/SpecRelationConnector.png"));

    public ProrLinkCellRenderer(AgileGrid agileGrid, AdapterFactory adapterFactory) {
        super(agileGrid, adapterFactory);
    }

    protected void doDrawCellContent(GC gc, Rectangle rect, int row, int col) {
        Object content = this.agileGrid.getContentAt(row, col);
        if (content instanceof SpecRelation) {
            SpecObject target = ((SpecRelation)content).getTarget();
            if (target != null) {
                String label = ConfigurationUtil.getSpecElementLabel((SpecElementWithAttributes)target, (AdapterFactory)this.adapterFactory);
                this.drawTextImage(gc, label, this.alignment, null, this.alignment, rect.x + 3, rect.y + 2, rect.width - 6, rect.height - 4);
            }
        } else if (content instanceof SpecElementWithAttributes) {
            this.updateIncomingAndOutgoing((SpecElementWithAttributes)content);
            if (this.incoming.size() == 0 && this.outgoing.size() == 0) {
                return;
            }
            String in = String.valueOf(this.incoming.size()) + " ";
            String out = " " + this.outgoing.size();
            int alignment = this.getAlignment();
            this.drawTextImage(gc, in, alignment, null, alignment, rect.x + 3, rect.y + 2, rect.width - 6, rect.height - 4);
            int offset = gc.textExtent((String)in).x;
            this.drawTextImage(gc, out, alignment, this.specRelationConnectorIcon, alignment, rect.x + 3 + offset, rect.y + 2, rect.width - 6, rect.height - 4);
        }
    }

    private void updateIncomingAndOutgoing(SpecElementWithAttributes specElement) {
        ReqIF reqif = ReqIF10Util.getReqIF((Object)specElement);
        this.incoming = new HashSet<SpecRelation>();
        this.outgoing = new HashSet<SpecRelation>();
        if (specElement == null || reqif == null) {
            return;
        }
        EList relations = reqif.getCoreContent().getSpecRelations();
        for (SpecRelation relation : relations) {
            if (relation.getTarget() != null && relation.getTarget().equals(specElement)) {
                this.incoming.add(relation);
            }
            if (relation.getSource() == null || !relation.getSource().equals(specElement)) continue;
            this.outgoing.add(relation);
        }
    }
}

