/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.tests.reqif10.serialization.uc001.tc1250;

import java.math.BigInteger;
import javax.xml.datatype.DatatypeConfigurationException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.rmf.reqif10.AttributeDefinitionXHTML;
import org.eclipse.rmf.reqif10.AttributeValueXHTML;
import org.eclipse.rmf.reqif10.DatatypeDefinitionXHTML;
import org.eclipse.rmf.reqif10.ReqIF10Factory;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.SpecObjectType;
import org.eclipse.rmf.reqif10.Specification;
import org.eclipse.rmf.reqif10.SpecificationType;
import org.eclipse.rmf.reqif10.XhtmlContent;
import org.eclipse.rmf.reqif10.xhtml.XhtmlDivType;
import org.eclipse.rmf.reqif10.xhtml.XhtmlFactory;
import org.eclipse.rmf.reqif10.xhtml.XhtmlObjectType;
import org.eclipse.rmf.reqif10.xhtml.XhtmlStrongType;
import org.eclipse.rmf.tests.reqif10.serialization.util.SimpleModelBuilder;

public class TC1250ExternalFilesBuilder
extends SimpleModelBuilder {
    static final String LAST_CHANGE_STRING = "2012-04-07T01:51:37.112+02:00";
    static final String TEST_CASE_ID = "TC1700";
    DatatypeDefinitionXHTML datatypeDefinitionXhtml;
    SpecObjectType specObjectType;
    AttributeDefinitionXHTML attributeDefinitionXhtml;
    SpecificationType specificationType;
    SpecObject specObject1;
    SpecObject specObject2;
    SpecObject specObject3;
    SpecObject specObject4;
    SpecObject specObject5;
    SpecObject specObject6;
    SpecObject specObject7;
    Specification specification;

    public TC1250ExternalFilesBuilder() throws Exception {
        super("ID_TC1250_ExternalFiles", "TC 1250 'External Files'");
    }

    @Override
    public void createDatatypes() throws Exception {
        this.datatypeDefinitionXhtml = ReqIF10Factory.eINSTANCE.createDatatypeDefinitionXHTML();
        this.datatypeDefinitionXhtml.setIdentifier("ID_TC1250_DatatypeDefinitionXhtml");
        this.datatypeDefinitionXhtml.setLongName("ReqIF.Name");
        this.datatypeDefinitionXhtml.setLastChange(this.toDate(LAST_CHANGE_STRING));
        EList datatypes = this.getReqIF().getCoreContent().getDatatypes();
        datatypes.add((Object)this.datatypeDefinitionXhtml);
    }

    @Override
    public void createSpecObjectTypes() throws Exception {
        this.specObjectType = ReqIF10Factory.eINSTANCE.createSpecObjectType();
        this.specObjectType.setIdentifier("ID_TC1250_SpecObjectType");
        this.specObjectType.setLongName("TC1250 SpecObjectType");
        this.specObjectType.setLastChange(this.toDate(LAST_CHANGE_STRING));
        this.attributeDefinitionXhtml = ReqIF10Factory.eINSTANCE.createAttributeDefinitionXHTML();
        this.attributeDefinitionXhtml.setIdentifier("ID_TC1250_AttributeDefinitionXhtml");
        this.attributeDefinitionXhtml.setLongName("TC1250 XHTML");
        this.attributeDefinitionXhtml.setLastChange(this.toDate(LAST_CHANGE_STRING));
        this.attributeDefinitionXhtml.setType(this.datatypeDefinitionXhtml);
        this.specObjectType.getSpecAttributes().add((Object)this.attributeDefinitionXhtml);
        this.getReqIF().getCoreContent().getSpecTypes().add((Object)this.specObjectType);
    }

    @Override
    public void createSpecificationTypes() throws Exception {
        this.specificationType = ReqIF10Factory.eINSTANCE.createSpecificationType();
        this.specificationType.setIdentifier("ID_TC1250_SpecificationType");
        this.specificationType.setLongName("TC1250 SpecificationType");
        this.specificationType.setLastChange(this.toDate(LAST_CHANGE_STRING));
        this.getReqIF().getCoreContent().getSpecTypes().add((Object)this.specificationType);
    }

    @Override
    public void createSpecifications() throws Exception {
        this.specification = ReqIF10Factory.eINSTANCE.createSpecification();
        this.specification.setIdentifier("ID_TC1250_Specification");
        this.specification.setType(this.specificationType);
        this.specification.setLastChange(this.toDate(LAST_CHANGE_STRING));
        this.getReqIF().getCoreContent().getSpecifications().add((Object)this.specification);
        this.addSpecHierarchy(this.specObject1);
        this.addSpecHierarchy(this.specObject2);
        this.addSpecHierarchy(this.specObject3);
        this.addSpecHierarchy(this.specObject4);
        this.addSpecHierarchy(this.specObject5);
        this.addSpecHierarchy(this.specObject6);
        this.addSpecHierarchy(this.specObject7);
    }

    private SpecHierarchy addSpecHierarchy(SpecObject specObject) throws DatatypeConfigurationException {
        SpecHierarchy specHierarchy = ReqIF10Factory.eINSTANCE.createSpecHierarchy();
        specHierarchy.setIdentifier("sh-for-" + specObject.getIdentifier());
        specHierarchy.setLastChange(this.toDate(LAST_CHANGE_STRING));
        specHierarchy.setObject(specObject);
        this.specification.getChildren().add((Object)specHierarchy);
        return specHierarchy;
    }

    @Override
    public void createSpecObjects() throws Exception {
        this.specObject1 = this.buildImage(1, "rmf-logo-300.png", 300, 131);
        this.specObject2 = this.buildSpecObject(2, "Microsoft Word", "word", ".doc", "application/msword");
        this.specObject3 = this.buildSpecObject(3, "Microsoft Word", "word", ".docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        this.specObject4 = this.buildSpecObject(4, "Microsoft Excel", "excel", ".xls", "application/vnd.ms-excel");
        this.specObject5 = this.buildSpecObject(5, "Microsoft Excel", "excel", ".xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        this.specObject6 = this.buildSpecObject(6, "Microsoft Powerpoint", "powerpoint", ".ppt", "application/vnd.ms-powerpoint");
        this.specObject7 = this.buildSpecObject(7, "Microsoft Powerpoint", "powerpoint", ".pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
    }

    private SpecObject buildImage(int i, String filename, int width, int height) throws Exception {
        SpecObject specObject = ReqIF10Factory.eINSTANCE.createSpecObject();
        specObject.setIdentifier("ID_TC1250_SpecObject" + i);
        specObject.setLastChange(this.toDate(LAST_CHANGE_STRING));
        specObject.setType(this.specObjectType);
        AttributeValueXHTML attributeValueXhtml = ReqIF10Factory.eINSTANCE.createAttributeValueXHTML();
        attributeValueXhtml.setDefinition(this.attributeDefinitionXhtml);
        specObject.getValues().add((Object)attributeValueXhtml);
        XhtmlContent xhtmlContent = ReqIF10Factory.eINSTANCE.createXhtmlContent();
        XhtmlDivType div = XhtmlFactory.eINSTANCE.createXhtmlDivType();
        XhtmlObjectType img = XhtmlFactory.eINSTANCE.createXhtmlObjectType();
        img.setType("image/png");
        img.setData("files/" + filename);
        img.setWidth((Object)new BigInteger(String.valueOf(width)));
        img.setHeight((Object)new BigInteger(String.valueOf(height)));
        div.getObject().add((Object)img);
        xhtmlContent.setXhtml((EObject)div);
        attributeValueXhtml.setTheValue(xhtmlContent);
        this.getReqIF().getCoreContent().getSpecObjects().add((Object)specObject);
        return specObject;
    }

    private SpecObject buildSpecObject(int i, String fullName, String baseFileName, String extension, String type) throws Exception {
        SpecObject specObject = ReqIF10Factory.eINSTANCE.createSpecObject();
        specObject.setIdentifier("ID_TC1250_SpecObject" + i);
        specObject.setLastChange(this.toDate(LAST_CHANGE_STRING));
        specObject.setType(this.specObjectType);
        AttributeValueXHTML attributeValueXhtml = ReqIF10Factory.eINSTANCE.createAttributeValueXHTML();
        attributeValueXhtml.setDefinition(this.attributeDefinitionXhtml);
        specObject.getValues().add((Object)attributeValueXhtml);
        XhtmlContent xhtmlContent = ReqIF10Factory.eINSTANCE.createXhtmlContent();
        XhtmlDivType div = XhtmlFactory.eINSTANCE.createXhtmlDivType();
        div.getDiv().add((Object)this.makeLabel("START", fullName, extension));
        XhtmlObjectType obj = XhtmlFactory.eINSTANCE.createXhtmlObjectType();
        obj.setType(type);
        obj.setData("files/" + baseFileName + extension);
        obj.setWidth((Object)new BigInteger("96"));
        obj.setHeight((Object)new BigInteger("96"));
        div.getObject().add((Object)obj);
        XhtmlObjectType img = XhtmlFactory.eINSTANCE.createXhtmlObjectType();
        img.setType("image/png");
        img.setData("files/" + baseFileName + ".png");
        img.setWidth((Object)new BigInteger("96"));
        img.setHeight((Object)new BigInteger("96"));
        img.getMixed().add((Object)FeatureMapUtil.createTextEntry((String)("This text is shown if altenative image can't be shown:" + baseFileName + extension)));
        obj.getObject().add((Object)img);
        div.getDiv().add((Object)this.makeLabel("END", fullName, extension));
        xhtmlContent.setXhtml((EObject)div);
        attributeValueXhtml.setTheValue(xhtmlContent);
        this.getReqIF().getCoreContent().getSpecObjects().add((Object)specObject);
        return specObject;
    }

    private XhtmlDivType makeLabel(String label, String name, String extension) {
        XhtmlStrongType strong = XhtmlFactory.eINSTANCE.createXhtmlStrongType();
        strong.getXhtmlInlineMix().add((Object)FeatureMapUtil.createTextEntry((String)(String.valueOf(name) + "(" + extension + ")")));
        XhtmlDivType div = XhtmlFactory.eINSTANCE.createXhtmlDivType();
        div.getXhtmlFlowMix().add((Object)FeatureMapUtil.createTextEntry((String)(String.valueOf(label) + " -- ")));
        div.getStrong().add((Object)strong);
        div.getXhtmlFlowMix().add((Object)FeatureMapUtil.createTextEntry((String)(" -- " + label)));
        return div;
    }
}

