/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.tests.reqif10.serialization.referencedata;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rmf.tests.reqif10.serialization.util.AbstractTestCase;
import org.junit.Assert;
import org.junit.Test;

public class ReferenceDataTests
extends AbstractTestCase {
    final String INPUT_DIR = "input";
    final String WORK_DIR = "work";

    @Test
    public void testSchemaCompliance() {
        File folder = new File("input");
        if (folder.exists() && folder.isDirectory()) {
            String[] stringArray = folder.list(new ReqIFFileNameFilter());
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                System.out.println("Reading file: " + fileName);
                try {
                    this.validateAgainstSchema("input/" + fileName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.assertFalse((boolean)true);
                }
                ++n2;
            }
        }
    }

    @Test
    public void testAllFilesInInputFolder() {
        File folder = new File("input");
        if (folder.exists() && folder.isDirectory()) {
            String[] stringArray = folder.list(new ReqIFFileNameFilter());
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                System.out.println("Reading file: " + fileName);
                try {
                    System.out.println("reading input file");
                    EObject reqIF = ReferenceDataTests.loadFile("input/" + fileName, false, (ResourceSet)ReferenceDataTests.getXMLPersistenceMappingResourceSet());
                    Assert.assertTrue((boolean)this.checkUnresolvedProxies(reqIF));
                    System.out.println("writing file");
                    ReferenceDataTests.saveReqIFFile(reqIF, "work/" + fileName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.assertFalse((boolean)true);
                }
                ++n2;
            }
        }
    }

    protected boolean checkUnresolvedProxies(EObject reqif) {
        Map map = EcoreUtil.UnresolvedProxyCrossReferencer.find((EObject)reqif);
        for (EObject eObject : map.keySet()) {
            System.out.println("Unresolved Proxy to object " + eObject);
            for (EStructuralFeature.Setting setting : (Collection)map.get(eObject)) {
                System.out.println("-" + setting.getEStructuralFeature().getName() + " of  " + setting.getEObject());
            }
        }
        return map.size() == 0;
    }

    class ReqIFFileNameFilter
    implements FilenameFilter {
        ReqIFFileNameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith("reqif");
        }
    }
}

